package com.chinayanghe.tpm.cost.constants;

import java.util.LinkedHashMap;
import java.util.Map;

public class FormConfigConstants {
	/**
	 * 管理信息
	 */
	public static Map<String, String> MANAGE_INFO = new LinkedHashMap<>();
	/**
	 * 活动基础信息
	 */
	public static Map<String, String> ACTIVITY_BASE_INFO = new LinkedHashMap<>();
	/**
	 * 活动明细信息
	 */
	public static Map<String, String> ACTIVITY_INFO_DETAIL = new LinkedHashMap<>();
	
	/**
	 * 活动申请
	 */
	public static Map<String, Map> ACTIVITY_TYPE = new LinkedHashMap<>();
	/**
	 * 消费者宴席推广
	 */
	public static Map<String, Map> CUSTOMER_FEAST = new LinkedHashMap<>();
	/**
	 * 消费者宴会申请
	 */
	public static Map<String, String> CUSTOMER_FEAST_APPLY = new LinkedHashMap<>();
	/**
	 * 消费者宴会登记
	 */
	public static Map<String, String> CUSTOMER_FEAST_REGIST = new LinkedHashMap<>();
	/**
	 * 消费者宴会核报
	 */
	public static Map<String, String> CUSTOMER_FEAST_PAY = new LinkedHashMap<>();
	/**
	 * 赠品信息
	 */
	public static Map<String, String> GIFT_BASE_INFO = new LinkedHashMap<>();
	
	/**
	 * 部队慰问
	 */
	public static Map<String,Map> TROOP_CARE = new LinkedHashMap<>();
	/**
	 * 部队慰问申请表
	 */
	public static Map<String, String> TROOP_CARE_APPLY = new LinkedHashMap<>();
	/**
	 * 部队慰问登记表
	 */
	public static Map<String, String> TROOP_CARE_REGIST = new LinkedHashMap<>();
	/**
	 * 部队慰问核报表
	 */
	public static Map<String, String> TROOP_CARE_PAY = new LinkedHashMap<>();
	
	static{
		MANAGE_INFO.put("主键ID", "id");
		MANAGE_INFO.put("表单编号", "formNo");
		MANAGE_INFO.put("表单类型", "formType");
		MANAGE_INFO.put("标题", "title");
		MANAGE_INFO.put("电话", "tel");
		MANAGE_INFO.put("授权开始日期", "sDate");
		MANAGE_INFO.put("授权结束日期", "eDate");
		MANAGE_INFO.put("申请单审核日期", "applyAuditDate");
		MANAGE_INFO.put("关联申请单号", "applyNo");
		MANAGE_INFO.put("关联核报单号", "payNo");
		MANAGE_INFO.put("关联登记单号", "registNo");
		MANAGE_INFO.put("一级部门编号", "department1Id");
		MANAGE_INFO.put("一级部门名称", "department1Name");
		MANAGE_INFO.put("二级部门编号", "department2Id");
		MANAGE_INFO.put("二级部门名称", "department2Name");
		MANAGE_INFO.put("三级部门编号", "department3Id");
		MANAGE_INFO.put("三级部门名称", "department3Name");
		MANAGE_INFO.put("四级部门编号", "department4Id");
		MANAGE_INFO.put("四级部门名称", "department4Name");
		MANAGE_INFO.put("五级部门编号", "department5Id");
		MANAGE_INFO.put("五级部门名称", "department5Name");
		MANAGE_INFO.put("大区", "bzirktId");
		MANAGE_INFO.put("大区名称", "bzirktName");
		MANAGE_INFO.put("公司ID", "companyId");
		MANAGE_INFO.put("公司名称", "companyName");
		MANAGE_INFO.put("分公司ID", "companySubId");
		MANAGE_INFO.put("分公司名称", "companySubName");
		MANAGE_INFO.put("新江苏编号", "newJsId");
		MANAGE_INFO.put("新江苏名称", "newJsName");
		MANAGE_INFO.put("level1Ameba", "level1Ameba");
		MANAGE_INFO.put("level1Ameba", "level2Ameba");
		MANAGE_INFO.put("costId", "costId");
		MANAGE_INFO.put("费用类型", "costType");
		MANAGE_INFO.put("岗位编码", "posCode");
		MANAGE_INFO.put("岗位名称 ", "posName");

	    ACTIVITY_BASE_INFO.put("主键ID","id");
	    ACTIVITY_BASE_INFO.put("表单号","formNo");
	    ACTIVITY_BASE_INFO.put("表单类型","formType");
	    ACTIVITY_BASE_INFO.put("开始日期","sDate");
	    ACTIVITY_BASE_INFO.put("结束日期","eDate");
	    ACTIVITY_BASE_INFO.put("客户编号","kunnr");
	    ACTIVITY_BASE_INFO.put("经销商一级渠道","level1Channel");
	    ACTIVITY_BASE_INFO.put("经销商2级渠道","level2Channel");
	    ACTIVITY_BASE_INFO.put("品牌大类","spart");
	    ACTIVITY_BASE_INFO.put("活动类型编码","activityTypeCode");
	    ACTIVITY_BASE_INFO.put("活动类型名称","activityTypeName");
	    ACTIVITY_BASE_INFO.put("活动类型2级编码","activityTypeCodeSub");
	    ACTIVITY_BASE_INFO.put("活动类型2级名称","activityTypeNameSub");
	    ACTIVITY_BASE_INFO.put("经销商编号","dealerId");
	    ACTIVITY_BASE_INFO.put("经销商名称","dealerName");
	    ACTIVITY_BASE_INFO.put("经销商类型","dealerType");
	    ACTIVITY_BASE_INFO.put("区域市场","regionMkt");
	    ACTIVITY_BASE_INFO.put("城市经理编号","zcmId");
	    ACTIVITY_BASE_INFO.put("城市经理名称","zcmName");
	    ACTIVITY_BASE_INFO.put("特殊备注","speNotes");
	    ACTIVITY_BASE_INFO.put("厂方承担金额","addAssumeAmt");
	    ACTIVITY_BASE_INFO.put("活动金额","activityAmount");
	    ACTIVITY_BASE_INFO.put("合计金额","totalAmount");
	    ACTIVITY_BASE_INFO.put("金额","amount");
	    ACTIVITY_BASE_INFO.put("费用类型","costType");
	    ACTIVITY_BASE_INFO.put("费用类型名称","costTypeName");
	    ACTIVITY_BASE_INFO.put("审核金额合计","auditAmount");
	    ACTIVITY_BASE_INFO.put("复核金额合计","reviewAmount");
	    ACTIVITY_BASE_INFO.put("终审核金额","finalAmount");
	    ACTIVITY_BASE_INFO.put("促销类型","promoteType");
	    ACTIVITY_BASE_INFO.put("是否个性化促销","isIndividualPromote");
	    ACTIVITY_BASE_INFO.put("渠道","channel");
	    ACTIVITY_BASE_INFO.put(" 账务处理方式","accountTreat");
	    ACTIVITY_BASE_INFO.put("入帐经销商编号","entryDealerId");
	    ACTIVITY_BASE_INFO.put("入帐经销商名称","entryDealerName");
	    ACTIVITY_BASE_INFO.put("是否督查扣款","isPayment");
	    ACTIVITY_BASE_INFO.put("关联申请单号","applyNo");
	    ACTIVITY_BASE_INFO.put("关联核报单号","payNo");
	    ACTIVITY_BASE_INFO.put("关联登记单号","registNo");
	    ACTIVITY_BASE_INFO.put("状态","status");
	    ACTIVITY_BASE_INFO.put("预估销量瓶数","saleForecastNum");
	    ACTIVITY_BASE_INFO.put("预估销售金额","saleForecastAmount");
	    ACTIVITY_BASE_INFO.put("是否促销","isPromote");
	    ACTIVITY_BASE_INFO.put("促销品采购方式","promoteProductBuyway");
	    ACTIVITY_BASE_INFO.put("促销总金额","promoteAmountTotal");
	    ACTIVITY_BASE_INFO.put("登记意见","registNotes");
	    ACTIVITY_BASE_INFO.put("活动投入实施说明","activityNotes");
	    ACTIVITY_BASE_INFO.put("督查汇总意见","auditNotes");
	    ACTIVITY_BASE_INFO.put("是否督查扣款","idAuditWithhold");
	    ACTIVITY_BASE_INFO.put("活动投入类型","activityInputType");
	    ACTIVITY_BASE_INFO.put("是使用赠酒卡","isUseGiftCard");
	    ACTIVITY_BASE_INFO.put("赠饮对象","giftWineObj");
	    ACTIVITY_BASE_INFO.put(" 赠饮目的","giftNotes");
	    ACTIVITY_BASE_INFO.put("推广品牌编码","brandId");
	    ACTIVITY_BASE_INFO.put("推广品牌名称","brandName");
	    ACTIVITY_BASE_INFO.put("投入方式","inputWay");
	    ACTIVITY_BASE_INFO.put("表单特殊类型","formPurpose");
	    

	    ACTIVITY_INFO_DETAIL.put("主键ID","id");
	    ACTIVITY_INFO_DETAIL.put("表单编号","formNo");
	    ACTIVITY_INFO_DETAIL.put("表单类型","formType");
	    ACTIVITY_INFO_DETAIL.put("单位名称","companyName");
	    ACTIVITY_INFO_DETAIL.put("省编码","provinceId");
	    ACTIVITY_INFO_DETAIL.put("省名称","provinceName");
	    ACTIVITY_INFO_DETAIL.put("市编码","cityId");
	    ACTIVITY_INFO_DETAIL.put("市名称","cityName");
	    ACTIVITY_INFO_DETAIL.put("区县编码","countyId");
	    ACTIVITY_INFO_DETAIL.put("区县名称","countyName");
	    ACTIVITY_INFO_DETAIL.put("详细地址","detailAddress");
	    ACTIVITY_INFO_DETAIL.put("固定电话","tel");
	    ACTIVITY_INFO_DETAIL.put("移动电话","mobilePhone");
	    ACTIVITY_INFO_DETAIL.put("开始日期","sDate");
	    ACTIVITY_INFO_DETAIL.put("结束日期","eDate");
	   
	    CUSTOMER_FEAST_APPLY.put("主键ID","id");
	    CUSTOMER_FEAST_APPLY.put("申请单号","applyNo");
	    CUSTOMER_FEAST_APPLY.put("费用类型编码","costTypeId");
	    CUSTOMER_FEAST_APPLY.put("费用类型名称","costTypeName");
	    CUSTOMER_FEAST_APPLY.put("受赠客户","donee");
	    CUSTOMER_FEAST_APPLY.put("产品编码","productId");
	    CUSTOMER_FEAST_APPLY.put("产品名称","productName");
	    CUSTOMER_FEAST_APPLY.put("结算价","productPrice");
	    CUSTOMER_FEAST_APPLY.put("活动售价","activityPrice");
	    CUSTOMER_FEAST_APPLY.put("活动桌数","activityTableNum");
	    CUSTOMER_FEAST_APPLY.put("购买瓶数","buyNum");
	    CUSTOMER_FEAST_APPLY.put("赠酒情况","giftWineNotes");
	    CUSTOMER_FEAST_APPLY.put("赠品备注","giftNotes");
	    CUSTOMER_FEAST_APPLY.put("预计产生费用","expectCost");
	    CUSTOMER_FEAST_APPLY.put("厂方承担比例","compayScale");
	    CUSTOMER_FEAST_APPLY.put("厂方承担金额","compayAmount");
	    CUSTOMER_FEAST_APPLY.put("审核金额","auditAmount");
	    CUSTOMER_FEAST_APPLY.put("状态","status");


	    CUSTOMER_FEAST_REGIST.put("主键ID","id");
	    CUSTOMER_FEAST_REGIST.put("申请单号","applyNo");
	    CUSTOMER_FEAST_REGIST.put("登记单号","registNo");
	    CUSTOMER_FEAST_REGIST.put("临时报备单号","reportedNo");
	    CUSTOMER_FEAST_REGIST.put("申请单行项目号","itemNo");
	    CUSTOMER_FEAST_REGIST.put("费用类型名称","costTypeName");
	    CUSTOMER_FEAST_REGIST.put("费用类型ID","costTypeId");
	    CUSTOMER_FEAST_REGIST.put("家宴日期","feastDate");
	    CUSTOMER_FEAST_REGIST.put("时段","feastTime");
	    CUSTOMER_FEAST_REGIST.put("家宴性质类型","feastType");
	    CUSTOMER_FEAST_REGIST.put("家宴性质类型名称","feastTypeName");
	    CUSTOMER_FEAST_REGIST.put("宴会地址id","feastAddressId");
	    CUSTOMER_FEAST_REGIST.put("宴会地点","feastAddressDetail");
	    CUSTOMER_FEAST_REGIST.put("宴会地址联系电话","tel");
	    CUSTOMER_FEAST_REGIST.put("具体地址","addressDetail");
	    CUSTOMER_FEAST_REGIST.put("桌数","tableNum");
	    CUSTOMER_FEAST_REGIST.put("产品编号","productId");
	    CUSTOMER_FEAST_REGIST.put("产品名称","productName");
	    CUSTOMER_FEAST_REGIST.put("结算价","productPrice");
	    CUSTOMER_FEAST_REGIST.put("购买数量/瓶","buyNum");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品1编号","giftProduct1Id");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品1名称","giftProduct1Name");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品1数量","giftProduct1Num");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品2编号","giftProduct2Id");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品2名称","giftProduct2Name");
	    CUSTOMER_FEAST_REGIST.put("赠酒产品2数量","giftProduct2Num");
	    CUSTOMER_FEAST_REGIST.put("搭赠情况","giftNotes");
	    CUSTOMER_FEAST_REGIST.put("当事人","person");
	    CUSTOMER_FEAST_REGIST.put("当事人联系电话","personTel");
	    CUSTOMER_FEAST_REGIST.put("经办人","handlePerson");
	    CUSTOMER_FEAST_REGIST.put("经办人电话","handlePersonTel");
	    CUSTOMER_FEAST_REGIST.put("开始时间","sDate");
	    CUSTOMER_FEAST_REGIST.put("结束时间","eDate");
	    CUSTOMER_FEAST_REGIST.put("单位名称","companyName");
	    CUSTOMER_FEAST_REGIST.put("单位地址","companyAddress");
	    CUSTOMER_FEAST_REGIST.put("职务","position");
	    CUSTOMER_FEAST_REGIST.put("实际金额","actualAmount");
	    CUSTOMER_FEAST_REGIST.put("厂方承担金额/元","compayAmount");
	    CUSTOMER_FEAST_REGIST.put("厂方承担比例","compayScale");
	    CUSTOMER_FEAST_REGIST.put("行项目余额","itemBalance");
	    CUSTOMER_FEAST_REGIST.put("备注","notes");
	    CUSTOMER_FEAST_REGIST.put("督查意见","auditNotes");
	    CUSTOMER_FEAST_REGIST.put("状态","status");
	    CUSTOMER_FEAST_REGIST.put("登记类型","type");
	    CUSTOMER_FEAST_REGIST.put("当事人与经办人关系","pmRelation");
	    
	    CUSTOMER_FEAST_PAY.put("主键ID","id");
	    CUSTOMER_FEAST_PAY.put("登记单号","registNo");
	    CUSTOMER_FEAST_PAY.put("申请单号","applyNo");
	    CUSTOMER_FEAST_PAY.put("核报单号","payNo");
	    CUSTOMER_FEAST_PAY.put("等级行项目号","registItemNo");
	    CUSTOMER_FEAST_PAY.put("费用类型名称","costTypeName");
	    CUSTOMER_FEAST_PAY.put("费用类型ID","costTypeId");
	    CUSTOMER_FEAST_PAY.put("桌数","tableNum");
	    CUSTOMER_FEAST_PAY.put("产品编号","productId");
	    CUSTOMER_FEAST_PAY.put("产品名称","productName");
	    CUSTOMER_FEAST_PAY.put("结算价","productPrice");
	    CUSTOMER_FEAST_PAY.put("行项目余额","itemBalance");
	    CUSTOMER_FEAST_PAY.put("购买数量/瓶","buyNum");
	    CUSTOMER_FEAST_PAY.put("赠酒产品1编号","giftProduct1Id");
	    CUSTOMER_FEAST_PAY.put("赠酒产品1名称","giftProduct1Name");
	    CUSTOMER_FEAST_PAY.put("赠酒产品1数量","giftProduct1Num");
	    CUSTOMER_FEAST_PAY.put("赠酒产品2编号","giftProduct2Id");
	    CUSTOMER_FEAST_PAY.put("赠酒产品2名称","giftProduct2Name");
	    CUSTOMER_FEAST_PAY.put("赠酒产品2数量","giftProduct2Num");
	    CUSTOMER_FEAST_PAY.put("厂方承担金额","compayAmount");
	    CUSTOMER_FEAST_PAY.put("厂方承担比例","compayScale");
	    CUSTOMER_FEAST_PAY.put("核报金额","auditAmount");
	    CUSTOMER_FEAST_PAY.put("督查意见","auditNotes");
	    
	    GIFT_BASE_INFO.put("主键ID","id");
	    GIFT_BASE_INFO.put("表单类型"," formType");
	    GIFT_BASE_INFO.put("表单编号"," formNo");
	    GIFT_BASE_INFO.put("商品ID"," productId");
	    GIFT_BASE_INFO.put("商品名称"," productName");
	    GIFT_BASE_INFO.put("商品价格","productPrice");
	    GIFT_BASE_INFO.put("活动售价","activityPrice");
	    GIFT_BASE_INFO.put("赠送数量","giftNum");
	    GIFT_BASE_INFO.put("状态","status");
	    GIFT_BASE_INFO.put("赠送类型","giftType");
	    
	    CUSTOMER_FEAST.put("消费者宴会申请", CUSTOMER_FEAST_APPLY);
	    CUSTOMER_FEAST.put("消费者宴会登记", CUSTOMER_FEAST_REGIST);
	    CUSTOMER_FEAST.put("消费者宴会核报", CUSTOMER_FEAST_PAY);
	    CUSTOMER_FEAST.put("赠品信息", GIFT_BASE_INFO);
	    ACTIVITY_TYPE.put("211801", CUSTOMER_FEAST);
	    
	    CUSTOMER_FEAST.put("部队慰问申请", TROOP_CARE_APPLY);
	    CUSTOMER_FEAST.put("部队慰问登记", TROOP_CARE_REGIST);
	    CUSTOMER_FEAST.put("部队慰问核报", TROOP_CARE_PAY);
	    ACTIVITY_TYPE.put("211802", TROOP_CARE);
	}
}
