package com.chinayanghe.tpm.cost.constants;
/**
 * 人员变更状态
 * @author gaopan
 *
 */
public enum PersonChangeStatusEnum {
    NORMAL("1", "不变"), REMOVE("2", "离职"),ADD("3","新增");

    String    code;
    String desc;

    PersonChangeStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
    
    public static String jqGridSelect(){
    	StringBuilder sb =new StringBuilder();
    	for(PersonChangeStatusEnum obj:PersonChangeStatusEnum.values()){
    		sb.append(obj.getCode()).append(":").append(obj.getDesc()).append(";");
    	}
    	if(sb.length()>1){
    		sb.deleteCharAt(sb.length()-1);
    	}
    	return sb.toString();
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
