package com.chinayanghe.tpm.cost.constants;

/**
 * 流程类型
 * @author gaopan
 *
 */
public enum ProcessTypeEnum {
    areaPointAdAudit("区域点上广告核报表"), areaSurFaceAdAudit("区域面上广告核报表"), areaPointDonationAudit("区域点上赞助捐赠核报"),
    areaPointEvnetEconomyAudit("区域点上事件营销核报"), areaSurfaceEvnetEconomyAudit("区域面上事件营销核报"),
    channelGuestFeelingMeetingAudit("渠道客情维系核报（会议）"), channelGuestFeelingOtherAudit("渠道客情维系核报（其他）"),
    channelGuestFeelingTastingAudit("渠道客情维系核报（一桌式品鉴)"), doorNumberMadeAudit("门头牌制作核报"),
    channelPublicityExpensesAudit("渠道宣传费核报"), selfTasingAudit("个人品鉴核报"), unitGiftWineAudit("单位赠酒核报"),
    troopsSympathyAudit("部队慰问核报"), InTheHotalAudit("酒店进场核报"), ultraTerminalApproachAudit("商超终端进场核报"),
    hotelProductAwardAudit("酒店个性化产品奖励核报"), superBarcodeRegisterAudit("商超条码注册核报"), fitmentAudit("装修核报表"),
    rentAudit("租金核报表"), buyGiftPromotionAudit("买赠促销核报"), buyGiftPromotionAwardAudit("买赠促销（奖卡）核报"),
    consumerBanquetAudit("消费者宴席推广核报");

    private String name;    // 流程名称

    ProcessTypeEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
