package com.chinayanghe.tpm.cost.constants;
/**
 * 销量控制状态
 * @author gaopan
 *
 */
public enum SaleLimitStatus {
	transferred(10, "已转入"),
	frozen(20, "已冻结"),
	back(25, "已驳回"),
	reported(30,"已核报"),
	returned(40,"已退货"),
	delete(50,"已删除");

    int    code;
    String desc;

    SaleLimitStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SaleLimitStatus codeTransformEnum(int code){
        SaleLimitStatus[] values = SaleLimitStatus.values();
        for (SaleLimitStatus value : values) {
            if(value.getCode() == code){
                return value;
            }
        }
        return null;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
