package com.chinayanghe.tpm.cost.constants;

import org.apache.commons.lang.StringUtils;

/**
 * 二级活动类型
 * @author gaopan
 *
 */
public enum SecondActivityTypeEnum {

    countrySurfaceAd("210101", "全国面上广告"), 
    areaSurfaceAd("210102", "区域面上广告"), 
    areaPointAd("210103", "区域点上广告"),
    wineInputAd("210104",	"葡萄酒广告投入"),
    areaPoingDonate("210201", "区域点上赞助捐赠"),
    areaPointEventMarketing("210301", "区域点上事件营销"),
    areaSurfaceEventMarketing("210302", "区域面上事件营销"), 
    chanelLaborExpenditure("210401", "渠道劳务支出"),
    chanelCustomersApply("2107", "渠道客情维系"), 
    chanelCustomersPersonal("210701", "渠道客情维系一桌式品鉴"),
    chanelCustomersMeeting("210702", "渠道客情维系会议"),
    chanelCustomersOther("210704", "渠道客情维系其他"),
    sepecialExpenses("220301", "专项费用"), 
    doorTitleMaking("210801", "门头牌制作"),
    chanelPublicityExpenses("210902", "渠道宣传费"),
    doorFrameMaking("210802", "门头牌制作表(框架版)"),
    travelService("211091",    "旅游服务订单"),
    unitGift("211002", "单位赠酒"),
    grapeWineAdvert("210104", "葡萄酒广告申请"),
    grapeWineMarketing("210303", "葡萄酒事件营销申请"),
    grapeWineCustomersRelation("210703", "葡萄酒客情维系投入申请"),
    grapeWineSponsor("210202", "葡萄酒赞助投入申请"),
    troopsCondole("211003", "部队慰问"),
    terminalAward("211101", "终端达标奖励"),
    terminalTeamAward("211102", "终端达标奖励（团购版）"), 
    hotelEnter("211201", "酒店进场"),
    maketTerminalEnter("211202", "商超终端进场"),
    hotelIndividuation("211301", "酒店个性化产品奖励"),
    barcodeRegister("211401", "商超条码注册"), 
    exclusiveShopSupport("211501", "专卖店支持"),
    promotionProduct("211601", "常规促销品"),
    normalGuestfrees("220101", "常规客情费用"),
    consumerPromotion("211701", "消费者促销"), 
    consumerGeneralize("211801", "消费者宴席推广"),
    consumerFeast("211802", "家宴专用产品消费者宴席推广"),
    personalReview("211001", "个人品鉴"),
    personalAwardDelay("13", "个性化奖卡延期"),
    guestReceive("212501", "来宾接待");


    private String code;
    private String desc;

    SecondActivityTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SecondActivityTypeEnum getByCode(String code) {
        SecondActivityTypeEnum[] activityTypeEnums =  SecondActivityTypeEnum.values();
        for(SecondActivityTypeEnum activityTypeEnum : activityTypeEnums) {
            if(StringUtils.equals( activityTypeEnum.getCode(),code)) {
                return activityTypeEnum;
            }
        }
        return null;
    }

}

