package com.chinayanghe.tpm.cost.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 消费者宴会申请
 * CustomerFeastApplyDto
 * 数据库表：customer_feast_apply
 */
public class CustomerFeastApplyDto implements Serializable {

    /**
     * 
     * 表字段 : customer_feast_apply.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : customer_feast_apply.apply_no
     */
    private String applyNo;
    private String itemNo;

    /**
     * 行项目余额
     * 表字段 : customer_feast_regist.item_balance_amount
     */
    private Long itemBalance;
    /**
     * 费用类型编码
     * 表字段 : customer_feast_apply.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : customer_feast_apply.cost_type_name
     */
    private String costTypeName;

    /**
     * 受赠客户
     * 表字段 : customer_feast_apply.donee
     */
    private String donee;

    /**
     * 产品编码
     * 表字段 : customer_feast_apply.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : customer_feast_apply.product_name
     */
    private String productName;

    /**
     * 结算价(分)
     * 表字段 : customer_feast_apply.product_price
     */
    private Long productPrice;

    /**
     * 活动售价(分)
     * 表字段 : customer_feast_apply.activity_price
     */
    private Integer activityPrice;

    /**
     * 活动桌数
     * 表字段 : customer_feast_apply.activity_table_num
     */
    private Integer activityTableNum;

    /**
     * 购买瓶数
     * 表字段 : customer_feast_apply.buy_num
     */
    private Integer buyNum;

    /**
     * 赠酒情况
     * 表字段 : customer_feast_apply.gift_wine_notes
     */
    private String giftWineNotes;

    /**
     * 
     * 表字段 : customer_feast_apply.gift_notes
     */
    private String giftNotes;

    /**
     * 预计产生费用
     * 表字段 : customer_feast_apply.expect_cost
     */
    private Long expectCost;

    /**
     * 厂方承担比例
     * 表字段 : customer_feast_apply.compay_scale
     */
    private Double compayScale;

    /**
     * 厂方承担金额
     * 表字段 : customer_feast_apply.compay_amount
     */
    private Long compayAmount;

    /**
     * 审核金额(分)
     * 表字段 : customer_feast_apply.audit_amount
     */
    private Long auditAmount;

    /**
     * 状态
     * 表字段 : customer_feast_apply.status
     */
    private Integer status;

    /**
     * 
     * 表字段 : customer_feast_apply.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : customer_feast_apply.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : customer_feast_apply.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table customer_feast_apply
     *
     * @mbggenerated Fri May 12 15:46:37 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:customer_feast_apply.id
     *
     * @return customer_feast_apply.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:customer_feast_apply.id
     *
     * @param id the value for customer_feast_apply.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:customer_feast_apply.apply_no
     *
     * @return customer_feast_apply.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:customer_feast_apply.apply_no
     *
     * @param applyNo the value for customer_feast_apply.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 费用类型编码 字段:customer_feast_apply.cost_type_id
     *
     * @return customer_feast_apply.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:customer_feast_apply.cost_type_id
     *
     * @param costTypeId the value for customer_feast_apply.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:customer_feast_apply.cost_type_name
     *
     * @return customer_feast_apply.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:customer_feast_apply.cost_type_name
     *
     * @param costTypeName the value for customer_feast_apply.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 受赠客户 字段:customer_feast_apply.donee
     *
     * @return customer_feast_apply.donee, 受赠客户
     */
    public String getDonee() {
        return donee;
    }

    /**
     * 设置 受赠客户 字段:customer_feast_apply.donee
     *
     * @param donee the value for customer_feast_apply.donee, 受赠客户
     */
    public void setDonee(String donee) {
        this.donee = donee;
    }

    /**
     * 获取 产品编码 字段:customer_feast_apply.product_id
     *
     * @return customer_feast_apply.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:customer_feast_apply.product_id
     *
     * @param productId the value for customer_feast_apply.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:customer_feast_apply.product_name
     *
     * @return customer_feast_apply.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:customer_feast_apply.product_name
     *
     * @param productName the value for customer_feast_apply.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 结算价(分) 字段:customer_feast_apply.product_price
     *
     * @return customer_feast_apply.product_price, 结算价(分)
     */
    public Long getProductPrice() {
        return productPrice;
    }

    /**
     * 设置 结算价(分) 字段:customer_feast_apply.product_price
     *
     * @param productPrice the value for customer_feast_apply.product_price, 结算价(分)
     */
    public void setProductPrice(Long productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * 获取 活动售价(分) 字段:customer_feast_apply.activity_price
     *
     * @return customer_feast_apply.activity_price, 活动售价(分)
     */
    public Integer getActivityPrice() {
        return activityPrice;
    }

    /**
     * 设置 活动售价(分) 字段:customer_feast_apply.activity_price
     *
     * @param activityPrice the value for customer_feast_apply.activity_price, 活动售价(分)
     */
    public void setActivityPrice(Integer activityPrice) {
        this.activityPrice = activityPrice;
    }

    /**
     * 获取 活动桌数 字段:customer_feast_apply.activity_table_num
     *
     * @return customer_feast_apply.activity_table_num, 活动桌数
     */
    public Integer getActivityTableNum() {
        return activityTableNum;
    }

    /**
     * 设置 活动桌数 字段:customer_feast_apply.activity_table_num
     *
     * @param activityTableNum the value for customer_feast_apply.activity_table_num, 活动桌数
     */
    public void setActivityTableNum(Integer activityTableNum) {
        this.activityTableNum = activityTableNum;
    }

    /**
     * 获取 购买瓶数 字段:customer_feast_apply.buy_num
     *
     * @return customer_feast_apply.buy_num, 购买瓶数
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 购买瓶数 字段:customer_feast_apply.buy_num
     *
     * @param buyNum the value for customer_feast_apply.buy_num, 购买瓶数
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取 赠酒情况 字段:customer_feast_apply.gift_wine_notes
     *
     * @return customer_feast_apply.gift_wine_notes, 赠酒情况
     */
    public String getGiftWineNotes() {
        return giftWineNotes;
    }

    /**
     * 设置 赠酒情况 字段:customer_feast_apply.gift_wine_notes
     *
     * @param giftWineNotes the value for customer_feast_apply.gift_wine_notes, 赠酒情况
     */
    public void setGiftWineNotes(String giftWineNotes) {
        this.giftWineNotes = giftWineNotes;
    }

    /**
     * 获取  字段:customer_feast_apply.gift_notes
     *
     * @return customer_feast_apply.gift_notes, 
     */
    public String getGiftNotes() {
        return giftNotes;
    }

    /**
     * 设置  字段:customer_feast_apply.gift_notes
     *
     * @param giftNotes the value for customer_feast_apply.gift_notes, 
     */
    public void setGiftNotes(String giftNotes) {
        this.giftNotes = giftNotes;
    }

    /**
     * 获取 预计产生费用 字段:customer_feast_apply.expect_cost
     *
     * @return customer_feast_apply.expect_cost, 预计产生费用
     */
    public Long getExpectCost() {
        return expectCost;
    }

    /**
     * 设置 预计产生费用 字段:customer_feast_apply.expect_cost
     *
     * @param expectCost the value for customer_feast_apply.expect_cost, 预计产生费用
     */
    public void setExpectCost(Long expectCost) {
        this.expectCost = expectCost;
    }

    /**
     * 获取 厂方承担比例 字段:customer_feast_apply.compay_scale
     *
     * @return customer_feast_apply.compay_scale, 厂方承担比例
     */
    public Double getCompayScale() {
        return compayScale;
    }

    /**
     * 设置 厂方承担比例 字段:customer_feast_apply.compay_scale
     *
     * @param compayScale the value for customer_feast_apply.compay_scale, 厂方承担比例
     */
    public void setCompayScale(Double compayScale) {
        this.compayScale = compayScale;
    }

    /**
     * 获取 厂方承担金额 字段:customer_feast_apply.compay_amount
     *
     * @return customer_feast_apply.compay_amount, 厂方承担金额
     */
    public Long getCompayAmount() {
        return compayAmount;
    }

    /**
     * 设置 厂方承担金额 字段:customer_feast_apply.compay_amount
     *
     * @param compayAmount the value for customer_feast_apply.compay_amount, 厂方承担金额
     */
    public void setCompayAmount(Long compayAmount) {
        this.compayAmount = compayAmount;
    }

    /**
     * 获取 审核金额(分) 字段:customer_feast_apply.audit_amount
     *
     * @return customer_feast_apply.audit_amount, 审核金额(分)
     */
    public Long getAuditAmount() {
        return auditAmount;
    }

    /**
     * 设置 审核金额(分) 字段:customer_feast_apply.audit_amount
     *
     * @param auditAmount the value for customer_feast_apply.audit_amount, 审核金额(分)
     */
    public void setAuditAmount(Long auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取 状态 字段:customer_feast_apply.status
     *
     * @return customer_feast_apply.status, 状态
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置 状态 字段:customer_feast_apply.status
     *
     * @param status the value for customer_feast_apply.status, 状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取  字段:customer_feast_apply.create_id
     *
     * @return customer_feast_apply.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:customer_feast_apply.create_id
     *
     * @param createId the value for customer_feast_apply.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:customer_feast_apply.create_name
     *
     * @return customer_feast_apply.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:customer_feast_apply.create_name
     *
     * @param createName the value for customer_feast_apply.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:customer_feast_apply.create_date
     *
     * @return customer_feast_apply.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:customer_feast_apply.create_date
     *
     * @param createDate the value for customer_feast_apply.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:customer_feast_apply.modify_id
     *
     * @return customer_feast_apply.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:customer_feast_apply.modify_id
     *
     * @param modifyId the value for customer_feast_apply.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:customer_feast_apply.modify_name
     *
     * @return customer_feast_apply.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:customer_feast_apply.modify_name
     *
     * @param modifyName the value for customer_feast_apply.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:customer_feast_apply.modify_date
     *
     * @return customer_feast_apply.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:customer_feast_apply.modify_date
     *
     * @param modifyDate the value for customer_feast_apply.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
    
    

    public Long getItemBalance() {
		return itemBalance;
	}

	public void setItemBalance(Long itemBalance) {
		this.itemBalance = itemBalance;
	}

	public String getItemNo() {
		return itemNo;
	}

	public void setItemNo(String itemNo) {
		this.itemNo = itemNo;
	}

	@Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CustomerFeastApplyDto that = (CustomerFeastApplyDto) o;

        if (applyNo != null ? !applyNo.equals(that.applyNo) : that.applyNo != null) return false;
        if (itemNo != null ? !itemNo.equals(that.itemNo) : that.itemNo != null) return false;
        if (costTypeId != null ? !costTypeId.equals(that.costTypeId) : that.costTypeId != null) return false;
        if (costTypeName != null ? !costTypeName.equals(that.costTypeName) : that.costTypeName != null) return false;
        if (donee != null ? !donee.equals(that.donee) : that.donee != null) return false;
        if (productId != null ? !productId.equals(that.productId) : that.productId != null) return false;
        if (productName != null ? !productName.equals(that.productName) : that.productName != null) return false;
        if (productPrice != null ? !productPrice.equals(that.productPrice) : that.productPrice != null) return false;
        if (activityPrice != null ? !activityPrice.equals(that.activityPrice) : that.activityPrice != null)
            return false;
        if (activityTableNum != null ? !activityTableNum.equals(that.activityTableNum) : that.activityTableNum != null)
            return false;
        if (buyNum != null ? !buyNum.equals(that.buyNum) : that.buyNum != null) return false;
        if (giftWineNotes != null ? !giftWineNotes.equals(that.giftWineNotes) : that.giftWineNotes != null)
            return false;
        if (giftNotes != null ? !giftNotes.equals(that.giftNotes) : that.giftNotes != null) return false;
        if (expectCost != null ? !expectCost.equals(that.expectCost) : that.expectCost != null) return false;
        if (compayScale != null ? !compayScale.equals(that.compayScale) : that.compayScale != null) return false;
        if (compayAmount != null ? !compayAmount.equals(that.compayAmount) : that.compayAmount != null) return false;
        return auditAmount != null ? auditAmount.equals(that.auditAmount) : that.auditAmount == null;
    }

    @Override
    public int hashCode() {
        int result = applyNo != null ? applyNo.hashCode() : 0;
        result = 31 * result + (itemNo != null ? itemNo.hashCode() : 0);
        result = 31 * result + (costTypeId != null ? costTypeId.hashCode() : 0);
        result = 31 * result + (costTypeName != null ? costTypeName.hashCode() : 0);
        result = 31 * result + (donee != null ? donee.hashCode() : 0);
        result = 31 * result + (productId != null ? productId.hashCode() : 0);
        result = 31 * result + (productName != null ? productName.hashCode() : 0);
        result = 31 * result + (productPrice != null ? productPrice.hashCode() : 0);
        result = 31 * result + (activityPrice != null ? activityPrice.hashCode() : 0);
        result = 31 * result + (activityTableNum != null ? activityTableNum.hashCode() : 0);
        result = 31 * result + (buyNum != null ? buyNum.hashCode() : 0);
        result = 31 * result + (giftWineNotes != null ? giftWineNotes.hashCode() : 0);
        result = 31 * result + (giftNotes != null ? giftNotes.hashCode() : 0);
        result = 31 * result + (expectCost != null ? expectCost.hashCode() : 0);
        result = 31 * result + (compayScale != null ? compayScale.hashCode() : 0);
        result = 31 * result + (compayAmount != null ? compayAmount.hashCode() : 0);
        result = 31 * result + (auditAmount != null ? auditAmount.hashCode() : 0);
        return result;
    }
}