package com.chinayanghe.tpm.cost.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 消费者宴会登记
 * CustomerFeastRegistDto
 * 数据库表：customer_feast_regist
 */
public class CustomerFeastRegistDto implements Serializable {
	//页面提交状态
//	private String pageStatus;	


    /**
     * 
     * 表字段 : customer_feast_regist.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : customer_feast_regist.apply_no
     */
    private String applyNo;
    /**
     * 登记单号
     * */
    private String registNo;
    
    /**
     * 临时报备单号
     */
    private String reportedNo;

    /**
     * 登记单行项目号
     * 表字段 : customer_feast_regist.item_no
     */
    private String itemNo;
    
    /**
     * 申请单行项目号
     * 表字段 : customer_feast_regist.item_no
     */
    private String applyItemNo;
    private Integer applyItemId;
    private Integer reportedItemId;
    

    /**
     * 费用类型名称
     * 表字段 : customer_feast_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 费用类型ID
     * 表字段 : customer_feast_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 家宴日期
     * 表字段 : customer_feast_regist.feast_date
     */
    private Date feastDate;

    /**
     * 时段
     * 表字段 : customer_feast_regist.feast_time
     */
    private String feastTime;

    /**
     * 家宴性质(婚宴、生日、满月、订婚、乔迁、丧宴、谢师、开业、聚会)
     * 表字段 : customer_feast_regist.feast_type
     */
    private String feastType;
    private String feastTypeName;

    /**
     * 宴会地址id
     * 表字段 : customer_feast_regist.feast_address_id
     */
    private String feastAddressId;

    /**
     * 宴会地点
     * 表字段 : customer_feast_regist.feast_address_detail
     */
    private String feastAddressDetail;

    /**
     * 宴会地址联系电话
     * 表字段 : customer_feast_regist.tel
     */
    private String tel;

    /**
     * 具体地址
     * 表字段 : customer_feast_regist.address_detail
     */
    private String addressDetail;

    /**
     * 桌数
     * 表字段 : customer_feast_regist.table_num
     */
    private Integer tableNum;

    /**
     * 产品编号
     * 表字段 : customer_feast_regist.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : customer_feast_regist.product_name
     */
    private String productName;
    /**
     * 结算价(分)
     */
    private Long productPrice;

    /**
     * 购买数量/瓶
     * 表字段 : customer_feast_regist.buy_num
     */
    private Integer buyNum;
    
    /**
     * 赠酒产品1编号
     */
    private String giftProduct1Id;
    /**
     * 赠酒产品1名称
     */
    private String giftProduct1Name;
    /**
     * 赠酒产品1数量
     */
    private Integer giftProduct1Num;
    /**
     * 赠酒产品2编号
     */
    private String giftProduct2Id;
    /**
     * 赠酒产品2名称
     */
    private String giftProduct2Name;
    /**
     * 赠酒产品2数量
     */
    private Integer giftProduct2Num;

    /**
     * 搭赠情况
     * 表字段 : customer_feast_regist.gift_notes
     */
    private String giftNotes;

    /**
     * 当事人
     * 表字段 : customer_feast_regist.person
     */
    private String person;

    /**
     * 当事人联系电话
     * 表字段 : customer_feast_regist.person_tel
     */
    private String personTel;

    /**
     * 经办人
     * 表字段 : customer_feast_regist.handle_person
     */
    private String handlePerson;

    /**
     * 经办人电话
     * 表字段 : customer_feast_regist.handle_person_tel
     */
    private String handlePersonTel;

    /**
     * 开始时间
     * 表字段 : customer_feast_regist.s_date
     */
    private Date sDate;

    /**
     * 结束时间
     * 表字段 : customer_feast_regist.e_date
     */
    private Date eDate;

    /**
     * 单位名称
     * 表字段 : customer_feast_regist.company_name
     */
    private String companyName;

    /**
     * 单位地址
     * 表字段 : customer_feast_regist.company_address
     */
    private String companyAddress;

    /**
     * 职务
     * 表字段 : customer_feast_regist.position
     */
    private String position;

    /**
     * 实际金额(分)
     * 表字段 : customer_feast_regist.actual_amount
     */
    private Long actualAmount;

    /**
     * 厂方承担金额/元
     * 表字段 : customer_feast_regist.compay_amount
     */
    private Long compayAmount;

    /**
     * 厂方承担比例
     * 表字段 : customer_feast_regist.compay_scale
     */
    private Double compayScale;

    /**
     * 行项目余额
     * 表字段 : customer_feast_regist.item_balance_amount
     */
    private Long itemBalance;

    /**
     * 备注
     * 表字段 : customer_feast_regist.notes
     */
    private String notes;

    /**
     * 督查意见
     * 表字段 : customer_feast_regist.audit_notes
     */
    private String auditNotes;

    /**
     * 状态
     * 表字段 : customer_feast_regist.status
     */
    private Integer status;

    /**
     * 创建者ID
     * 表字段 : customer_feast_regist.create_id
     */
    private String createId;

    /**
     * 创建者姓名
     * 表字段 : customer_feast_regist.create_name
     */
    private String createName;

    /**
     * 创建时间
     * 表字段 : customer_feast_regist.create_date
     */
    private Date createDate;

    /**
     * 修改ID
     * 表字段 : customer_feast_regist.modify_id
     */
    private String modifyId;

    /**
     * 修改人姓名
     * 表字段 : customer_feast_regist.modify_name
     */
    private String modifyName;

    /**
     * 修改时间
     * 表字段 : customer_feast_regist.modify_date
     */
    private Date modifyDate;

    /**
     * 登记类型（0，常规 1临时）
     * 表字段 : customer_feast_regist.type
     */
    private Byte type;

    /**
     * 当事人与经办人关系
     * 表字段 : customer_feast_regist.pmRelation
     */
    private String pmRelation;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table customer_feast_regist
     *
     * @mbggenerated Fri May 12 15:46:38 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:customer_feast_regist.id
     *
     * @return customer_feast_regist.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:customer_feast_regist.id
     *
     * @param id the value for customer_feast_regist.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:customer_feast_regist.apply_no
     *
     * @return customer_feast_regist.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:customer_feast_regist.apply_no
     *
     * @param applyNo the value for customer_feast_regist.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 申请单行项目号 字段:customer_feast_regist.item_no
     *
     * @return customer_feast_regist.item_no, 申请单行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 申请单行项目号 字段:customer_feast_regist.item_no
     *
     * @param itemNo the value for customer_feast_regist.item_no, 申请单行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 费用类型名称 字段:customer_feast_regist.cost_type_name
     *
     * @return customer_feast_regist.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:customer_feast_regist.cost_type_name
     *
     * @param costTypeName the value for customer_feast_regist.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 费用类型ID 字段:customer_feast_regist.cost_type_id
     *
     * @return customer_feast_regist.cost_type_id, 费用类型ID
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型ID 字段:customer_feast_regist.cost_type_id
     *
     * @param costTypeId the value for customer_feast_regist.cost_type_id, 费用类型ID
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 家宴日期 字段:customer_feast_regist.feast_date
     *
     * @return customer_feast_regist.feast_date, 家宴日期
     */
    public Date getFeastDate() {
        return feastDate;
    }

    /**
     * 设置 家宴日期 字段:customer_feast_regist.feast_date
     *
     * @param feastDate the value for customer_feast_regist.feast_date, 家宴日期
     */
    public void setFeastDate(Date feastDate) {
        this.feastDate = feastDate;
    }

    /**
     * 获取 时段 字段:customer_feast_regist.feast_time
     *
     * @return customer_feast_regist.feast_time, 时段
     */
    public String getFeastTime() {
        return feastTime;
    }

    /**
     * 设置 时段 字段:customer_feast_regist.feast_time
     *
     * @param feastTime the value for customer_feast_regist.feast_time, 时段
     */
    public void setFeastTime(String feastTime) {
        this.feastTime = feastTime;
    }

    /**
     * 获取 家宴性质(婚宴、生日、满月、订婚、乔迁、丧宴、谢师、开业、聚会) 字段:customer_feast_regist.feast_type
     *
     * @return customer_feast_regist.feast_type, 家宴性质(婚宴、生日、满月、订婚、乔迁、丧宴、谢师、开业、聚会)
     */
    public String getFeastType() {
        return feastType;
    } 

	/**
     * 设置 家宴性质(婚宴、生日、满月、订婚、乔迁、丧宴、谢师、开业、聚会) 字段:customer_feast_regist.feast_type
     *
     * @param feastType the value for customer_feast_regist.feast_type, 家宴性质(婚宴、生日、满月、订婚、乔迁、丧宴、谢师、开业、聚会)
     */
    public void setFeastType(String feastType) {
        this.feastType = feastType;
    }

    /**
     * 获取 宴会地址id 字段:customer_feast_regist.feast_address_id
     *
     * @return customer_feast_regist.feast_address_id, 宴会地址id
     */
    public String getFeastAddressId() {
        return feastAddressId;
    }

    /**
     * 设置 宴会地址id 字段:customer_feast_regist.feast_address_id
     *
     * @param feastAddressId the value for customer_feast_regist.feast_address_id, 宴会地址id
     */
    public void setFeastAddressId(String feastAddressId) {
        this.feastAddressId = feastAddressId;
    }

    /**
     * 获取 宴会地点 字段:customer_feast_regist.feast_address_detail
     *
     * @return customer_feast_regist.feast_address_detail, 宴会地点
     */
    public String getFeastAddressDetail() {
        return feastAddressDetail;
    }

    /**
     * 设置 宴会地点 字段:customer_feast_regist.feast_address_detail
     *
     * @param feastAddressDetail the value for customer_feast_regist.feast_address_detail, 宴会地点
     */
    public void setFeastAddressDetail(String feastAddressDetail) {
        this.feastAddressDetail = feastAddressDetail;
    }

    /**
     * 获取 宴会地址联系电话 字段:customer_feast_regist.tel
     *
     * @return customer_feast_regist.tel, 宴会地址联系电话
     */
    public String getTel() {
        return tel;
    }

    /**
     * 设置 宴会地址联系电话 字段:customer_feast_regist.tel
     *
     * @param tel the value for customer_feast_regist.tel, 宴会地址联系电话
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 获取 具体地址 字段:customer_feast_regist.address_deatil
     *
     * @return customer_feast_regist.address_deatil, 具体地址
     */
    public String getAddressDetail() {
 		return addressDetail;
 	}

    /**
     * 设置 具体地址 字段:customer_feast_regist.address_deatil
     *
     * @param addressDeatil the value for customer_feast_regist.address_deatil, 具体地址
     */

	public void setAddressDetail(String addressDetail) {
		this.addressDetail = addressDetail;
	}

	/**
     * 获取 桌数 字段:customer_feast_regist.table_num
     *
     * @return customer_feast_regist.table_num, 桌数
     */
    public Integer getTableNum() {
        return tableNum;
    }

    /**
     * 设置 桌数 字段:customer_feast_regist.table_num
     *
     * @param tableNum the value for customer_feast_regist.table_num, 桌数
     */
    public void setTableNum(Integer tableNum) {
        this.tableNum = tableNum;
    }

    /**
     * 获取 产品编号 字段:customer_feast_regist.product_id
     *
     * @return customer_feast_regist.product_id, 产品编号
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编号 字段:customer_feast_regist.product_id
     *
     * @param productId the value for customer_feast_regist.product_id, 产品编号
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:customer_feast_regist.product_name
     *
     * @return customer_feast_regist.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:customer_feast_regist.product_name
     *
     * @param productName the value for customer_feast_regist.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 购买数量/瓶 字段:customer_feast_regist.buy_num
     *
     * @return customer_feast_regist.buy_num, 购买数量/瓶
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 购买数量/瓶 字段:customer_feast_regist.buy_num
     *
     * @param buyNum the value for customer_feast_regist.buy_num, 购买数量/瓶
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取 搭赠情况 字段:customer_feast_regist.gift_notes
     *
     * @return customer_feast_regist.gift_notes, 搭赠情况
     */
    public String getGiftNotes() {
        return giftNotes;
    }

    /**
     * 设置 搭赠情况 字段:customer_feast_regist.gift_notes
     *
     * @param giftNotes the value for customer_feast_regist.gift_notes, 搭赠情况
     */
    public void setGiftNotes(String giftNotes) {
        this.giftNotes = giftNotes;
    }

    /**
     * 获取 当事人 字段:customer_feast_regist.person
     *
     * @return customer_feast_regist.person, 当事人
     */
    public String getPerson() {
        return person;
    }

    /**
     * 设置 当事人 字段:customer_feast_regist.person
     *
     * @param person the value for customer_feast_regist.person, 当事人
     */
    public void setPerson(String person) {
        this.person = person;
    }

    /**
     * 获取 当事人联系电话 字段:customer_feast_regist.person_tel
     *
     * @return customer_feast_regist.person_tel, 当事人联系电话
     */
    public String getPersonTel() {
        return personTel;
    }

    /**
     * 设置 当事人联系电话 字段:customer_feast_regist.person_tel
     *
     * @param personTel the value for customer_feast_regist.person_tel, 当事人联系电话
     */
    public void setPersonTel(String personTel) {
        this.personTel = personTel;
    }

    /**
     * 获取 经办人 字段:customer_feast_regist.handle_person
     *
     * @return customer_feast_regist.handle_person, 经办人
     */
    public String getHandlePerson() {
        return handlePerson;
    }

    /**
     * 设置 经办人 字段:customer_feast_regist.handle_person
     *
     * @param handlePerson the value for customer_feast_regist.handle_person, 经办人
     */
    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }

    /**
     * 获取 经办人电话 字段:customer_feast_regist.handle_person_tel
     *
     * @return customer_feast_regist.handle_person_tel, 经办人电话
     */
    public String getHandlePersonTel() {
        return handlePersonTel;
    }

    /**
     * 设置 经办人电话 字段:customer_feast_regist.handle_person_tel
     *
     * @param handlePersonTel the value for customer_feast_regist.handle_person_tel, 经办人电话
     */
    public void setHandlePersonTel(String handlePersonTel) {
        this.handlePersonTel = handlePersonTel;
    }

    /**
     * 获取 开始时间 字段:customer_feast_regist.s_date
     *
     * @return customer_feast_regist.s_date, 开始时间
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始时间 字段:customer_feast_regist.s_date
     *
     * @param sDate the value for customer_feast_regist.s_date, 开始时间
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束时间 字段:customer_feast_regist.e_date
     *
     * @return customer_feast_regist.e_date, 结束时间
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束时间 字段:customer_feast_regist.e_date
     *
     * @param eDate the value for customer_feast_regist.e_date, 结束时间
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 单位名称 字段:customer_feast_regist.company_name
     *
     * @return customer_feast_regist.company_name, 单位名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置 单位名称 字段:customer_feast_regist.company_name
     *
     * @param companyName the value for customer_feast_regist.company_name, 单位名称
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * 获取 单位地址 字段:customer_feast_regist.company_address
     *
     * @return customer_feast_regist.company_address, 单位地址
     */
    public String getCompanyAddress() {
        return companyAddress;
    }

    /**
     * 设置 单位地址 字段:customer_feast_regist.company_address
     *
     * @param companyAddress the value for customer_feast_regist.company_address, 单位地址
     */
    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    /**
     * 获取 职务 字段:customer_feast_regist.position
     *
     * @return customer_feast_regist.position, 职务
     */
    public String getPosition() {
        return position;
    }

    /**
     * 设置 职务 字段:customer_feast_regist.position
     *
     * @param position the value for customer_feast_regist.position, 职务
     */
    public void setPosition(String position) {
        this.position = position;
    }

    /**
     * 获取 实际金额(分) 字段:customer_feast_regist.actual_amount
     *
     * @return customer_feast_regist.actual_amount, 实际金额(分)
     */
    public Long getActualAmount() {
        return actualAmount;
    }

    /**
     * 设置 实际金额(分) 字段:customer_feast_regist.actual_amount
     *
     * @param actualAmount the value for customer_feast_regist.actual_amount, 实际金额(分)
     */
    public void setActualAmount(Long actualAmount) {
        this.actualAmount = actualAmount;
    }

    /**
     * 获取 厂方承担金额/元 字段:customer_feast_regist.compay_amount
     *
     * @return customer_feast_regist.compay_amount, 厂方承担金额/元
     */
    public Long getCompayAmount() {
        return compayAmount;
    }

    /**
     * 设置 厂方承担金额/元 字段:customer_feast_regist.compay_amount
     *
     * @param compayAmount the value for customer_feast_regist.compay_amount, 厂方承担金额/元
     */
    public void setCompayAmount(Long compayAmount) {
        this.compayAmount = compayAmount;
    }

    /**
     * 获取 厂方承担比例 字段:customer_feast_regist.compay_scale
     *
     * @return customer_feast_regist.compay_scale, 厂方承担比例
     */
    public Double getCompayScale() {
        return compayScale;
    }

    /**
     * 设置 厂方承担比例 字段:customer_feast_regist.compay_scale
     *
     * @param compayScale the value for customer_feast_regist.compay_scale, 厂方承担比例
     */
    public void setCompayScale(Double compayScale) {
        this.compayScale = compayScale;
    }

    /**
     * 获取 行项目余额 字段:customer_feast_regist.item_balance_amount
     *
     * @return customer_feast_regist.item_balance_amount, 行项目余额
     */
    public Long getItemBalance() {
        return itemBalance;
    }

    /**
     * 设置 行项目余额 字段:customer_feast_regist.item_balance_amount
     *
     * @param itemBalanceAmount the value for customer_feast_regist.item_balance_amount, 行项目余额
     */
    public void setItemBalance(Long itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 备注 字段:customer_feast_regist.notes
     *
     * @return customer_feast_regist.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:customer_feast_regist.notes
     *
     * @param notes the value for customer_feast_regist.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取 督查意见 字段:customer_feast_regist.audit_notes
     *
     * @return customer_feast_regist.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:customer_feast_regist.audit_notes
     *
     * @param auditNotes the value for customer_feast_regist.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取 状态 字段:customer_feast_regist.status
     *
     * @return customer_feast_regist.status, 状态
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置 状态 字段:customer_feast_regist.status
     *
     * @param status the value for customer_feast_regist.status, 状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取 创建者ID 字段:customer_feast_regist.create_id
     *
     * @return customer_feast_regist.create_id, 创建者ID
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置 创建者ID 字段:customer_feast_regist.create_id
     *
     * @param createId the value for customer_feast_regist.create_id, 创建者ID
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取 创建者姓名 字段:customer_feast_regist.create_name
     *
     * @return customer_feast_regist.create_name, 创建者姓名
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置 创建者姓名 字段:customer_feast_regist.create_name
     *
     * @param createName the value for customer_feast_regist.create_name, 创建者姓名
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取 创建时间 字段:customer_feast_regist.create_date
     *
     * @return customer_feast_regist.create_date, 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置 创建时间 字段:customer_feast_regist.create_date
     *
     * @param createDate the value for customer_feast_regist.create_date, 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取 修改ID 字段:customer_feast_regist.modify_id
     *
     * @return customer_feast_regist.modify_id, 修改ID
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置 修改ID 字段:customer_feast_regist.modify_id
     *
     * @param modifyId the value for customer_feast_regist.modify_id, 修改ID
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取 修改人姓名 字段:customer_feast_regist.modify_name
     *
     * @return customer_feast_regist.modify_name, 修改人姓名
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置 修改人姓名 字段:customer_feast_regist.modify_name
     *
     * @param modifyName the value for customer_feast_regist.modify_name, 修改人姓名
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取 修改时间 字段:customer_feast_regist.modify_date
     *
     * @return customer_feast_regist.modify_date, 修改时间
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置 修改时间 字段:customer_feast_regist.modify_date
     *
     * @param modifyDate the value for customer_feast_regist.modify_date, 修改时间
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 登记类型（0，常规 1临时） 字段:customer_feast_regist.type
     *
     * @return customer_feast_regist.type, 登记类型（0，常规 1临时）
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置 登记类型（0，常规 1临时） 字段:customer_feast_regist.type
     *
     * @param type the value for customer_feast_regist.type, 登记类型（0，常规 1临时）
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取 当事人与经办人关系 字段:customer_feast_regist.pmRelation
     *
     * @return customer_feast_regist.pmRelation, 当事人与经办人关系
     */
    public String getPmRelation() {
        return pmRelation;
    }

    /**
     * 设置 当事人与经办人关系 字段:customer_feast_regist.pmRelation
     *
     * @param pmrelation the value for customer_feast_regist.pmRelation, 当事人与经办人关系
     */
    public void setPmRelation(String pmRelation) {
        this.pmRelation = pmRelation;
    }

	public String getRegistNo() {
		return registNo;
	}

	public void setRegistNo(String registNo) {
		this.registNo = registNo;
	}
	
	

   public String getReportedNo() {
		return reportedNo;
	}

	public void setReportedNo(String reportedNo) {
		this.reportedNo = reportedNo;
	}
	
	
	

	public Integer getApplyItemId() {
		return applyItemId;
	}

	public void setApplyItemId(Integer applyItemId) {
		this.applyItemId = applyItemId;
	}

	public Integer getReportedItemId() {
		return reportedItemId;
	}

	public void setReportedItemId(Integer reportedItemId) {
		this.reportedItemId = reportedItemId;
	}

	public String getGiftProduct1Id() {
		return giftProduct1Id;
	}

	public void setGiftProduct1Id(String giftProduct1Id) {
		this.giftProduct1Id = giftProduct1Id;
	}

	public String getGiftProduct1Name() {
		return giftProduct1Name;
	}

	public void setGiftProduct1Name(String giftProduct1Name) {
		this.giftProduct1Name = giftProduct1Name;
	}

	public Integer getGiftProduct1Num() {
		return giftProduct1Num;
	}

	public void setGiftProduct1Num(Integer giftProduct1Num) {
		this.giftProduct1Num = giftProduct1Num;
	}

	public String getGiftProduct2Id() {
		return giftProduct2Id;
	}

	public void setGiftProduct2Id(String giftProduct2Id) {
		this.giftProduct2Id = giftProduct2Id;
	}

	public String getGiftProduct2Name() {
		return giftProduct2Name;
	}

	public void setGiftProduct2Name(String giftProduct2Name) {
		this.giftProduct2Name = giftProduct2Name;
	}

	public Integer getGiftProduct2Num() {
		return giftProduct2Num;
	}

	public void setGiftProduct2Num(Integer giftProduct2Num) {
		this.giftProduct2Num = giftProduct2Num;
	}

	
	public String getFeastTypeName() {
		return feastTypeName;
	}

	public void setFeastTypeName(String feastTypeName) {
		this.feastTypeName = feastTypeName;
	}

	public Long getProductPrice() {
		return productPrice;
	}

	public void setProductPrice(Long productPrice) {
		this.productPrice = productPrice;
	}

	public String getApplyItemNo() {
		return applyItemNo;
	}

	public void setApplyItemNo(String applyItemNo) {
		this.applyItemNo = applyItemNo;
	}
/*
@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((actualAmount == null) ? 0 : actualAmount.hashCode());
		result = prime * result + ((addressDetail == null) ? 0 : addressDetail.hashCode());
		result = prime * result + ((auditNotes == null) ? 0 : auditNotes.hashCode());
		result = prime * result + ((buyNum == null) ? 0 : buyNum.hashCode());
		result = prime * result + ((companyAddress == null) ? 0 : companyAddress.hashCode());
		result = prime * result + ((companyName == null) ? 0 : companyName.hashCode());
		result = prime * result + ((compayAmount == null) ? 0 : compayAmount.hashCode());
		result = prime * result + ((compayScale == null) ? 0 : compayScale.hashCode());
		result = prime * result + ((costTypeName == null) ? 0 : costTypeName.hashCode());
		result = prime * result + ((eDate == null) ? 0 : eDate.hashCode());
		result = prime * result + ((feastAddressDetail == null) ? 0 : feastAddressDetail.hashCode());
		result = prime * result + ((feastDate == null) ? 0 : feastDate.hashCode());
		result = prime * result + ((feastTime == null) ? 0 : feastTime.hashCode());
		result = prime * result + ((feastType == null) ? 0 : feastType.hashCode());
		result = prime * result + ((giftNotes == null) ? 0 : giftNotes.hashCode());
		result = prime * result + ((handlePerson == null) ? 0 : handlePerson.hashCode());
		result = prime * result + ((handlePersonTel == null) ? 0 : handlePersonTel.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((itemBalance == null) ? 0 : itemBalance.hashCode());
		result = prime * result + ((itemNo == null) ? 0 : itemNo.hashCode());
		result = prime * result + ((notes == null) ? 0 : notes.hashCode());
		result = prime * result + ((person == null) ? 0 : person.hashCode());
		result = prime * result + ((personTel == null) ? 0 : personTel.hashCode());
		result = prime * result + ((pmRelation == null) ? 0 : pmRelation.hashCode());
		result = prime * result + ((position == null) ? 0 : position.hashCode());
		result = prime * result + ((productId == null) ? 0 : productId.hashCode());
		result = prime * result + ((productName == null) ? 0 : productName.hashCode());
		result = prime * result + ((sDate == null) ? 0 : sDate.hashCode());
		result = prime * result + ((tableNum == null) ? 0 : tableNum.hashCode());
		result = prime * result + ((tel == null) ? 0 : tel.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CustomerFeastRegistDto other = (CustomerFeastRegistDto) obj;
		if (actualAmount == null) {
			if (other.actualAmount != null)
				return false;
		} else if (!actualAmount.equals(other.actualAmount))
			return false;
		if (addressDetail == null) {
			if (other.addressDetail != null)
				return false;
		} else if (!addressDetail.equals(other.addressDetail))
			return false;
		if (auditNotes == null) {
			if (other.auditNotes != null)
				return false;
		} else if (!auditNotes.equals(other.auditNotes))
			return false;
		if (buyNum == null) {
			if (other.buyNum != null)
				return false;
		} else if (!buyNum.equals(other.buyNum))
			return false;
		if (companyAddress == null) {
			if (other.companyAddress != null)
				return false;
		} else if (!companyAddress.equals(other.companyAddress))
			return false;
		if (companyName == null) {
			if (other.companyName != null)
				return false;
		} else if (!companyName.equals(other.companyName))
			return false;
		if (compayAmount == null) {
			if (other.compayAmount != null)
				return false;
		} else if (!compayAmount.equals(other.compayAmount))
			return false;
		if (compayScale == null) {
			if (other.compayScale != null)
				return false;
		} else if (!compayScale.equals(other.compayScale))
			return false;
		if (costTypeName == null) {
			if (other.costTypeName != null)
				return false;
		} else if (!costTypeName.equals(other.costTypeName))
			return false;
		if (eDate == null) {
			if (other.eDate != null)
				return false;
		} else if (!eDate.equals(other.eDate))
			return false;
		if (feastAddressDetail == null) {
			if (other.feastAddressDetail != null)
				return false;
		} else if (!feastAddressDetail.equals(other.feastAddressDetail))
			return false;
		if (feastDate == null) {
			if (other.feastDate != null)
				return false;
		} else if (!feastDate.equals(other.feastDate))
			return false;
		if (feastTime == null) {
			if (other.feastTime != null)
				return false;
		} else if (!feastTime.equals(other.feastTime))
			return false;
		if (feastType == null) {
			if (other.feastType != null)
				return false;
		} else if (!feastType.equals(other.feastType))
			return false;
		if (giftNotes == null) {
			if (other.giftNotes != null)
				return false;
		} else if (!giftNotes.equals(other.giftNotes))
			return false;
		if (handlePerson == null) {
			if (other.handlePerson != null)
				return false;
		} else if (!handlePerson.equals(other.handlePerson))
			return false;
		if (handlePersonTel == null) {
			if (other.handlePersonTel != null)
				return false;
		} else if (!handlePersonTel.equals(other.handlePersonTel))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (itemBalance == null) {
			if (other.itemBalance != null)
				return false;
		} else if (!itemBalance.equals(other.itemBalance))
			return false;
		if (itemNo == null) {
			if (other.itemNo != null)
				return false;
		} else if (!itemNo.equals(other.itemNo))
			return false;
		if (notes == null) {
			if (other.notes != null)
				return false;
		} else if (!notes.equals(other.notes))
			return false;
		if (person == null) {
			if (other.person != null)
				return false;
		} else if (!person.equals(other.person))
			return false;
		if (personTel == null) {
			if (other.personTel != null)
				return false;
		} else if (!personTel.equals(other.personTel))
			return false;
		if (pmRelation == null) {
			if (other.pmRelation != null)
				return false;
		} else if (!pmRelation.equals(other.pmRelation))
			return false;
		if (position == null) {
			if (other.position != null)
				return false;
		} else if (!position.equals(other.position))
			return false;
		if (productId == null) {
			if (other.productId != null)
				return false;
		} else if (!productId.equals(other.productId))
			return false;
		if (productName == null) {
			if (other.productName != null)
				return false;
		} else if (!productName.equals(other.productName))
			return false;
		if (sDate == null) {
			if (other.sDate != null)
				return false;
		} else if (!sDate.equals(other.sDate))
			return false;
		if (tableNum == null) {
			if (other.tableNum != null)
				return false;
		} else if (!tableNum.equals(other.tableNum))
			return false;
		if (tel == null) {
			if (other.tel != null)
				return false;
		} else if (!tel.equals(other.tel))
			return false;
		return true;
	}

*/
    
}