package com.chinayanghe.tpm.cost.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 开票量控制配置表
 * InvoiceAmountControlDto
 * 数据库表：invoice_amount_control
 */
public class InvoiceAmountControlDto implements Serializable {

    /**
     * 
     * 表字段 : invoice_amount_control.id
     */
    private Integer id;

    /**
     * 控制编号
     * 表字段 : invoice_amount_control.control_code
     */
    private String controlCode;

    /**
     * 活动类型2级编码
     * 表字段 : invoice_amount_control.activity_type_code_sub
     */
    private String activityTypeCodeSub;

    /**
     * 开始日期
     * 表字段 : invoice_amount_control.s_date
     */
    private Date sDate;

    /**
     * 结束日期
     * 表字段 : invoice_amount_control.e_date
     */
    private Date eDate;

    /**
     * 一级渠道
     * 表字段 : invoice_amount_control.level_channel_one
     */
    private String levelChannelOne;

    /**
     * 二级渠道
     * 表字段 : invoice_amount_control.level_channel_two
     */
    private String levelChannelTwo;

    /**
     * 推广品牌编码
     * 表字段 : invoice_amount_control.brand_id
     */
    private String brandId;

    /**
     * 推广品牌名称
     * 表字段 : invoice_amount_control.brand_name
     */
    private String brandName;

    /**
     * 产品层次
     * 表字段 : invoice_amount_control.product_level
     */
    private String productLevel;

    /**
     * 产品编码
     * 表字段 : invoice_amount_control.product_id
     */
    private String productId;

    /**
     * 产品名字
     * 表字段 : invoice_amount_control.product_name
     */
    private String productName;

    /**
     * 经销商编码
     * 表字段 : invoice_amount_control.dealer_id
     */
    private String dealerId;

    /**
     * 经销商名称
     * 表字段 : invoice_amount_control.dealer_name
     */
    private String dealerName;

    /**
     * 分公司编号
     * 表字段 : invoice_amount_control.branch_company_id
     */
    private String branchCompanyId;

    /**
     * 分公司名称
     * 表字段 : invoice_amount_control.branch_company_name
     */
    private String branchCompanyName;

    /**
     * 大区编号
     * 表字段 : invoice_amount_control.region_code
     */
    private String regionCode;

    /**
     * 大区名称
     * 表字段 : invoice_amount_control.region_name
     */
    private String regionName;

    /**
     * 单瓶计提金额(分)
     * 表字段 : invoice_amount_control.amount
     */
    private Long amount;

    /**
     * 销量比例/%
     * 表字段 : invoice_amount_control.sales_scale
     */
    private Double salesScale;

    /**
     * 返点比例/%
     * 表字段 : invoice_amount_control.rebate_scale
     */
    private Double rebateScale;

    /**
     * 承担比例/%
     * 表字段 : invoice_amount_control.bear_scale
     */
    private Double bearScale;

    /**
     * 是否新增  0-新增
     * 表字段 : invoice_amount_control.is_newproduct
     */
    private Integer isNewproduct;

    /**
     *
     * 表字段 : invoice_amount_control_log.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : invoice_amount_control_log.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : invoice_amount_control_log.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : invoice_amount_control_log.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : invoice_amount_control_log.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : invoice_amount_control_log.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table invoice_amount_control
     *
     * @mbggenerated Wed Jul 05 19:45:05 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:invoice_amount_control.id
     *
     * @return invoice_amount_control.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:invoice_amount_control.id
     *
     * @param id the value for invoice_amount_control.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 控制编号 字段:invoice_amount_control.control_code
     *
     * @return invoice_amount_control.control_code, 控制编号
     */
    public String getControlCode() {
        return controlCode;
    }

    /**
     * 设置 控制编号 字段:invoice_amount_control.control_code
     *
     * @param controlCode the value for invoice_amount_control.control_code, 控制编号
     */
    public void setControlCode(String controlCode) {
        this.controlCode = controlCode;
    }

    /**
     * 获取 活动类型2级编码 字段:invoice_amount_control.activity_type_code_sub
     *
     * @return invoice_amount_control.activity_type_code_sub, 活动类型2级编码
     */
    public String getActivityTypeCodeSub() {
        return activityTypeCodeSub;
    }

    /**
     * 设置 活动类型2级编码 字段:invoice_amount_control.activity_type_code_sub
     *
     * @param activityTypeCodeSub the value for invoice_amount_control.activity_type_code_sub, 活动类型2级编码
     */
    public void setActivityTypeCodeSub(String activityTypeCodeSub) {
        this.activityTypeCodeSub = activityTypeCodeSub;
    }

    /**
     * 获取 开始日期 字段:invoice_amount_control.s_date
     *
     * @return invoice_amount_control.s_date, 开始日期
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始日期 字段:invoice_amount_control.s_date
     *
     * @param sDate the value for invoice_amount_control.s_date, 开始日期
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束日期 字段:invoice_amount_control.e_date
     *
     * @return invoice_amount_control.e_date, 结束日期
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束日期 字段:invoice_amount_control.e_date
     *
     * @param eDate the value for invoice_amount_control.e_date, 结束日期
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 一级渠道 字段:invoice_amount_control.level_channel_one
     *
     * @return invoice_amount_control.level_channel_one, 一级渠道
     */
    public String getLevelChannelOne() {
        return levelChannelOne;
    }

    /**
     * 设置 一级渠道 字段:invoice_amount_control.level_channel_one
     *
     * @param levelChannelOne the value for invoice_amount_control.level_channel_one, 一级渠道
     */
    public void setLevelChannelOne(String levelChannelOne) {
        this.levelChannelOne = levelChannelOne;
    }

    /**
     * 获取 二级渠道 字段:invoice_amount_control.level_channel_two
     *
     * @return invoice_amount_control.level_channel_two, 二级渠道
     */
    public String getLevelChannelTwo() {
        return levelChannelTwo;
    }

    /**
     * 设置 二级渠道 字段:invoice_amount_control.level_channel_two
     *
     * @param levelChannelTwo the value for invoice_amount_control.level_channel_two, 二级渠道
     */
    public void setLevelChannelTwo(String levelChannelTwo) {
        this.levelChannelTwo = levelChannelTwo;
    }

    /**
     * 获取 推广品牌编码 字段:invoice_amount_control.brand_id
     *
     * @return invoice_amount_control.brand_id, 推广品牌编码
     */
    public String getBrandId() {
        return brandId;
    }

    /**
     * 设置 推广品牌编码 字段:invoice_amount_control.brand_id
     *
     * @param brandId the value for invoice_amount_control.brand_id, 推广品牌编码
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /**
     * 获取 推广品牌名称 字段:invoice_amount_control.brand_name
     *
     * @return invoice_amount_control.brand_name, 推广品牌名称
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置 推广品牌名称 字段:invoice_amount_control.brand_name
     *
     * @param brandName the value for invoice_amount_control.brand_name, 推广品牌名称
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * 获取 产品层次 字段:invoice_amount_control.product_level
     *
     * @return invoice_amount_control.product_level, 产品层次
     */
    public String getProductLevel() {
        return productLevel;
    }

    /**
     * 设置 产品层次 字段:invoice_amount_control.product_level
     *
     * @param productLevel the value for invoice_amount_control.product_level, 产品层次
     */
    public void setProductLevel(String productLevel) {
        this.productLevel = productLevel;
    }

    /**
     * 获取 产品编码 字段:invoice_amount_control.product_id
     *
     * @return invoice_amount_control.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:invoice_amount_control.product_id
     *
     * @param productId the value for invoice_amount_control.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名字 字段:invoice_amount_control.product_name
     *
     * @return invoice_amount_control.product_name, 产品名字
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名字 字段:invoice_amount_control.product_name
     *
     * @param productName the value for invoice_amount_control.product_name, 产品名字
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 经销商编码 字段:invoice_amount_control.dealer_id
     *
     * @return invoice_amount_control.dealer_id, 经销商编码
     */
    public String getDealerId() {
        return dealerId;
    }

    /**
     * 设置 经销商编码 字段:invoice_amount_control.dealer_id
     *
     * @param dealerId the value for invoice_amount_control.dealer_id, 经销商编码
     */
    public void setDealerId(String dealerId) {
        this.dealerId = dealerId;
    }

    /**
     * 获取 经销商名称 字段:invoice_amount_control.dealer_name
     *
     * @return invoice_amount_control.dealer_name, 经销商名称
     */
    public String getDealerName() {
        return dealerName;
    }

    /**
     * 设置 经销商名称 字段:invoice_amount_control.dealer_name
     *
     * @param dealerName the value for invoice_amount_control.dealer_name, 经销商名称
     */
    public void setDealerName(String dealerName) {
        this.dealerName = dealerName;
    }

    /**
     * 获取 分公司编号 字段:invoice_amount_control.branch_company_id
     *
     * @return invoice_amount_control.branch_company_id, 分公司编号
     */
    public String getBranchCompanyId() {
        return branchCompanyId;
    }

    /**
     * 设置 分公司编号 字段:invoice_amount_control.branch_company_id
     *
     * @param branchCompanyId the value for invoice_amount_control.branch_company_id, 分公司编号
     */
    public void setBranchCompanyId(String branchCompanyId) {
        this.branchCompanyId = branchCompanyId;
    }

    /**
     * 获取 分公司名称 字段:invoice_amount_control.branch_company_name
     *
     * @return invoice_amount_control.branch_company_name, 分公司名称
     */
    public String getBranchCompanyName() {
        return branchCompanyName;
    }

    /**
     * 设置 分公司名称 字段:invoice_amount_control.branch_company_name
     *
     * @param branchCompanyName the value for invoice_amount_control.branch_company_name, 分公司名称
     */
    public void setBranchCompanyName(String branchCompanyName) {
        this.branchCompanyName = branchCompanyName;
    }

    /**
     * 获取 大区编号 字段:invoice_amount_control.region_code
     *
     * @return invoice_amount_control.region_code, 大区编号
     */
    public String getRegionCode() {
        return regionCode;
    }

    /**
     * 设置 大区编号 字段:invoice_amount_control.region_code
     *
     * @param regionCode the value for invoice_amount_control.region_code, 大区编号
     */
    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    /**
     * 获取 大区名称 字段:invoice_amount_control.region_name
     *
     * @return invoice_amount_control.region_name, 大区名称
     */
    public String getRegionName() {
        return regionName;
    }

    /**
     * 设置 大区名称 字段:invoice_amount_control.region_name
     *
     * @param regionName the value for invoice_amount_control.region_name, 大区名称
     */
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    /**
     * 获取 单瓶计提金额(分) 字段:invoice_amount_control.amount
     *
     * @return invoice_amount_control.amount, 单瓶计提金额(分)
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * 设置 单瓶计提金额(分) 字段:invoice_amount_control.amount
     *
     * @param amount the value for invoice_amount_control.amount, 单瓶计提金额(分)
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * 获取 销量比例/% 字段:invoice_amount_control.sales_scale
     *
     * @return invoice_amount_control.sales_scale, 销量比例/%
     */
    public Double getSalesScale() {
        return salesScale;
    }

    /**
     * 设置 销量比例/% 字段:invoice_amount_control.sales_scale
     *
     * @param salesScale the value for invoice_amount_control.sales_scale, 销量比例/%
     */
    public void setSalesScale(Double salesScale) {
        this.salesScale = salesScale;
    }

    /**
     * 获取 返点比例/% 字段:invoice_amount_control.rebate_scale
     *
     * @return invoice_amount_control.rebate_scale, 返点比例/%
     */
    public Double getRebateScale() {
        return rebateScale;
    }

    /**
     * 设置 返点比例/% 字段:invoice_amount_control.rebate_scale
     *
     * @param rebateScale the value for invoice_amount_control.rebate_scale, 返点比例/%
     */
    public void setRebateScale(Double rebateScale) {
        this.rebateScale = rebateScale;
    }

    /**
     * 获取 承担比例/% 字段:invoice_amount_control.bear_scale
     *
     * @return invoice_amount_control.bear_scale, 承担比例/%
     */
    public Double getBearScale() {
        return bearScale;
    }

    /**
     * 设置 承担比例/% 字段:invoice_amount_control.bear_scale
     *
     * @param bearScale the value for invoice_amount_control.bear_scale, 承担比例/%
     */
    public void setBearScale(Double bearScale) {
        this.bearScale = bearScale;
    }

    /**
     * 获取 是否新增  0-新增 字段:invoice_amount_control.is_newproduct
     *
     * @return invoice_amount_control.is_newproduct, 是否新增  0-新增
     */
    public Integer getIsNewproduct() {
        return isNewproduct;
    }

    /**
     * 设置 是否新增  0-新增 字段:invoice_amount_control.is_newproduct
     *
     * @param isNewproduct the value for invoice_amount_control.is_newproduct, 是否新增  0-新增
     */
    public void setIsNewproduct(Integer isNewproduct) {
        this.isNewproduct = isNewproduct;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getModifyId() {
        return modifyId;
    }

    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    public String getModifyName() {
        return modifyName;
    }

    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    public Date getModifyDate() {
        return modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}