package com.chinayanghe.tpm.cost.dto.areaPlaneEvent;

import java.io.Serializable;
import java.util.Date;

/**
 * 区域面上事件营销登记
 * AreaPlaneEventRegistVo
 * 数据库表：area_plane_event_regist
 */
public class AreaPlaneEventRegistDto implements Serializable {

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AreaPlaneEventRegistDto that = (AreaPlaneEventRegistDto) o;

        if (!sDate.equals(that.sDate)) return false;
        if (!eDate.equals(that.eDate)) return false;
        if (!addressDetail.equals(that.addressDetail)) return false;
        if (!buyNum.equals(that.buyNum)) return false;
        if (!companySale.equals(that.companySale)) return false;
        if (!companyAmount.equals(that.companyAmount)) return false;
        if (!realAmount.equals(that.realAmount)) return false;
        if (!activityForm.equals(that.activityForm)) return false;
        if (!theme.equals(that.theme)) return false;
        if (!ticketAmount.equals(that.ticketAmount)) return false;
        if (!advertiseAmount.equals(that.advertiseAmount)) return false;
        if (!showActor.equals(that.showActor)) return false;
        return guests.equals(that.guests);
    }

    @Override
    public int hashCode() {
        int result = sDate.hashCode();
        result = 31 * result + eDate.hashCode();
        result = 31 * result + addressDetail.hashCode();
        result = 31 * result + buyNum.hashCode();
        result = 31 * result + companySale.hashCode();
        result = 31 * result + companyAmount.hashCode();
        result = 31 * result + realAmount.hashCode();
        result = 31 * result + activityForm.hashCode();
        result = 31 * result + itemBalance.hashCode();
        result = 31 * result + theme.hashCode();
        result = 31 * result + unit.hashCode();
        result = 31 * result + ticketAmount.hashCode();
        result = 31 * result + advertiseAmount.hashCode();
        result = 31 * result + showActor.hashCode();
        result = 31 * result + guests.hashCode();
        return result;
    }

    /**

     * 
     * 表字段 : area_plane_event_regist.id
     */
    private Integer id;

    /**
     * 登记单号
     * 表字段 : area_plane_event_regist.regist_no
     */
    private String registNo;

    /**
     * 行号
     * 表字段 : area_point_sponsor_apply.item_no
     */
    private String itemNo;

    /**
     * 申请单号
     * 表字段 : area_plane_event_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单id
     */
    private Integer applyId;

    /**
     * 申请单行号
     * 表字段 : area_plane_event_regist.apply_item_no
     */
    private String applyItemNo;

    /**
     * 费用类型编码
     * 表字段 : area_plane_event_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : area_plane_event_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 
     * 表字段 : area_plane_event_regist.brand_id
     */
    private String brandId;

    /**
     * 
     * 表字段 : area_plane_event_regist.brand_name
     */
    private String brandName;

    /**
     * 开始日期
     * 表字段 : area_plane_event_regist.s_date
     */
    private Date sDate;

    /**
     * 结算日期
     * 表字段 : area_plane_event_regist.e_date
     */
    private Date eDate;

    /**
     * 省编码
     * 表字段 : area_plane_event_regist.province_id
     */
    private String provinceId;

    /**
     * 省名称
     * 表字段 : area_plane_event_regist.province_name
     */
    private String provinceName;

    /**
     * 市编码
     * 表字段 : area_plane_event_regist.city_id
     */
    private String cityId;

    /**
     * 市名称
     * 表字段 : area_plane_event_regist.city_name
     */
    private String cityName;

    /**
     * 
     * 表字段 : area_plane_event_regist.county_id
     */
    private String countyId;

    /**
     * 
     * 表字段 : area_plane_event_regist.county_name
     */
    private String countyName;

    /**
     * 
     * 表字段 : area_plane_event_regist.town_id
     */
    private String townId;

    /**
     * 
     * 表字段 : area_plane_event_regist.town_name
     */
    private String townName;

    /**
     * 
     * 表字段 : area_plane_event_regist.address_detail
     */
    private String addressDetail;

    /**
     * 登记数量
     * 表字段 : area_plane_event_regist.buy_num
     */
    private Integer buyNum;

    /**
     * 
     * 表字段 : area_plane_event_regist.company_sale
     */
    private Double companySale;

    /**
     * 厂方承担金额(分)
     * 表字段 : area_plane_event_regist.company_amount
     */
    private Integer companyAmount;

    /**
     * 实际产生费用(分)
     * 表字段 : area_plane_event_regist.real_amount
     */
    private Integer realAmount;

    /**
     * 活动形式
     * 表字段 : area_plane_event_regist.activity_form
     */
    private String activityForm;

    /**
     * 行项目余额
     * 表字段 : area_plane_event_regist.item_balance
     */
    private Integer itemBalance;

    /**
     * 主题
     * 表字段 : area_plane_event_regist.theme
     */
    private String theme;

    /**
     * 
     * 表字段 : area_plane_event_regist.unit
     */
    private String unit;

    /**
     * 
     * 表字段 : area_plane_event_regist.ticket_amount
     */
    private Long ticketAmount;

    /**
     * 宣传回报
     * 表字段 : area_plane_event_regist.advertise_amount
     */
    private Long advertiseAmount;

    /**
     * 
     * 表字段 : area_plane_event_regist.show_actor
     */
    private String showActor;

    /**
     * 
     * 表字段 : area_plane_event_regist.guests
     */
    private String guests;

    /**
     * 
     * 表字段 : area_plane_event_regist.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : area_plane_event_regist.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : area_plane_event_regist.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : area_plane_event_regist.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : area_plane_event_regist.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : area_plane_event_regist.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table area_plane_event_regist
     *
     * @mbggenerated Sat Jun 17 15:46:46 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:area_plane_event_regist.id
     *
     * @return area_plane_event_regist.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:area_plane_event_regist.id
     *
     * @param id the value for area_plane_event_regist.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 登记单号 字段:area_plane_event_regist.regist_no
     *
     * @return area_plane_event_regist.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:area_plane_event_regist.regist_no
     *
     * @param registNo the value for area_plane_event_regist.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 申请单号 字段:area_plane_event_regist.apply_no
     *
     * @return area_plane_event_regist.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:area_plane_event_regist.apply_no
     *
     * @param applyNo the value for area_plane_event_regist.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 申请单行号 字段:area_plane_event_regist.apply_item_no
     *
     * @return area_plane_event_regist.apply_item_no, 申请单行号
     */
    public String getApplyItemNo() {
        return applyItemNo;
    }

    /**
     * 设置 申请单行号 字段:area_plane_event_regist.apply_item_no
     *
     * @param applyItemNo the value for area_plane_event_regist.apply_item_no, 申请单行号
     */
    public void setApplyItemNo(String applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    /**
     * 获取 费用类型编码 字段:area_plane_event_regist.cost_type_id
     *
     * @return area_plane_event_regist.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:area_plane_event_regist.cost_type_id
     *
     * @param costTypeId the value for area_plane_event_regist.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:area_plane_event_regist.cost_type_name
     *
     * @return area_plane_event_regist.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:area_plane_event_regist.cost_type_name
     *
     * @param costTypeName the value for area_plane_event_regist.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取  字段:area_plane_event_regist.brand_id
     *
     * @return area_plane_event_regist.brand_id, 
     */
    public String getBrandId() {
        return brandId;
    }

    /**
     * 设置  字段:area_plane_event_regist.brand_id
     *
     * @param brandId the value for area_plane_event_regist.brand_id, 
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /**
     * 获取  字段:area_plane_event_regist.brand_name
     *
     * @return area_plane_event_regist.brand_name, 
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置  字段:area_plane_event_regist.brand_name
     *
     * @param brandName the value for area_plane_event_regist.brand_name, 
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * 获取 开始日期 字段:area_plane_event_regist.s_date
     *
     * @return area_plane_event_regist.s_date, 开始日期
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始日期 字段:area_plane_event_regist.s_date
     *
     * @param sDate the value for area_plane_event_regist.s_date, 开始日期
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结算日期 字段:area_plane_event_regist.e_date
     *
     * @return area_plane_event_regist.e_date, 结算日期
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结算日期 字段:area_plane_event_regist.e_date
     *
     * @param eDate the value for area_plane_event_regist.e_date, 结算日期
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 省编码 字段:area_plane_event_regist.province_id
     *
     * @return area_plane_event_regist.province_id, 省编码
     */
    public String getProvinceId() {
        return provinceId;
    }

    /**
     * 设置 省编码 字段:area_plane_event_regist.province_id
     *
     * @param provinceId the value for area_plane_event_regist.province_id, 省编码
     */
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * 获取 省名称 字段:area_plane_event_regist.province_name
     *
     * @return area_plane_event_regist.province_name, 省名称
     */
    public String getProvinceName() {
        return provinceName;
    }

    /**
     * 设置 省名称 字段:area_plane_event_regist.province_name
     *
     * @param provinceName the value for area_plane_event_regist.province_name, 省名称
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    /**
     * 获取 市编码 字段:area_plane_event_regist.city_id
     *
     * @return area_plane_event_regist.city_id, 市编码
     */
    public String getCityId() {
        return cityId;
    }

    /**
     * 设置 市编码 字段:area_plane_event_regist.city_id
     *
     * @param cityId the value for area_plane_event_regist.city_id, 市编码
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取 市名称 字段:area_plane_event_regist.city_name
     *
     * @return area_plane_event_regist.city_name, 市名称
     */
    public String getCityName() {
        return cityName;
    }

    /**
     * 设置 市名称 字段:area_plane_event_regist.city_name
     *
     * @param cityName the value for area_plane_event_regist.city_name, 市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取  字段:area_plane_event_regist.county_id
     *
     * @return area_plane_event_regist.county_id, 
     */
    public String getCountyId() {
        return countyId;
    }

    /**
     * 设置  字段:area_plane_event_regist.county_id
     *
     * @param countyId the value for area_plane_event_regist.county_id, 
     */
    public void setCountyId(String countyId) {
        this.countyId = countyId;
    }

    /**
     * 获取  字段:area_plane_event_regist.county_name
     *
     * @return area_plane_event_regist.county_name, 
     */
    public String getCountyName() {
        return countyName;
    }

    /**
     * 设置  字段:area_plane_event_regist.county_name
     *
     * @param countyName the value for area_plane_event_regist.county_name, 
     */
    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    /**
     * 获取  字段:area_plane_event_regist.town_id
     *
     * @return area_plane_event_regist.town_id, 
     */
    public String getTownId() {
        return townId;
    }

    /**
     * 设置  字段:area_plane_event_regist.town_id
     *
     * @param townId the value for area_plane_event_regist.town_id, 
     */
    public void setTownId(String townId) {
        this.townId = townId;
    }

    /**
     * 获取  字段:area_plane_event_regist.town_name
     *
     * @return area_plane_event_regist.town_name, 
     */
    public String getTownName() {
        return townName;
    }

    /**
     * 设置  字段:area_plane_event_regist.town_name
     *
     * @param townName the value for area_plane_event_regist.town_name, 
     */
    public void setTownName(String townName) {
        this.townName = townName;
    }

    /**
     * 获取  字段:area_plane_event_regist.address_detail
     *
     * @return area_plane_event_regist.address_detail, 
     */
    public String getAddressDetail() {
        return addressDetail;
    }

    /**
     * 设置  字段:area_plane_event_regist.address_detail
     *
     * @param addressDetail the value for area_plane_event_regist.address_detail, 
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 获取 登记数量 字段:area_plane_event_regist.buy_num
     *
     * @return area_plane_event_regist.buy_num, 登记数量
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 登记数量 字段:area_plane_event_regist.buy_num
     *
     * @param buyNum the value for area_plane_event_regist.buy_num, 登记数量
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取  字段:area_plane_event_regist.company_sale
     *
     * @return area_plane_event_regist.company_sale, 
     */
    public Double getCompanySale() {
        return companySale;
    }

    /**
     * 设置  字段:area_plane_event_regist.company_sale
     *
     * @param companySale the value for area_plane_event_regist.company_sale, 
     */
    public void setCompanySale(Double companySale) {
        this.companySale = companySale;
    }

    /**
     * 获取 厂方承担金额(分) 字段:area_plane_event_regist.company_amount
     *
     * @return area_plane_event_regist.company_amount, 厂方承担金额(分)
     */
    public Integer getCompanyAmount() {
        return companyAmount;
    }

    /**
     * 设置 厂方承担金额(分) 字段:area_plane_event_regist.company_amount
     *
     * @param companyAmount the value for area_plane_event_regist.company_amount, 厂方承担金额(分)
     */
    public void setCompanyAmount(Integer companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 实际产生费用(分) 字段:area_plane_event_regist.real_amount
     *
     * @return area_plane_event_regist.real_amount, 实际产生费用(分)
     */
    public Integer getRealAmount() {
        return realAmount;
    }

    /**
     * 设置 实际产生费用(分) 字段:area_plane_event_regist.real_amount
     *
     * @param realAmount the value for area_plane_event_regist.real_amount, 实际产生费用(分)
     */
    public void setRealAmount(Integer realAmount) {
        this.realAmount = realAmount;
    }

    /**
     * 获取 活动形式 字段:area_plane_event_regist.activity_form
     *
     * @return area_plane_event_regist.activity_form, 活动形式
     */
    public String getActivityForm() {
        return activityForm;
    }

    /**
     * 设置 活动形式 字段:area_plane_event_regist.activity_form
     *
     * @param activityForm the value for area_plane_event_regist.activity_form, 活动形式
     */
    public void setActivityForm(String activityForm) {
        this.activityForm = activityForm;
    }

    /**
     * 获取 行项目余额 字段:area_plane_event_regist.item_balance
     *
     * @return area_plane_event_regist.item_balance, 行项目余额
     */
    public Integer getItemBalance() {
        return itemBalance;
    }

    /**
     * 设置 行项目余额 字段:area_plane_event_regist.item_balance
     *
     * @param itemBalance the value for area_plane_event_regist.item_balance, 行项目余额
     */
    public void setItemBalance(Integer itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 主题 字段:area_plane_event_regist.theme
     *
     * @return area_plane_event_regist.theme, 主题
     */
    public String getTheme() {
        return theme;
    }

    /**
     * 设置 主题 字段:area_plane_event_regist.theme
     *
     * @param theme the value for area_plane_event_regist.theme, 主题
     */
    public void setTheme(String theme) {
        this.theme = theme;
    }

    /**
     * 获取  字段:area_plane_event_regist.unit
     *
     * @return area_plane_event_regist.unit, 
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 设置  字段:area_plane_event_regist.unit
     *
     * @param unit the value for area_plane_event_regist.unit, 
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 获取  字段:area_plane_event_regist.ticket_amount
     *
     * @return area_plane_event_regist.ticket_amount, 
     */
    public Long getTicketAmount() {
        return ticketAmount;
    }

    /**
     * 设置  字段:area_plane_event_regist.ticket_amount
     *
     * @param ticketAmount the value for area_plane_event_regist.ticket_amount, 
     */
    public void setTicketAmount(Long ticketAmount) {
        this.ticketAmount = ticketAmount;
    }

    /**
     * 获取 宣传回报 字段:area_plane_event_regist.advertise_amount
     *
     * @return area_plane_event_regist.advertise_amount, 宣传回报
     */
    public Long getAdvertiseAmount() {
        return advertiseAmount;
    }

    /**
     * 设置 宣传回报 字段:area_plane_event_regist.advertise_amount
     *
     * @param advertiseAmount the value for area_plane_event_regist.advertise_amount, 宣传回报
     */
    public void setAdvertiseAmount(Long advertiseAmount) {
        this.advertiseAmount = advertiseAmount;
    }

    /**
     * 获取  字段:area_plane_event_regist.show_actor
     *
     * @return area_plane_event_regist.show_actor, 
     */
    public String getShowActor() {
        return showActor;
    }

    /**
     * 设置  字段:area_plane_event_regist.show_actor
     *
     * @param showActor the value for area_plane_event_regist.show_actor, 
     */
    public void setShowActor(String showActor) {
        this.showActor = showActor;
    }

    /**
     * 获取  字段:area_plane_event_regist.guests
     *
     * @return area_plane_event_regist.guests, 
     */
    public String getGuests() {
        return guests;
    }

    /**
     * 设置  字段:area_plane_event_regist.guests
     *
     * @param guests the value for area_plane_event_regist.guests, 
     */
    public void setGuests(String guests) {
        this.guests = guests;
    }

    /**
     * 获取  字段:area_plane_event_regist.create_id
     *
     * @return area_plane_event_regist.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:area_plane_event_regist.create_id
     *
     * @param createId the value for area_plane_event_regist.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:area_plane_event_regist.create_name
     *
     * @return area_plane_event_regist.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:area_plane_event_regist.create_name
     *
     * @param createName the value for area_plane_event_regist.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:area_plane_event_regist.create_date
     *
     * @return area_plane_event_regist.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:area_plane_event_regist.create_date
     *
     * @param createDate the value for area_plane_event_regist.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:area_plane_event_regist.modify_id
     *
     * @return area_plane_event_regist.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:area_plane_event_regist.modify_id
     *
     * @param modifyId the value for area_plane_event_regist.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:area_plane_event_regist.modify_name
     *
     * @return area_plane_event_regist.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:area_plane_event_regist.modify_name
     *
     * @param modifyName the value for area_plane_event_regist.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:area_plane_event_regist.modify_date
     *
     * @return area_plane_event_regist.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:area_plane_event_regist.modify_date
     *
     * @param modifyDate the value for area_plane_event_regist.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 申请单id
     */
    public Integer getApplyId() {
        return this.applyId;
    }

    /**
     * 设置 申请单id
     */
    public void setApplyId(Integer applyId) {
        this.applyId = applyId;
    }

    /**
     * 行号
     * 表字段 : area_point_sponsor_apply.item_no
     */
    public String getItemNo() {
        return this.itemNo;
    }

    /**
     * 行号
     * 表字段 : area_point_sponsor_apply.item_no
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }
}