package com.chinayanghe.tpm.cost.dto.commonManage;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.tpm.cost.constants.ApplyFormStatusEnum;

/**
 * 管理 公共基础DTO
 * @ClassName: com.chinayanghe.tpm.cost.dto.consumerFeastManage.swagger
 * Created by OmarZhang on 2017/5/24 11:51.
 */
public class ManageActivityBaseDto implements Serializable {

    /** 表单编号 */
    private String formNo;

    /** 表单状态 */
    private String status;

    /** 表单标题 */
    private String title;

    /** 经销商名称 */
    private String dealerName;
    /** 经销商编码 */
    private String dealerCode;
    

    /** 创建人 */
    private String createName;

    /** 创建时间 */
    private Date createDate;

    /** 表单类型 */
    private String formType;

    /** 表单状态描述 */
    private String statusDesc;

    /** 申请单号 */
    private String applyNo;

    /** 获取 申请单号 */
    public String getApplyNo() {
        return this.applyNo;
    }

    /** 设置 申请单号 */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /** 获取 创建时间 */
    public Date getCreateDate() {
        return this.createDate;
    }

    /** 设置 创建时间 */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /** 获取 创建人 */
    public String getCreateName() {
        return this.createName;
    }

    /** 设置 创建人 */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /** 获取 经销商名称 */
    public String getDealerName() {
        return this.dealerName;
    }

    /** 设置 经销商名称 */
    public void setDealerName(String dealerName) {
        this.dealerName = dealerName;
    }

    /** 获取 表单编号 */
    public String getFormNo() {
        return this.formNo;
    }

    /** 设置 表单编号 */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /** 获取 表单类型 */
    public String getFormType() {
        return this.formType;
    }

    /** 设置 表单类型 */
    public void setFormType(String formType) {
        this.formType = formType;
    }

    /** 获取 表单状态 */
    public String getStatus() {
        return this.status;
    }

    /** 设置 表单状态 */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 获取 表单状态描述 */
    public String getStatusDesc() {
        if (StringUtils.isNotBlank(this.status)) {
            try {
                return ApplyFormStatusEnum.transferStatus(this.status);
            } catch (IllegalArgumentException e) {}
        }

        return this.statusDesc;
    }

    /** 设置 表单状态描述 */
    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    /** 获取 表单标题 */
    public String getTitle() {
        return this.title;
    }

    /** 设置 表单标题 */
    public void setTitle(String title) {
        this.title = title;
    }

	public String getDealerCode() {
		return dealerCode;
	}

	public void setDealerCode(String dealerCode) {
		this.dealerCode = dealerCode;
	}
    
}


//~ Formatted by Jindent --- http://www.jindent.com
