package com.chinayanghe.tpm.cost.dto.doorPlate;

import java.io.Serializable;
import java.util.Date;

/**
 * 门头牌登记 验收信息
 * DoorplateCheckAcceptDto
 * 数据库表：doorplate_check_accept
 */
public class DoorplateCheckAcceptDto implements Serializable {

    /**
     * 
     * 表字段 : doorplate_check_accept.id
     */
    private Integer id;

    /**
     * 登记单号
     * 表字段 : doorplate_check_accept.regist_no
     */
    private String registNo;

    /**
     * 终端编码
     * 表字段 : doorplate_check_accept.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : doorplate_check_accept.terminal_name
     */
    private String terminalName;

    /**
     * 是否按申报的点位、位置制作
     * 表字段 : doorplate_check_accept.is_place
     */
    private String isPlace;

    /**
     * 是否按照申请的设计效果制作
     * 表字段 : doorplate_check_accept.is_design
     */
    private String isDesign;

    /**
     * 品牌元素是否与申报比例一致
     * 表字段 : doorplate_check_accept.is_brand
     */
    private String isBrand;

    /**
     * 面板尺寸是否与申报要求一致
     * 表字段 : doorplate_check_accept.is_panel_size
     */
    private String isPanelSize;

    /**
     * 外延尺寸是否与申报要求一致
     * 表字段 : doorplate_check_accept.is_extension_size
     */
    private String isExtensionSize;

    /**
     * 面板附着物尺寸（发光字等）是否与申报要求一致
     * 表字段 : doorplate_check_accept.is_attachment_size
     */
    private String isAttachmentSize;

    /**
     * 是否按照申报要求更换钢架（杜绝使用旧钢架）
     * 表字段 : doorplate_check_accept.is_steel
     */
    private String isSteel;

    /**
     * 是否按照申报要求使用材料（如钢化玻璃、铝塑板、发光字等规格)
     * 表字段 : doorplate_check_accept.is_material
     */
    private String isMaterial;

    /**
     * 不合规情况说明
     * 表字段 : doorplate_check_accept.explain
     */
    private String speExplain;

    /**
     * 备注说明
     * 表字段 : doorplate_check_accept.notes
     */
    private String notes;

    /**
     * 验收负责人
     * 表字段 : doorplate_check_accept.contcat
     */
    private String contcat;

    /**
     * 
     * 表字段 : doorplate_check_accept.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : doorplate_check_accept.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : doorplate_check_accept.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : doorplate_check_accept.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : doorplate_check_accept.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : doorplate_check_accept.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table doorplate_check_accept
     *
     * @mbggenerated Sat Jul 01 12:58:08 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:doorplate_check_accept.id
     *
     * @return doorplate_check_accept.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:doorplate_check_accept.id
     *
     * @param id the value for doorplate_check_accept.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 登记单号 字段:doorplate_check_accept.regist_no
     *
     * @return doorplate_check_accept.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:doorplate_check_accept.regist_no
     *
     * @param registNo the value for doorplate_check_accept.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 终端编码 字段:doorplate_check_accept.terminal_id
     *
     * @return doorplate_check_accept.terminal_id, 终端编码
     */
    public String getTerminalId() {
        return terminalId;
    }

    /**
     * 设置 终端编码 字段:doorplate_check_accept.terminal_id
     *
     * @param terminalId the value for doorplate_check_accept.terminal_id, 终端编码
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 获取 终端名称 字段:doorplate_check_accept.terminal_name
     *
     * @return doorplate_check_accept.terminal_name, 终端名称
     */
    public String getTerminalName() {
        return terminalName;
    }

    /**
     * 设置 终端名称 字段:doorplate_check_accept.terminal_name
     *
     * @param terminalName the value for doorplate_check_accept.terminal_name, 终端名称
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 获取 是否按申报的点位、位置制作 字段:doorplate_check_accept.is_place
     *
     * @return doorplate_check_accept.is_place, 是否按申报的点位、位置制作
     */
    public String getIsPlace() {
        return isPlace;
    }

    /**
     * 设置 是否按申报的点位、位置制作 字段:doorplate_check_accept.is_place
     *
     * @param isPlace the value for doorplate_check_accept.is_place, 是否按申报的点位、位置制作
     */
    public void setIsPlace(String isPlace) {
        this.isPlace = isPlace;
    }

    /**
     * 获取 是否按照申请的设计效果制作 字段:doorplate_check_accept.is_design
     *
     * @return doorplate_check_accept.is_design, 是否按照申请的设计效果制作
     */
    public String getIsDesign() {
        return isDesign;
    }

    /**
     * 设置 是否按照申请的设计效果制作 字段:doorplate_check_accept.is_design
     *
     * @param isDesign the value for doorplate_check_accept.is_design, 是否按照申请的设计效果制作
     */
    public void setIsDesign(String isDesign) {
        this.isDesign = isDesign;
    }

    /**
     * 获取 品牌元素是否与申报比例一致 字段:doorplate_check_accept.is_brand
     *
     * @return doorplate_check_accept.is_brand, 品牌元素是否与申报比例一致
     */
    public String getIsBrand() {
        return isBrand;
    }

    /**
     * 设置 品牌元素是否与申报比例一致 字段:doorplate_check_accept.is_brand
     *
     * @param isBrand the value for doorplate_check_accept.is_brand, 品牌元素是否与申报比例一致
     */
    public void setIsBrand(String isBrand) {
        this.isBrand = isBrand;
    }

    /**
     * 获取 面板尺寸是否与申报要求一致 字段:doorplate_check_accept.is_panel_size
     *
     * @return doorplate_check_accept.is_panel_size, 面板尺寸是否与申报要求一致
     */
    public String getIsPanelSize() {
        return isPanelSize;
    }

    /**
     * 设置 面板尺寸是否与申报要求一致 字段:doorplate_check_accept.is_panel_size
     *
     * @param isPanelSize the value for doorplate_check_accept.is_panel_size, 面板尺寸是否与申报要求一致
     */
    public void setIsPanelSize(String isPanelSize) {
        this.isPanelSize = isPanelSize;
    }

    /**
     * 获取 外延尺寸是否与申报要求一致 字段:doorplate_check_accept.is_extension_size
     *
     * @return doorplate_check_accept.is_extension_size, 外延尺寸是否与申报要求一致
     */
    public String getIsExtensionSize() {
        return isExtensionSize;
    }

    /**
     * 设置 外延尺寸是否与申报要求一致 字段:doorplate_check_accept.is_extension_size
     *
     * @param isExtensionSize the value for doorplate_check_accept.is_extension_size, 外延尺寸是否与申报要求一致
     */
    public void setIsExtensionSize(String isExtensionSize) {
        this.isExtensionSize = isExtensionSize;
    }

    /**
     * 获取 面板附着物尺寸（发光字等）是否与申报要求一致 字段:doorplate_check_accept.is_attachment_size
     *
     * @return doorplate_check_accept.is_attachment_size, 面板附着物尺寸（发光字等）是否与申报要求一致
     */
    public String getIsAttachmentSize() {
        return isAttachmentSize;
    }

    /**
     * 设置 面板附着物尺寸（发光字等）是否与申报要求一致 字段:doorplate_check_accept.is_attachment_size
     *
     * @param isAttachmentSize the value for doorplate_check_accept.is_attachment_size, 面板附着物尺寸（发光字等）是否与申报要求一致
     */
    public void setIsAttachmentSize(String isAttachmentSize) {
        this.isAttachmentSize = isAttachmentSize;
    }

    /**
     * 获取 是否按照申报要求更换钢架（杜绝使用旧钢架） 字段:doorplate_check_accept.is_steel
     *
     * @return doorplate_check_accept.is_steel, 是否按照申报要求更换钢架（杜绝使用旧钢架）
     */
    public String getIsSteel() {
        return isSteel;
    }

    /**
     * 设置 是否按照申报要求更换钢架（杜绝使用旧钢架） 字段:doorplate_check_accept.is_steel
     *
     * @param isSteel the value for doorplate_check_accept.is_steel, 是否按照申报要求更换钢架（杜绝使用旧钢架）
     */
    public void setIsSteel(String isSteel) {
        this.isSteel = isSteel;
    }

    /**
     * 获取 是否按照申报要求使用材料（如钢化玻璃、铝塑板、发光字等规格) 字段:doorplate_check_accept.is_material
     *
     * @return doorplate_check_accept.is_material, 是否按照申报要求使用材料（如钢化玻璃、铝塑板、发光字等规格)
     */
    public String getIsMaterial() {
        return isMaterial;
    }

    /**
     * 设置 是否按照申报要求使用材料（如钢化玻璃、铝塑板、发光字等规格) 字段:doorplate_check_accept.is_material
     *
     * @param isMaterial the value for doorplate_check_accept.is_material, 是否按照申报要求使用材料（如钢化玻璃、铝塑板、发光字等规格)
     */
    public void setIsMaterial(String isMaterial) {
        this.isMaterial = isMaterial;
    }

    /**
     * 获取 备注说明 字段:doorplate_check_accept.notes
     *
     * @return doorplate_check_accept.notes, 备注说明
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注说明 字段:doorplate_check_accept.notes
     *
     * @param notes the value for doorplate_check_accept.notes, 备注说明
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取 验收负责人 字段:doorplate_check_accept.contcat
     *
     * @return doorplate_check_accept.contcat, 验收负责人
     */
    public String getContcat() {
        return contcat;
    }

    /**
     * 设置 验收负责人 字段:doorplate_check_accept.contcat
     *
     * @param contcat the value for doorplate_check_accept.contcat, 验收负责人
     */
    public void setContcat(String contcat) {
        this.contcat = contcat;
    }

    /**
     * 获取  字段:doorplate_check_accept.create_id
     *
     * @return doorplate_check_accept.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:doorplate_check_accept.create_id
     *
     * @param createId the value for doorplate_check_accept.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:doorplate_check_accept.create_name
     *
     * @return doorplate_check_accept.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:doorplate_check_accept.create_name
     *
     * @param createName the value for doorplate_check_accept.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:doorplate_check_accept.create_date
     *
     * @return doorplate_check_accept.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:doorplate_check_accept.create_date
     *
     * @param createDate the value for doorplate_check_accept.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:doorplate_check_accept.modify_id
     *
     * @return doorplate_check_accept.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:doorplate_check_accept.modify_id
     *
     * @param modifyId the value for doorplate_check_accept.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:doorplate_check_accept.modify_name
     *
     * @return doorplate_check_accept.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:doorplate_check_accept.modify_name
     *
     * @param modifyName the value for doorplate_check_accept.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:doorplate_check_accept.modify_date
     *
     * @return doorplate_check_accept.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:doorplate_check_accept.modify_date
     *
     * @param modifyDate the value for doorplate_check_accept.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 不合规情况说明
     * 表字段 : doorplate_check_accept.explain
     */
    public String getSpeExplain() {
        return this.speExplain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DoorplateCheckAcceptDto that = (DoorplateCheckAcceptDto) o;

        if (!terminalId.equals(that.terminalId)) return false;
        if (!terminalName.equals(that.terminalName)) return false;
        if (!isPlace.equals(that.isPlace)) return false;
        if (!isDesign.equals(that.isDesign)) return false;
        if (!isBrand.equals(that.isBrand)) return false;
        if (!isPanelSize.equals(that.isPanelSize)) return false;
        if (!isExtensionSize.equals(that.isExtensionSize)) return false;
        if (!isAttachmentSize.equals(that.isAttachmentSize)) return false;
        if (!isSteel.equals(that.isSteel)) return false;
        if (!isMaterial.equals(that.isMaterial)) return false;
        if (!speExplain.equals(that.speExplain)) return false;
        if (notes != null ? !notes.equals(that.notes) : that.notes != null) return false;
        return contcat.equals(that.contcat);
    }

    @Override
    public int hashCode() {
        int result = terminalId.hashCode();
        result = 31 * result + terminalName.hashCode();
        result = 31 * result + isPlace.hashCode();
        result = 31 * result + isDesign.hashCode();
        result = 31 * result + isBrand.hashCode();
        result = 31 * result + isPanelSize.hashCode();
        result = 31 * result + isExtensionSize.hashCode();
        result = 31 * result + isAttachmentSize.hashCode();
        result = 31 * result + isSteel.hashCode();
        result = 31 * result + isMaterial.hashCode();
        result = 31 * result + speExplain.hashCode();
        result = 31 * result + (notes != null ? notes.hashCode() : 0);
        result = 31 * result + contcat.hashCode();
        return result;
    }

    /**
     * 不合规情况说明
     * 表字段 : doorplate_check_accept.explain
     */
    public void setSpeExplain(String speExplain) {
        this.speExplain = speExplain;
    }
}