package com.chinayanghe.tpm.cost.dto.doorPlate;

import java.io.Serializable;
import java.util.Date;

/**
 * 门头牌参照信息
 * DoorplateReferInfoDto
 * 数据库表：doorplate_refer_info
 */
public class DoorplateReferInfoDto implements Serializable {

    /**
     * 
     * 表字段 : doorplate_refer_info.id
     */
    private Integer id;

    /**
     * 
     * 表字段 : doorplate_refer_info.apply_no
     */
    private String applyNo;

    /**
     * 项目洽谈负责人
     * 表字段 : doorplate_refer_info.contact
     */
    private String contact;

    /**
     * 是否是续签项目
     * 表字段 : doorplate_refer_info.renew_project
     */
    private Byte renewProject;

    /**
     * 上年度门牌制作费用
     * 表字段 : doorplate_refer_info.last_amount
     */
    private Long lastAmount;

    /**
     * 销售指标
     * 表字段 : doorplate_refer_info.sale_targets
     */
    private Long saleTargets;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DoorplateReferInfoDto that = (DoorplateReferInfoDto) o;

        if (contact != null ? !contact.equals(that.contact) : that.contact != null) return false;
        if (renewProject != null ? !renewProject.equals(that.renewProject) : that.renewProject != null) return false;
        if (lastAmount != null ? !lastAmount.equals(that.lastAmount) : that.lastAmount != null) return false;
        if (saleTargets != null ? !saleTargets.equals(that.saleTargets) : that.saleTargets != null) return false;
        if (yearlyBudget != null ? !yearlyBudget.equals(that.yearlyBudget) : that.yearlyBudget != null) return false;
        if (finishAmount != null ? !finishAmount.equals(that.finishAmount) : that.finishAmount != null) return false;
        if (scale != null ? !scale.equals(that.scale) : that.scale != null) return false;
        return notes != null ? notes.equals(that.notes) : that.notes == null;
    }

    @Override
    public int hashCode() {
        int result = contact != null ? contact.hashCode() : 0;
        result = 31 * result + (renewProject != null ? renewProject.hashCode() : 0);
        result = 31 * result + (lastAmount != null ? lastAmount.hashCode() : 0);
        result = 31 * result + (saleTargets != null ? saleTargets.hashCode() : 0);
        result = 31 * result + (yearlyBudget != null ? yearlyBudget.hashCode() : 0);
        result = 31 * result + (finishAmount != null ? finishAmount.hashCode() : 0);
        result = 31 * result + (scale != null ? scale.hashCode() : 0);
        result = 31 * result + (notes != null ? notes.hashCode() : 0);
        return result;
    }

    /**
     * 制作年度预算
     * 表字段 : doorplate_refer_info.yearly_budget
     */
    private Long yearlyBudget;

    /**
     * 已完成门牌制作总额
     * 表字段 : doorplate_refer_info.finish_amount
     */
    private Long finishAmount;

    /**
     * 已实施项目占全年预算比例
     * 表字段 : doorplate_refer_info.scale
     */
    private Double scale;

    /**
     * 备注说明
     * 表字段 : doorplate_refer_info.notes
     */
    private String notes;

    /**
     * 
     * 表字段 : doorplate_refer_info.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : doorplate_refer_info.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : doorplate_refer_info.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : doorplate_refer_info.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : doorplate_refer_info.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : doorplate_refer_info.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table doorplate_refer_info
     *
     * @mbggenerated Fri Jun 30 10:46:04 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:doorplate_refer_info.id
     *
     * @return doorplate_refer_info.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:doorplate_refer_info.id
     *
     * @param id the value for doorplate_refer_info.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取  字段:doorplate_refer_info.apply_no
     *
     * @return doorplate_refer_info.apply_no, 
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置  字段:doorplate_refer_info.apply_no
     *
     * @param applyNo the value for doorplate_refer_info.apply_no, 
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 项目洽谈负责人 字段:doorplate_refer_info.contact
     *
     * @return doorplate_refer_info.contact, 项目洽谈负责人
     */
    public String getContact() {
        return contact;
    }

    /**
     * 设置 项目洽谈负责人 字段:doorplate_refer_info.contact
     *
     * @param contact the value for doorplate_refer_info.contact, 项目洽谈负责人
     */
    public void setContact(String contact) {
        this.contact = contact;
    }

    /**
     * 获取 是否是续签项目 字段:doorplate_refer_info.renew_project
     *
     * @return doorplate_refer_info.renew_project, 是否是续签项目
     */
    public Byte getRenewProject() {
        return renewProject;
    }

    /**
     * 设置 是否是续签项目 字段:doorplate_refer_info.renew_project
     *
     * @param renewProject the value for doorplate_refer_info.renew_project, 是否是续签项目
     */
    public void setRenewProject(Byte renewProject) {
        this.renewProject = renewProject;
    }

    /**
     * 获取 上年度门牌制作费用 字段:doorplate_refer_info.last_amount
     *
     * @return doorplate_refer_info.last_amount, 上年度门牌制作费用
     */
    public Long getLastAmount() {
        return lastAmount;
    }

    /**
     * 设置 上年度门牌制作费用 字段:doorplate_refer_info.last_amount
     *
     * @param lastAmount the value for doorplate_refer_info.last_amount, 上年度门牌制作费用
     */
    public void setLastAmount(Long lastAmount) {
        this.lastAmount = lastAmount;
    }

    /**
     * 获取 销售指标 字段:doorplate_refer_info.sale_targets
     *
     * @return doorplate_refer_info.sale_targets, 销售指标
     */
    public Long getSaleTargets() {
        return saleTargets;
    }

    /**
     * 设置 销售指标 字段:doorplate_refer_info.sale_targets
     *
     * @param saleTargets the value for doorplate_refer_info.sale_targets, 销售指标
     */
    public void setSaleTargets(Long saleTargets) {
        this.saleTargets = saleTargets;
    }

    /**
     * 获取 制作年度预算 字段:doorplate_refer_info.yearly_budget
     *
     * @return doorplate_refer_info.yearly_budget, 制作年度预算
     */
    public Long getYearlyBudget() {
        return yearlyBudget;
    }

    /**
     * 设置 制作年度预算 字段:doorplate_refer_info.yearly_budget
     *
     * @param yearlyBudget the value for doorplate_refer_info.yearly_budget, 制作年度预算
     */
    public void setYearlyBudget(Long yearlyBudget) {
        this.yearlyBudget = yearlyBudget;
    }

    /**
     * 获取 已完成门牌制作总额 字段:doorplate_refer_info.finish_amount
     *
     * @return doorplate_refer_info.finish_amount, 已完成门牌制作总额
     */
    public Long getFinishAmount() {
        return finishAmount;
    }

    /**
     * 设置 已完成门牌制作总额 字段:doorplate_refer_info.finish_amount
     *
     * @param finishAmount the value for doorplate_refer_info.finish_amount, 已完成门牌制作总额
     */
    public void setFinishAmount(Long finishAmount) {
        this.finishAmount = finishAmount;
    }

    /**
     * 获取 已实施项目占全年预算比例 字段:doorplate_refer_info.scale
     *
     * @return doorplate_refer_info.scale, 已实施项目占全年预算比例
     */
    public Double getScale() {
        return scale;
    }

    /**
     * 设置 已实施项目占全年预算比例 字段:doorplate_refer_info.scale
     *
     * @param scale the value for doorplate_refer_info.scale, 已实施项目占全年预算比例
     */
    public void setScale(Double scale) {
        this.scale = scale;
    }

    /**
     * 获取 备注说明 字段:doorplate_refer_info.notes
     *
     * @return doorplate_refer_info.notes, 备注说明
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注说明 字段:doorplate_refer_info.notes
     *
     * @param notes the value for doorplate_refer_info.notes, 备注说明
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取  字段:doorplate_refer_info.create_id
     *
     * @return doorplate_refer_info.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:doorplate_refer_info.create_id
     *
     * @param createId the value for doorplate_refer_info.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:doorplate_refer_info.create_name
     *
     * @return doorplate_refer_info.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:doorplate_refer_info.create_name
     *
     * @param createName the value for doorplate_refer_info.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:doorplate_refer_info.create_date
     *
     * @return doorplate_refer_info.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:doorplate_refer_info.create_date
     *
     * @param createDate the value for doorplate_refer_info.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:doorplate_refer_info.modify_id
     *
     * @return doorplate_refer_info.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:doorplate_refer_info.modify_id
     *
     * @param modifyId the value for doorplate_refer_info.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:doorplate_refer_info.modify_name
     *
     * @return doorplate_refer_info.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:doorplate_refer_info.modify_name
     *
     * @param modifyName the value for doorplate_refer_info.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:doorplate_refer_info.modify_date
     *
     * @return doorplate_refer_info.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:doorplate_refer_info.modify_date
     *
     * @param modifyDate the value for doorplate_refer_info.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}