package com.chinayanghe.tpm.cost.dto.guestReceive;

import java.util.Date;

/**
 * 来宾接待活动信息
 * GuestActivityInfo
 * 数据库表：guest_activity_info
 */
public class GuestActivityInfo {

    /**
     * 
     * 表字段 : guest_activity_info.id
     */
    private Integer id;

    /**
     * 表单号(申请、登记、核报、临时报备)
     * 表字段 : guest_activity_info.form_no
     */
    private String formNo;

    /**
     * 来宾单位名称
     * 表字段 : guest_activity_info.guest_company
     */
    private String guestCompany;

    /**
     * 来宾人数
     * 表字段 : guest_activity_info.guest_num
     */
    private Integer guestNum;

    /**
     * 带队人姓名
     * 表字段 : guest_activity_info.team_leader
     */
    private String teamLeader;

    /**
     * 带队人电话
     * 表字段 : guest_activity_info.leader_phone
     */
    private String leaderPhone;

    /**
     * 陪同人数
     * 表字段 : guest_activity_info.accompany_num
     */
    private Integer accompanyNum;

    /**
     * 申请人农行卡号
     * 表字段 : guest_activity_info.apply_person_bank_no
     */
    private String applyPersonBankNo;

    /**
     * 开户人姓名
     * 表字段 : guest_activity_info.own_deposit
     */
    private String ownDeposit;

    /**
     * 开户省份
     * 表字段 : guest_activity_info.bank_province
     */
    private String bankProvince;

    /**
     * 餐费合计/分
     * 表字段 : guest_activity_info.meals_amount_total
     */
    private Long mealsAmountTotal;

    /**
     * 餐费承担方
     * 表字段 : guest_activity_info.meals_amount_pay
     */
    private String mealsAmountPay;

    /**
     * 住宿费用合计/分
     * 表字段 : guest_activity_info.acco_amount_total
     */
    private Long accoAmountTotal;

    /**
     * 住宿费承担方
     * 表字段 : guest_activity_info.acco_amount_pay
     */
    private String accoAmountPay;

    /**
     * LED电子屏欢迎内容
     * 表字段 : guest_activity_info.welcome_content
     */
    private String welcomeContent;

    /**
     * 参观安排
     * 表字段 : guest_activity_info.visit_plan
     */
    private String visitPlan;

    /**
     * 是否需要接车（机）
     * 表字段 : guest_activity_info.need_shuttle_arrive
     */
    private Integer needShuttleArrive;

    /**
     * 接车（机）时间、地点
     * 表字段 : guest_activity_info.shuttle_arrive
     */
    private String shuttleArrive;

    /**
     * 是否需要送车（机）
     * 表字段 : guest_activity_info.need_shuttle_leave
     */
    private Integer needShuttleLeave;

    /**
     * 送车（机）时间、地点
     * 表字段 : guest_activity_info.shuttle_leave
     */
    private String shuttleLeave;

    /**
     * 是否需要领导陪同
     * 表字段 : guest_activity_info.need_leader_accp
     */
    private Integer needLeaderAccp;

    /**
     * 参观费用合计/分
     * 表字段 : guest_activity_info.visit_amount_total
     */
    private Long visitAmountTotal;

    /**
     * 参观费用承担方
     * 表字段 : guest_activity_info.visit_amount_pay
     */
    private String visitAmountPay;

    /**
     * 景点路线信息
     * 表字段 : guest_activity_info.visit_route_info
     */
    private String visitRouteInfo;

    /**
     * 
     * 表字段 : guest_activity_info.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : guest_activity_info.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : guest_activity_info.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : guest_activity_info.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : guest_activity_info.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : guest_activity_info.modify_date
     */
    private Date modifyDate;

    /**
     * 获取  字段:guest_activity_info.id
     *
     * @return guest_activity_info.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:guest_activity_info.id
     *
     * @param id the value for guest_activity_info.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 表单号(申请、登记、核报、临时报备) 字段:guest_activity_info.form_no
     *
     * @return guest_activity_info.form_no, 表单号(申请、登记、核报、临时报备)
     */
    public String getFormNo() {
        return formNo;
    }

    /**
     * 设置 表单号(申请、登记、核报、临时报备) 字段:guest_activity_info.form_no
     *
     * @param formNo the value for guest_activity_info.form_no, 表单号(申请、登记、核报、临时报备)
     */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /**
     * 获取 来宾单位名称 字段:guest_activity_info.guest_company
     *
     * @return guest_activity_info.guest_company, 来宾单位名称
     */
    public String getGuestCompany() {
        return guestCompany;
    }

    /**
     * 设置 来宾单位名称 字段:guest_activity_info.guest_company
     *
     * @param guestCompany the value for guest_activity_info.guest_company, 来宾单位名称
     */
    public void setGuestCompany(String guestCompany) {
        this.guestCompany = guestCompany;
    }

    /**
     * 获取 来宾人数 字段:guest_activity_info.guest_num
     *
     * @return guest_activity_info.guest_num, 来宾人数
     */
    public Integer getGuestNum() {
        return guestNum;
    }

    /**
     * 设置 来宾人数 字段:guest_activity_info.guest_num
     *
     * @param guestNum the value for guest_activity_info.guest_num, 来宾人数
     */
    public void setGuestNum(Integer guestNum) {
        this.guestNum = guestNum;
    }

    /**
     * 获取 带队人姓名 字段:guest_activity_info.team_leader
     *
     * @return guest_activity_info.team_leader, 带队人姓名
     */
    public String getTeamLeader() {
        return teamLeader;
    }

    /**
     * 设置 带队人姓名 字段:guest_activity_info.team_leader
     *
     * @param teamLeader the value for guest_activity_info.team_leader, 带队人姓名
     */
    public void setTeamLeader(String teamLeader) {
        this.teamLeader = teamLeader;
    }

    /**
     * 获取 带队人电话 字段:guest_activity_info.leader_phone
     *
     * @return guest_activity_info.leader_phone, 带队人电话
     */
    public String getLeaderPhone() {
        return leaderPhone;
    }

    /**
     * 设置 带队人电话 字段:guest_activity_info.leader_phone
     *
     * @param leaderPhone the value for guest_activity_info.leader_phone, 带队人电话
     */
    public void setLeaderPhone(String leaderPhone) {
        this.leaderPhone = leaderPhone;
    }

    /**
     * 获取 陪同人数 字段:guest_activity_info.accompany_num
     *
     * @return guest_activity_info.accompany_num, 陪同人数
     */
    public Integer getAccompanyNum() {
        return accompanyNum;
    }

    /**
     * 设置 陪同人数 字段:guest_activity_info.accompany_num
     *
     * @param accompanyNum the value for guest_activity_info.accompany_num, 陪同人数
     */
    public void setAccompanyNum(Integer accompanyNum) {
        this.accompanyNum = accompanyNum;
    }

    /**
     * 获取 申请人农行卡号 字段:guest_activity_info.apply_person_bank_no
     *
     * @return guest_activity_info.apply_person_bank_no, 申请人农行卡号
     */
    public String getApplyPersonBankNo() {
        return applyPersonBankNo;
    }

    /**
     * 设置 申请人农行卡号 字段:guest_activity_info.apply_person_bank_no
     *
     * @param applyPersonBankNo the value for guest_activity_info.apply_person_bank_no, 申请人农行卡号
     */
    public void setApplyPersonBankNo(String applyPersonBankNo) {
        this.applyPersonBankNo = applyPersonBankNo;
    }

    /**
     * 获取 开户人姓名 字段:guest_activity_info.own_deposit
     *
     * @return guest_activity_info.own_deposit, 开户人姓名
     */
    public String getOwnDeposit() {
        return ownDeposit;
    }

    /**
     * 设置 开户人姓名 字段:guest_activity_info.own_deposit
     *
     * @param ownDeposit the value for guest_activity_info.own_deposit, 开户人姓名
     */
    public void setOwnDeposit(String ownDeposit) {
        this.ownDeposit = ownDeposit;
    }

    /**
     * 获取 开户省份 字段:guest_activity_info.bank_province
     *
     * @return guest_activity_info.bank_province, 开户省份
     */
    public String getBankProvince() {
        return bankProvince;
    }

    /**
     * 设置 开户省份 字段:guest_activity_info.bank_province
     *
     * @param bankProvince the value for guest_activity_info.bank_province, 开户省份
     */
    public void setBankProvince(String bankProvince) {
        this.bankProvince = bankProvince;
    }

    /**
     * 获取 餐费合计/分 字段:guest_activity_info.meals_amount_total
     *
     * @return guest_activity_info.meals_amount_total, 餐费合计/分
     */
    public Long getMealsAmountTotal() {
        return mealsAmountTotal;
    }

    /**
     * 设置 餐费合计/分 字段:guest_activity_info.meals_amount_total
     *
     * @param mealsAmountTotal the value for guest_activity_info.meals_amount_total, 餐费合计/分
     */
    public void setMealsAmountTotal(Long mealsAmountTotal) {
        this.mealsAmountTotal = mealsAmountTotal;
    }

    /**
     * 获取 餐费承担方 字段:guest_activity_info.meals_amount_pay
     *
     * @return guest_activity_info.meals_amount_pay, 餐费承担方
     */
    public String getMealsAmountPay() {
        return mealsAmountPay;
    }

    /**
     * 设置 餐费承担方 字段:guest_activity_info.meals_amount_pay
     *
     * @param mealsAmountPay the value for guest_activity_info.meals_amount_pay, 餐费承担方
     */
    public void setMealsAmountPay(String mealsAmountPay) {
        this.mealsAmountPay = mealsAmountPay;
    }

    /**
     * 获取 住宿费用合计/分 字段:guest_activity_info.acco_amount_total
     *
     * @return guest_activity_info.acco_amount_total, 住宿费用合计/分
     */
    public Long getAccoAmountTotal() {
        return accoAmountTotal;
    }

    /**
     * 设置 住宿费用合计/分 字段:guest_activity_info.acco_amount_total
     *
     * @param accoAmountTotal the value for guest_activity_info.acco_amount_total, 住宿费用合计/分
     */
    public void setAccoAmountTotal(Long accoAmountTotal) {
        this.accoAmountTotal = accoAmountTotal;
    }

    /**
     * 获取 住宿费承担方 字段:guest_activity_info.acco_amount_pay
     *
     * @return guest_activity_info.acco_amount_pay, 住宿费承担方
     */
    public String getAccoAmountPay() {
        return accoAmountPay;
    }

    /**
     * 设置 住宿费承担方 字段:guest_activity_info.acco_amount_pay
     *
     * @param accoAmountPay the value for guest_activity_info.acco_amount_pay, 住宿费承担方
     */
    public void setAccoAmountPay(String accoAmountPay) {
        this.accoAmountPay = accoAmountPay;
    }

    /**
     * 获取 LED电子屏欢迎内容 字段:guest_activity_info.welcome_content
     *
     * @return guest_activity_info.welcome_content, LED电子屏欢迎内容
     */
    public String getWelcomeContent() {
        return welcomeContent;
    }

    /**
     * 设置 LED电子屏欢迎内容 字段:guest_activity_info.welcome_content
     *
     * @param welcomeContent the value for guest_activity_info.welcome_content, LED电子屏欢迎内容
     */
    public void setWelcomeContent(String welcomeContent) {
        this.welcomeContent = welcomeContent;
    }

    /**
     * 获取 参观安排 字段:guest_activity_info.visit_plan
     *
     * @return guest_activity_info.visit_plan, 参观安排
     */
    public String getVisitPlan() {
        return visitPlan;
    }

    /**
     * 设置 参观安排 字段:guest_activity_info.visit_plan
     *
     * @param visitPlan the value for guest_activity_info.visit_plan, 参观安排
     */
    public void setVisitPlan(String visitPlan) {
        this.visitPlan = visitPlan;
    }

    /**
     * 获取 是否需要接车（机） 字段:guest_activity_info.need_shuttle_arrive
     *
     * @return guest_activity_info.need_shuttle_arrive, 是否需要接车（机）
     */
    public Integer getNeedShuttleArrive() {
        return needShuttleArrive;
    }

    /**
     * 设置 是否需要接车（机） 字段:guest_activity_info.need_shuttle_arrive
     *
     * @param needShuttleArrive the value for guest_activity_info.need_shuttle_arrive, 是否需要接车（机）
     */
    public void setNeedShuttleArrive(Integer needShuttleArrive) {
        this.needShuttleArrive = needShuttleArrive;
    }

    /**
     * 获取 接车（机）时间、地点 字段:guest_activity_info.shuttle_arrive
     *
     * @return guest_activity_info.shuttle_arrive, 接车（机）时间、地点
     */
    public String getShuttleArrive() {
        return shuttleArrive;
    }

    /**
     * 设置 接车（机）时间、地点 字段:guest_activity_info.shuttle_arrive
     *
     * @param shuttleArrive the value for guest_activity_info.shuttle_arrive, 接车（机）时间、地点
     */
    public void setShuttleArrive(String shuttleArrive) {
        this.shuttleArrive = shuttleArrive;
    }

    /**
     * 获取 是否需要送车（机） 字段:guest_activity_info.need_shuttle_leave
     *
     * @return guest_activity_info.need_shuttle_leave, 是否需要送车（机）
     */
    public Integer getNeedShuttleLeave() {
        return needShuttleLeave;
    }

    /**
     * 设置 是否需要送车（机） 字段:guest_activity_info.need_shuttle_leave
     *
     * @param needShuttleLeave the value for guest_activity_info.need_shuttle_leave, 是否需要送车（机）
     */
    public void setNeedShuttleLeave(Integer needShuttleLeave) {
        this.needShuttleLeave = needShuttleLeave;
    }

    /**
     * 获取 送车（机）时间、地点 字段:guest_activity_info.shuttle_leave
     *
     * @return guest_activity_info.shuttle_leave, 送车（机）时间、地点
     */
    public String getShuttleLeave() {
        return shuttleLeave;
    }

    /**
     * 设置 送车（机）时间、地点 字段:guest_activity_info.shuttle_leave
     *
     * @param shuttleLeave the value for guest_activity_info.shuttle_leave, 送车（机）时间、地点
     */
    public void setShuttleLeave(String shuttleLeave) {
        this.shuttleLeave = shuttleLeave;
    }

    /**
     * 获取 是否需要领导陪同 字段:guest_activity_info.need_leader_accp
     *
     * @return guest_activity_info.need_leader_accp, 是否需要领导陪同
     */
    public Integer getNeedLeaderAccp() {
        return needLeaderAccp;
    }

    /**
     * 设置 是否需要领导陪同 字段:guest_activity_info.need_leader_accp
     *
     * @param needLeaderAccp the value for guest_activity_info.need_leader_accp, 是否需要领导陪同
     */
    public void setNeedLeaderAccp(Integer needLeaderAccp) {
        this.needLeaderAccp = needLeaderAccp;
    }

    /**
     * 获取 参观费用合计/分 字段:guest_activity_info.visit_amount_total
     *
     * @return guest_activity_info.visit_amount_total, 参观费用合计/分
     */
    public Long getVisitAmountTotal() {
        return visitAmountTotal;
    }

    /**
     * 设置 参观费用合计/分 字段:guest_activity_info.visit_amount_total
     *
     * @param visitAmountTotal the value for guest_activity_info.visit_amount_total, 参观费用合计/分
     */
    public void setVisitAmountTotal(Long visitAmountTotal) {
        this.visitAmountTotal = visitAmountTotal;
    }

    /**
     * 获取 参观费用承担方 字段:guest_activity_info.visit_amount_pay
     *
     * @return guest_activity_info.visit_amount_pay, 参观费用承担方
     */
    public String getVisitAmountPay() {
        return visitAmountPay;
    }

    /**
     * 设置 参观费用承担方 字段:guest_activity_info.visit_amount_pay
     *
     * @param visitAmountPay the value for guest_activity_info.visit_amount_pay, 参观费用承担方
     */
    public void setVisitAmountPay(String visitAmountPay) {
        this.visitAmountPay = visitAmountPay;
    }

    /**
     * 获取 景点路线信息 字段:guest_activity_info.visit_route_info
     *
     * @return guest_activity_info.visit_route_info, 景点路线信息
     */
    public String getVisitRouteInfo() {
        return visitRouteInfo;
    }

    /**
     * 设置 景点路线信息 字段:guest_activity_info.visit_route_info
     *
     * @param visitRouteInfo the value for guest_activity_info.visit_route_info, 景点路线信息
     */
    public void setVisitRouteInfo(String visitRouteInfo) {
        this.visitRouteInfo = visitRouteInfo;
    }

    /**
     * 获取  字段:guest_activity_info.create_id
     *
     * @return guest_activity_info.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:guest_activity_info.create_id
     *
     * @param createId the value for guest_activity_info.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:guest_activity_info.create_name
     *
     * @return guest_activity_info.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:guest_activity_info.create_name
     *
     * @param createName the value for guest_activity_info.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:guest_activity_info.create_date
     *
     * @return guest_activity_info.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:guest_activity_info.create_date
     *
     * @param createDate the value for guest_activity_info.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:guest_activity_info.modify_id
     *
     * @return guest_activity_info.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:guest_activity_info.modify_id
     *
     * @param modifyId the value for guest_activity_info.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:guest_activity_info.modify_name
     *
     * @return guest_activity_info.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:guest_activity_info.modify_name
     *
     * @param modifyName the value for guest_activity_info.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:guest_activity_info.modify_date
     *
     * @return guest_activity_info.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:guest_activity_info.modify_date
     *
     * @param modifyDate the value for guest_activity_info.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}