package com.chinayanghe.tpm.cost.utils;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccessStatus {
    @Description(
        value                                                       = "操作成功",
        key                                                         = 1000
    )
    public static int                     SERVER_SUCCESS            = 1000;
    @Description(
        value                                                       = "服务器错误",
        key                                                         = 1001
    )
    public static int                     SERVER_GENERIC_ERROR      = 1001;
    @Description(
        value                                                       = "缺少参数",
        key                                                         = 1002
    )
    public static int                     INVALID_REQUEST_PARAMETER = 1002;
    protected static Map<Integer, String> descriptionMap            = new LinkedHashMap<>();

    static {
        Field[] fields = AccessStatus.class.getDeclaredFields();

        for (Field field : fields) {
            if (field.isAnnotationPresent(Description.class)) {
                Description description = field.getAnnotation(Description.class);

                descriptionMap.put(description.key(), description.value());
            }
        }
    }

    public static String getDescription(int errorCode) {
        return descriptionMap.get(errorCode);
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
