package com.chinayanghe.tpm.cost.utils;

import cn.com.bizunited.cp.common.web.utils.WebApplicationContextUtils;
import com.chinayanghe.tpm.cost.constants.Constants;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * 编码生成器
 */
public final class CostGeneratorCodeUtils {

    private final static byte[] HASH_KEY = "generatorCode".getBytes();

    private static JedisConnectionFactory connectionFactory = WebApplicationContextUtils.getInstance().get("jedisConnectionFactory",JedisConnectionFactory.class);

    private static ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private CostGeneratorCodeUtils() {}

    /**
     * 生成唯一性编码CODE
     * @param codeType 前缀标识
     * @return
     */
    public static String code(final Constants.CodeType codeType) {
        RedisConnection redisConnection = null;
        try {
            redisConnection = RedisConnectionUtils.getConnection(connectionFactory);
            Long startInterVal = codeType.getIntervalType().getCodeInterval().getStartInterval();
            //是否存在
            if(!redisConnection.hExists(HASH_KEY,codeType.formatMarkByte())) {
                redisConnection.hSet(HASH_KEY,codeType.formatMarkByte(),new String(String.valueOf(startInterVal)).getBytes());
                return codeType.getCode().concat(String.valueOf(startInterVal));
            }else {
                Long increLong = redisConnection.hIncrBy(HASH_KEY,codeType.formatMarkByte(),1);
                return codeType.getCode().concat(String.valueOf(increLong));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            RedisConnectionUtils.releaseConnection(redisConnection,connectionFactory);
        }
        throw new RuntimeException("生成code出错!");
    }
}