
/**
 * @Description:
 * @ClassName: cn.com.bizunited.cp.common.web.utils.AdminLTEParseUtils
 * @author: Omar(OmarZhang)
 * @date: 2016年5月6日 下午12:32:56
 */
package com.chinayanghe.tpm.cost.utils;

import cn.com.bizunited.cp.common.pagination.CommonSort;
import cn.com.bizunited.cp.common.pagination.Pageable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Description:
 * @ClassName: cn.com.bizunited.cp.common.web.utils.AdminLTEParseUtils
 * @author: Omar(OmarZhang)
 * @date: 2016年5月6日 下午12:32:56
 *
 */
public final class JqGridParseUtils {

    /**
     * 搜索类型
     * @Description:
     * @ClassName: cn.com.bizunited.cp.common.web.utils.AdminLTEParseUtils.SearchType
     * @author: Omar(OmarZhang)
     * @date: 2016年8月4日 下午4:27:58
     *
     */
    public enum SearchType {

        /** 日期 */
        DATE,

        /** 集合 */
        LIST
    }

    /**
     * 将编码转换为UTF-8
     * @Title: getSearchByRequest
     * @param toParseStr 被转换的字符串
     * @return
     * @author: Omar(OmarZhang)
     * @date: 2016年5月6日 下午12:39:15
     */
    public static String parseToUTF8(String toParseStr) {
        if (StringUtils.isNotBlank(toParseStr)) {
            return toChinese(toParseStr);
        }

        return toParseStr;
    }

    private static String toChinese(String msg) {
        if (isMessyCode(msg)) {
            try {
                return new String(msg.getBytes("ISO8859-1"), "UTF-8");
            } catch (Exception e) {}
        }

        return msg;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);

        if ((ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS)
                || (ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS)
                || (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A)
                || (ub == Character.UnicodeBlock.GENERAL_PUNCTUATION)
                || (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION)
                || (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS)) {
            return true;
        }

        return false;
    }

    private static boolean isMessyCode(String strName) {
        Pattern p        = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m        = p.matcher(strName);
        String  after    = m.replaceAll("");
        String  temp     = after.replaceAll("\\p{P}", "");
        char[]  ch       = temp.trim().toCharArray();
        float   chLength = 0;
        float   count    = 0;

        for (int i = 0; i < ch.length; i++) {
            char c = ch[i];

            if (!Character.isLetterOrDigit(c)) {
                if (!isChinese(c)) {
                    count = count + 1;
                }

                chLength++;
            }
        }

        float result = count / chLength;

        if (result > 0.4) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 通过http获取排序信息
     * @Title: getByRequest
     * @param request
     * @return
     * @author: Omar(OmarZhang)
     * @date: 2016年5月6日 下午12:34:47
     */
    public static Pageable getPageableByRequest(HttpServletRequest request) {
        String columnName = request.getParameter("sidx");
        String sort       = request.getParameter("sord");
        String page       = request.getParameter("page");
        String rows       = request.getParameter("rows");
        String sortName   = columnName.replaceAll("[A-Z]+", "_$0");
        String isCount    = request.getParameter("isCount");

        isCount = StringUtils.isEmpty(isCount)
                  ? "true"
                  : isCount;

        Pageable pageable = new Pageable(StringUtils.isEmpty(page)
                                         ? 1
                                         : Integer.valueOf(page),
                                         StringUtils.isEmpty(rows)
                                         ? 10
                                         : Integer.valueOf(rows),
                                         BooleanUtils.toBoolean(isCount),
                                         null,
                                         new CommonSort(sortName, sort));

        pageable.getIsCount();

        return pageable;
    }

    /**
     * 通过http获取排序信息
     * @Title: getByRequest
     * @param request
     * @return
     * @author: Omar(OmarZhang)
     * @date: 2016年5月6日 下午12:34:47
     */
    public static Pageable getPageableByRequest(HttpServletRequest request, Integer start, Integer length) {
        String columnName = request.getParameter("sidx");
        String sort       = request.getParameter("sord");
        String page       = request.getParameter("page");
        String rows       = request.getParameter("rows");

        if ((start != null) && (length != null)) {
            page = String.valueOf(start / length + 1);
            rows = String.valueOf(length);
        }

        String sortName = columnName.replaceAll("[A-Z]+", "_$0");
        String isCount  = request.getParameter("isCount");

        isCount = StringUtils.isEmpty(isCount)
                  ? "true"
                  : isCount;

        Pageable pageable = new Pageable(StringUtils.isEmpty(page)
                                         ? 1
                                         : Integer.valueOf(page),
                                         StringUtils.isEmpty(rows)
                                         ? 10
                                         : Integer.valueOf(rows),
                                         BooleanUtils.toBoolean(isCount),
                                         null,
                                         new CommonSort(sortName, sort));

        pageable.getIsCount();

        return pageable;
    }

    /**
     * 通过http获取排序信息
     * @Title: getByRequest
     * @param request
     * @return
     * @author: Omar(OmarZhang)
     * @date: 2016年5月6日 下午12:34:47
     */
    public static CommonSort getSortByRequest(HttpServletRequest request) {
        String columnName = request.getParameter("sidx");
        String sort       = request.getParameter("sord");
        String sortName   = columnName.replaceAll("[A-Z]+", "_$0");

        return new CommonSort(sortName, sort);
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
