package com.chinayanghe.tpm.cost.utils;

import com.chinayanghe.tpm.cost.constants.Constants;
import org.apache.commons.lang.StringUtils;

/**
 * 编码生成器
 */
public final class RandomGeneratorCodeUtils {
    private volatile static SnowflakeIdWorker snowflakeIdWorker = null;

    private RandomGeneratorCodeUtils() {}

    /**
     * 生成唯一性编码CODE
     * @param codeType 前缀标识
     * @return
     */
    public static String code(final Constants.CodeType codeType) {
        if (codeType == null) {
            throw new RuntimeException(" codeType not found ");
        }

        return code(codeType.getCode(), 0, 0);
    }

    /**
     * 生成唯一性编码CODE
     * @param prefixMark 前缀标识
     * @return
     */
    public static String code(final String prefixMark) {
        return code(prefixMark, 0, 0);
    }

    /**
     * 生成唯一性编码CODE
     * @Title: code
     * @param prefixMark 前缀标识
     * @param markCode 机器标志码(主要为了以后的集群)
     * @param projectMarkCode 项目标识码(主要分区项目)
     * @return 自动生成
     * @author: Omar(OmarZhang)
     * @date: 2016年5月22日 下午4:04:50
     */
    public static synchronized String code(final String prefixMark, final int markCode, final int projectMarkCode) {
        if (snowflakeIdWorker == null) {
            snowflakeIdWorker = new SnowflakeIdWorker(markCode, projectMarkCode);
        }

        if (StringUtils.isNotBlank(prefixMark)) {
            return prefixMark.concat(String.valueOf(snowflakeIdWorker.nextId()));
        }

        return String.valueOf(snowflakeIdWorker.nextId());
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10000; i++) {
            System.out.println(RandomGeneratorCodeUtils.code(Constants.CodeType.CUSTOMER_APPLY_CODE));
        }
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
