package com.chinayanghe.tpm.cost.utils;

import org.apache.commons.lang.StringUtils;

import java.text.DecimalFormat;

/**
 * 字符串操作工具
 * @author isshu
 *
 */
public class StringUtil {
     private static DecimalFormat format = new DecimalFormat("#.##");
    /**
     * 字符串为空 或是空字符串都认为是空
     * @param str
     * @return
     */
    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty(str) || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public static String intPriceParseStr(Integer price){
        if (price == null){
            return "0.00";
        }
        return format.format(price / 100.0);
    }

    public static String longPriceParseStr(Long price){
        if (price == null){
            return "0.00";
        }
        return format.format(price / 100.0);
    }

}


//~ Formatted by Jindent --- http://www.jindent.com
