package com.chinayanghe.tpm.cost.vo;

import com.chinayanghe.tpm.cost.constants.ApplyFormStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 表单结果返回VO
 * @ClassName: com.chinayanghe.tpm.cost.vo.swagger
 * Created by OmarZhang on 2017/5/21 23:28.
 */
public class AjaxFormResponseVo implements Serializable {

    /** 创建时间 */
    private Date date = new Date();

    /** 状态 */
    private String status = ApplyFormStatusEnum.applyStatus35.getDesc();

    /** 是否成功 */
    private Boolean isSuccess = Boolean.TRUE;

    /** 表单编号 */
    private String formNo;
    
    /** 提示信息 */
    private String message;

    public AjaxFormResponseVo(Boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public AjaxFormResponseVo(String status, Boolean isSuccess) {
        this.status    = status;
        this.isSuccess = isSuccess;
    }

    public AjaxFormResponseVo(Date date, String formNo, String status) {
        this.date   = date;
        this.formNo = formNo;
        this.status = status;
    }

    public AjaxFormResponseVo(String formNo, String status, Boolean isSuccess) {
        this.formNo    = formNo;
        this.status    = status;
        this.isSuccess = isSuccess;
    }
    
    public AjaxFormResponseVo(String formNo, String status, Boolean isSuccess,String message) {
        this.formNo    = formNo;
        this.status    = status;
        this.isSuccess = isSuccess;
        this.message = message;
    }

    /** 获取 创建时间 */
    public Date getDate() {
        return this.date;
    }

    /** 设置 创建时间 */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 获取 表单编号 */
    public String getFormNo() {
        return this.formNo;
    }

    /** 设置 表单编号 */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /** 获取 是否成功 */
    public Boolean getIsSuccess() {
        return this.isSuccess;
    }

    /** 设置 是否成功 */
    public void setIsSuccess(Boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    /** 获取 状态 */
    public String getStatus() {
        return this.status;
    }

    /** 设置 状态 */
    public void setStatus(String status) {
        this.status = status;
    }
    
    /** 获取  提示信息 */
	public String getMessage() {
		return message;
	}
    
    /** 设置  提示信息 */
	public void setMessage(String message) {
		this.message = message;
	}
    
    
}


//~ Formatted by Jindent --- http://www.jindent.com
