package com.chinayanghe.tpm.cost.vo;

import com.chinayanghe.tpm.cost.utils.StringUtil;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;

/**
 * 区域点上事件 行项目Vo
 * Created by wangfl on 2017/6/15.
 */
public class AreaPointEventVo implements Serializable {
    private static final long serialVersionUID = -1512791144392898449L;
    private Integer id;

    /**
     * 核报单号
     * 表字段 : area_point_event_pay.pay_no
     */
    private String payNo;

    /**
     * 登记单号
     * 表字段 : area_point_event_regist.regist_no
     */
    private String registNo;

    /**
     * 登记单行项目号
     * 表字段 : area_point_event_pay.regist_item_no
     */
    private Integer registItemNo;

    /**
     * 申请单号
     * 表字段 : area_point_event_regist.apply_no
     */
    private String applyNo;

    /**
     * 登记单号项目号
     * 表字段 : area_point_event_regist.item_no
     */
    private Integer itemNo;

    /**
     * 申请单行项目号
     * 表字段 : area_point_event_regist.apply_item_no
     */
    private Integer applyItemNo;

    /**
     * 费用类型编码
     * 表字段 : area_point_event_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : area_point_event_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 推广品牌编码
     * 表字段 : area_point_event_regist.brand_id
     */
    private String brandId;

    /**
     * 推广品牌名称
     * 表字段 : area_point_event_regist.brand_name
     */
    private String brandName;

    /**
     * 开始日期
     * 表字段 : area_point_event_regist.s_date
     */
    private Date sDate;

    /**
     * 结束日期
     * 表字段 : area_point_event_regist.e_date
     */
    private Date eDate;

    /**
     *
     * 表字段 : area_point_event_regist.province_id
     */
    private String provinceId;

    /**
     *
     * 表字段 : area_point_event_regist.province_name
     */
    private String provinceName;

    /**
     *
     * 表字段 : area_point_event_regist.city_id
     */
    private String cityId;

    /**
     *
     * 表字段 : area_point_event_regist.city_name
     */
    private String cityName;

    /**
     *
     * 表字段 : area_point_event_regist.town_id
     */
    private String townId;

    /**
     *
     * 表字段 : area_point_event_regist.town_name
     */
    private String townName;

    /**
     * 具体位置
     * 表字段 : area_point_event_regist.address_detail
     */
    private String addressDetail;

    private String tel;

    /**
     * 活动形式
     * 表字段 : area_point_event_regist.activity_forms
     */
    private String activityForms;

    /**
     * 活动数量
     * 表字段 : area_point_event_regist.buy_num
     */
    private Integer buyNum;

    /**
     * 单位
     * 表字段 : area_point_event_apply.company
     */
    private String company;

    /**
     * 主题
     * 表字段 : area_point_event_regist.theme
     */
    private String theme;

    /**
     * 门票回报(分)
     * 表字段 : area_point_event_regist.ticket_rewards
     */
    private Long ticketRewards;

    /**
     * 宣传回报
     * 表字段 : area_point_event_regist.propaganda_rewards
     */
    private String propagandaRewards;

    /**
     * 参演艺人
     * 表字段 : area_point_event_regist.players
     */
    private String players;

    /**
     * 出席嘉宾
     * 表字段 : area_point_event_regist.guests
     */
    private String guests;

    /**
     * 厂方承担比例
     * 表字段 : area_point_event_apply.company_scale
     */
    private Double companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : area_point_event_regist.company_amount
     */
    private Long companyAmount;

    /**
     * 审核金额(分)
     * 表字段 : area_point_event_apply.audit_amount
     */
    private Long auditAmount;

    /**
     * 实际承担金额(分)
     * 表字段 : area_point_event_regist.rel_amount
     */
    private Long relAmount;

    /**
     * 核报金额(分)
     * 表字段 : area_point_event_pay.pay_amount
     */
    private Long payAmount;

    /**
     * 备注
     * 表字段 : area_point_event_regist.notes
     */
    private String notes;

    /**
     * 行项目余额
     * 表字段 : area_point_event_regist.item_balance
     */
    private Long itemBalance;

    /**
     * 督查意见
     * 表字段 : area_point_event_regist.audit_notes
     */
    private String auditNotes;

    /**
     *
     * 表字段 : area_point_event_regist.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : area_point_event_regist.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : area_point_event_regist.create_date
     */
    private Date createDate;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getRegistNo() {
        return registNo;
    }

    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    public Integer getRegistItemNo() {
        return registItemNo;
    }

    public void setRegistItemNo(Integer registItemNo) {
        this.registItemNo = registItemNo;
    }

    public String getApplyNo() {
        return applyNo;
    }

    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    public Integer getItemNo() {
        return itemNo;
    }

    public void setItemNo(Integer itemNo) {
        this.itemNo = itemNo;
    }

    public Integer getApplyItemNo() {
        return applyItemNo;
    }

    public void setApplyItemNo(Integer applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    public String getCostTypeId() {
        return costTypeId;
    }

    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Date getsDate() {
        return sDate;
    }

    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    public Date geteDate() {
        return eDate;
    }

    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    public String getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityId() {
        return cityId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getTownId() {
        return townId;
    }

    public void setTownId(String townId) {
        this.townId = townId;
    }

    public String getTownName() {
        return townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getAddressDetail() {
        return addressDetail;
    }

    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    public String getActivityForms() {
        return activityForms;
    }

    public void setActivityForms(String activityForms) {
        this.activityForms = activityForms;
    }

    public Integer getBuyNum() {
        return buyNum;
    }

    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTicketRewards() {
        return StringUtil.longPriceParseStr(ticketRewards);
    }

    public void setTicketRewards(Long ticketRewards) {
        this.ticketRewards = ticketRewards;
    }

    public String getPropagandaRewards() {
        return propagandaRewards;
    }

    public void setPropagandaRewards(String propagandaRewards) {
        this.propagandaRewards = propagandaRewards;
    }

    public String getPlayers() {
        return players;
    }

    public void setPlayers(String players) {
        this.players = players;
    }

    public String getGuests() {
        return guests;
    }

    public void setGuests(String guests) {
        this.guests = guests;
    }

    public Double getCompanyScale() {
        return companyScale;
    }

    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    public String getCompanyAmount() {
        return StringUtil.longPriceParseStr(companyAmount);
    }

    public void setCompanyAmount(Long companyAmount) {
        this.companyAmount = companyAmount;
    }

    public String getAuditAmount() {
        return StringUtil.longPriceParseStr(auditAmount);
    }

    public void setAuditAmount(Long auditAmount) {
        this.auditAmount = auditAmount;
    }

    public String getRelAmount() {
        return StringUtil.longPriceParseStr(relAmount);
    }

    public void setRelAmount(Long relAmount) {
        this.relAmount = relAmount;
    }

    public String getPayAmount() {
        return StringUtil.longPriceParseStr(payAmount);
    }

    public void setPayAmount(Long payAmount) {
        this.payAmount = payAmount;
    }

    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getItemBalance() {
        return StringUtil.longPriceParseStr(itemBalance);
    }

    public void setItemBalance(Long itemBalance) {
        this.itemBalance = itemBalance;
    }

    public String getAuditNotes() {
        return auditNotes;
    }

    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }
}
