package com.chinayanghe.tpm.cost.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 劳务登记详情信息
 */
public class ChannelLaborDetailVo implements Serializable {
    private static final long serialVersionUID = 6945313227252526006L;
    /**
     *
     * 表字段 : channel_labor_detail.id
     */
    private Integer id;
    /**
     * 序号
     */
    private Integer uid;

    /**
     * 登记单号
     * 表字段 : channel_labor_detail.regist_no
     */
    private String registNo;

    /**
     * 促销产品编码
     * 表字段 : channel_labor_detail.promotion_user
     */
    private String promotionUser;

    /**
     * 性别
     * 表字段 : channel_labor_detail.sex
     */
    private String sex;

    /**
     * 电话
     * 表字段 : channel_labor_detail.phone
     */
    private String phone;

    /**
     * 促销人员类型
     * 表字段 : channel_labor_detail.promotion_user_type
     */
    private String promotionUserType;

    /**
     * 开始时间
     * 表字段 : channel_labor_detail.begin_time
     */
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Date beginTime;

    /**
     * 结束时间
     * 表字段 : channel_labor_detail.end_time
     */
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Date endTime;

    /**
     * 负责促销点名称
     * 表字段 : channel_labor_detail.promotion_location
     */
    private String promotionLocation;

    /**
     * 终端编码
     * 表字段 : channel_labor_detail.promotion_location_code
     */
    private String promotionLocationCode;

    /**
     * 省名称
     * 表字段 : channel_labor_detail.province
     */
    private String province;

    /**
     * 市名称
     * 表字段 : channel_labor_detail.city
     */
    private String city;

    /**
     * 区县名称
     * 表字段 : channel_labor_detail.county
     */
    private String county;

    /**
     * 详细地址
     * 表字段 : channel_labor_detail.detail_address
     */
    private String detailAddress;

    /**
     * 固定电话
     * 表字段 : channel_labor_detail.tel
     */
    private String tel;

    /**
     * 备注
     * 表字段 : channel_labor_detail.remarks
     */
    private String remarks;
    /**
     * 变更类型
     */
    private String changeType;

    /**
     *
     * 表字段 : channel_labor_detail.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : channel_labor_detail.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : channel_labor_detail.create_date
     */
    private Date createDate;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUid() {
        return uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public String getRegistNo() {
        return registNo;
    }

    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    public String getPromotionUser() {
        return promotionUser;
    }

    public void setPromotionUser(String promotionUser) {
        this.promotionUser = promotionUser;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPromotionUserType() {
        return promotionUserType;
    }

    public void setPromotionUserType(String promotionUserType) {
        this.promotionUserType = promotionUserType;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPromotionLocation() {
        return promotionLocation;
    }

    public void setPromotionLocation(String promotionLocation) {
        this.promotionLocation = promotionLocation;
    }

    public String getPromotionLocationCode() {
        return promotionLocationCode;
    }

    public void setPromotionLocationCode(String promotionLocationCode) {
        this.promotionLocationCode = promotionLocationCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getChangeType() {
        return changeType == null ? "无变动":changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}
