package com.chinayanghe.tpm.cost.vo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 个人品鉴申请Vo
 * Created Jay tp on 2017/5/16.
 */
public class ComSaleProApplyVo {

    /**
     *
     * 表字段 : personal_review_apply.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : personal_review_apply.apply_no
     */
    private String applyNo;

    /**
     * 费用类型编码
     * 表字段 : personal_review_apply.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : personal_review_apply.cost_type_name
     */
    private String costTypeName;

    /**
     * 产品编码
     * 表字段 : personal_review_apply.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : personal_review_apply.product_name
     */
    private String productName;

    /**
     * 已赠饮品种
     * 表字段 : personal_review_apply.product_gift_type
     */
    private String productGiftType;

    /**
     * 已销售品种
     * 表字段 : personal_review_apply.product_sale_type
     */
    private String productSaleType;

    /**
     * 本次赠饮数量
     * 表字段 : personal_review_apply.buy_num
     */
    private Integer buyNum;

    /**
     * 结算价(分)
     * 表字段 : personal_review_apply.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 厂方承担比例
     * 表字段 : personal_review_apply.company_scale
     */
    private Double companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : personal_review_apply.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 审核金额(分)
     * 表字段 : personal_review_apply.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     *
     * 表字段 : personal_review_apply.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : personal_review_apply.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : personal_review_apply.create_date
     */
    private Date createDate;

    /**
     * 行项目余额(分)
     * 表字段 : personal_review_apply.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 行项目号
     * 表字段 : personal_review_apply.item_no
     */
    private Integer itemNo;

    /**
     *
     * 表字段 : personal_review_apply.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : personal_review_apply.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : personal_review_apply.modify_date
     */
    private Date modifyDate;

    /**
     * 获取  字段:personal_review_apply.id
     *
     * @return personal_review_apply.id,
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:personal_review_apply.id
     *
     * @param id the value for personal_review_apply.id,
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:personal_review_apply.apply_no
     *
     * @return personal_review_apply.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:personal_review_apply.apply_no
     *
     * @param applyNo the value for personal_review_apply.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 费用类型编码 字段:personal_review_apply.cost_type_id
     *
     * @return personal_review_apply.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:personal_review_apply.cost_type_id
     *
     * @param costTypeId the value for personal_review_apply.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:personal_review_apply.cost_type_name
     *
     * @return personal_review_apply.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:personal_review_apply.cost_type_name
     *
     * @param costTypeName the value for personal_review_apply.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 产品编码 字段:personal_review_apply.product_id
     *
     * @return personal_review_apply.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:personal_review_apply.product_id
     *
     * @param productId the value for personal_review_apply.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:personal_review_apply.product_name
     *
     * @return personal_review_apply.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:personal_review_apply.product_name
     *
     * @param productName the value for personal_review_apply.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 已赠饮品种 字段:personal_review_apply.product_gift_type
     *
     * @return personal_review_apply.product_gift_type, 已赠饮品种
     */
    public String getProductGiftType() {
        return productGiftType;
    }

    /**
     * 设置 已赠饮品种 字段:personal_review_apply.product_gift_type
     *
     * @param productGiftType the value for personal_review_apply.product_gift_type, 已赠饮品种
     */
    public void setProductGiftType(String productGiftType) {
        this.productGiftType = productGiftType;
    }

    /**
     * 获取 已销售品种 字段:personal_review_apply.product_sale_type
     *
     * @return personal_review_apply.product_sale_type, 已销售品种
     */
    public String getProductSaleType() {
        return productSaleType;
    }

    /**
     * 设置 已销售品种 字段:personal_review_apply.product_sale_type
     *
     * @param productSaleType the value for personal_review_apply.product_sale_type, 已销售品种
     */
    public void setProductSaleType(String productSaleType) {
        this.productSaleType = productSaleType;
    }

    /**
     * 获取 本次赠饮数量 字段:personal_review_apply.buy_num
     *
     * @return personal_review_apply.buy_num, 本次赠饮数量
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 本次赠饮数量 字段:personal_review_apply.buy_num
     *
     * @param buyNum the value for personal_review_apply.buy_num, 本次赠饮数量
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }


    /**
     * 获取 厂方承担比例 字段:personal_review_apply.company_scale
     *
     * @return personal_review_apply.company_scale, 厂方承担比例
     */
    public Double getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置 厂方承担比例 字段:personal_review_apply.company_scale
     *
     * @param companyScale the value for personal_review_apply.company_scale, 厂方承担比例
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }


    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取  字段:personal_review_apply.create_id
     *
     * @return personal_review_apply.create_id,
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:personal_review_apply.create_id
     *
     * @param createId the value for personal_review_apply.create_id,
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:personal_review_apply.create_name
     *
     * @return personal_review_apply.create_name,
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:personal_review_apply.create_name
     *
     * @param createName the value for personal_review_apply.create_name,
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:personal_review_apply.create_date
     *
     * @return personal_review_apply.create_date,
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:personal_review_apply.create_date
     *
     * @param createDate the value for personal_review_apply.create_date,
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取 行项目余额(分) 字段:personal_review_apply.item_balance
     *
     * @return personal_review_apply.item_balance, 行项目余额(分)
     */
    public BigDecimal getItemBalance() {
        if( this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.itemBalance;
    }

    /**
     * 设置 行项目余额(分) 字段:personal_review_apply.item_balance
     *
     * @param itemBalance the value for personal_review_apply.item_balance, 行项目余额(分)
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 行项目号 字段:personal_review_apply.item_no
     *
     * @return personal_review_apply.item_no, 行项目号
     */
    public Integer getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:personal_review_apply.item_no
     *
     * @param itemNo the value for personal_review_apply.item_no, 行项目号
     */
    public void setItemNo(Integer itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取  字段:personal_review_apply.modify_id
     *
     * @return personal_review_apply.modify_id,
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:personal_review_apply.modify_id
     *
     * @param modifyId the value for personal_review_apply.modify_id,
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:personal_review_apply.modify_name
     *
     * @return personal_review_apply.modify_name,
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:personal_review_apply.modify_name
     *
     * @param modifyName the value for personal_review_apply.modify_name,
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:personal_review_apply.modify_date
     *
     * @return personal_review_apply.modify_date,
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:personal_review_apply.modify_date
     *
     * @param modifyDate the value for personal_review_apply.modify_date,
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }


    public BigDecimal getSettlementPrice() {
        if( this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.settlementPrice;
    }

    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    public BigDecimal getCompanyAmount() {
        if( this.companyAmount != null) {
            return (this.companyAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.companyAmount;
    }

    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    public BigDecimal getAuditAmount() {
        if( this.auditAmount != null) {
            return (this.auditAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.auditAmount;
    }

    public ComSaleProApplyVo() {
    }
}
