package com.chinayanghe.tpm.cost.vo;

import com.chinayanghe.tpm.cost.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 全国面上广告 行项目Vo
 * Created by wangfl on 2017/6/21.
 */
public class CountryPlaneAdVo implements Serializable {

    private static final long serialVersionUID = 9199062806604113723L;
    private Integer id;

    /**
     * 登记单号
     * 表字段 : country_plane_ad_pay.pay_no
     */
    private String payNo;

    /**
     * 登记单号
     * 表字段 : country_plane_ad_regist.regist_no
     */
    private String registNo;

    /**
     * 登记单行项目号
     * 表字段 : country_plane_ad_pay.regist_item_no
     */
    private Integer registItemNo;

    /**
     * 申请单号
     * 表字段 : country_plane_ad_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单行项目号
     * 表字段 : country_plane_ad_regist.apply_item_no
     */
    private Integer applyItemNo;

    /**
     * 费用类型编码
     * 表字段 : country_plane_ad_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : country_plane_ad_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 媒体大类
     * 表字段 : country_plane_ad_regist.media_big_code
     */
    private String mediaBigCode;

    /**
     * 媒体大类名称
     * 表字段 : country_plane_ad_regist.media_big_name
     */
    private String mediaBigName;

    /**
     * 媒体小类
     * 表字段 : country_plane_ad_regist.media_small_code
     */
    private String mediaSmallCode;

    /**
     * 媒体小类名称
     * 表字段 : country_plane_ad_regist.media_small_name
     */
    private String mediaSmallName;

    /**
     * 媒体名称
     * 表字段 : country_plane_ad_apply.media_name
     */
    private String mediaName;

    /**
     * 媒体内容
     * 表字段 : country_plane_ad_regist.media_content
     */
    private String mediaContent;

    /**
     * 开始日期
     * 表字段 : country_plane_ad_regist.s_date
     */
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Date sDate;

    /**
     * 结束日期
     * 表字段 : country_plane_ad_regist.e_date
     */
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    private Date eDate;

    /**
     * 推广品牌编码
     * 表字段 : country_plane_ad_regist.brand_id
     */
    private String brandId;

    /**
     * 推广品牌名称
     * 表字段 : country_plane_ad_regist.brand_name
     */
    private String brandName;

    /**
     * 数量
     * 表字段 : country_plane_ad_regist.count
     */
    private Integer count;

    /**
     * 单位
     * 表字段 : country_plane_ad_apply.unit
     */
    private String unit;

    /**
     * 考核大区编码
     * 表字段 : country_plane_ad_apply.large_area_code
     */
    private String largeAreaCode;

    /**
     * 考核大区
     * 表字段 : country_plane_ad_apply.large_area
     */
    private String largeArea;

    /**
     * 考核比例
     * 表字段 : country_plane_ad_apply.assessment_prop
     */
    private Double assessmentProp;

    /**
     * 考核金额(分)
     * 表字段 : country_plane_ad_apply.assessment_amount
     */
    private Long assessmentAmount;

    /**
     * 活动金额(分)
     * 表字段 : country_plane_ad_apply.activity_amount
     */
    private Long activityAmount;

    /**
     * 实施方
     * 表字段 : country_plane_ad_regist.implementing_party
     */
    private String implementingParty;

    /**
     * 联系人
     * 表字段 : country_plane_ad_regist.contacts
     */
    private String contacts;

    /**
     * 联系方式
     * 表字段 : country_plane_ad_regist.contact_way
     */
    private String contactWay;

    /**
     * 活动形式
     * 表字段 : country_plane_ad_regist.activity_forms
     */
    private String activityForms;

    /**
     * 厂方承担金额(分)
     * 表字段 : country_plane_ad_regist.company_amount
     */
    private Long companyAmount;

    /**
     * 审核金额(分)
     * 表字段 : country_plane_ad_apply.audit_amount
     */
    private Long auditAmount;

    /**
     * 核报金额(分)
     * 表字段 : country_plane_ad_pay.pay_amount
     */
    private Long payAmount;

    /**
     * 备注
     * 表字段 : country_plane_ad_regist.notes
     */
    private String notes;

    /**
     * 行项目余额
     * 表字段 : country_plane_ad_regist.item_balance
     */
    private Long itemBalance;

    /**
     * 督查意见
     * 表字段 : country_plane_ad_regist.audit_notes
     */
    private String auditNotes;

    /**
     *
     * 表字段 : country_plane_ad_regist.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : country_plane_ad_regist.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : country_plane_ad_regist.create_date
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Date createDate;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getRegistNo() {
        return registNo;
    }

    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    public Integer getRegistItemNo() {
        return registItemNo;
    }

    public void setRegistItemNo(Integer registItemNo) {
        this.registItemNo = registItemNo;
    }

    public String getApplyNo() {
        return applyNo;
    }

    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    public Integer getApplyItemNo() {
        return applyItemNo;
    }

    public void setApplyItemNo(Integer applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    public String getCostTypeId() {
        return costTypeId;
    }

    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    public String getMediaBigCode() {
        return mediaBigCode;
    }

    public void setMediaBigCode(String mediaBigCode) {
        this.mediaBigCode = mediaBigCode;
    }

    public String getMediaBigName() {
        return mediaBigName;
    }

    public void setMediaBigName(String mediaBigName) {
        this.mediaBigName = mediaBigName;
    }

    public String getMediaSmallCode() {
        return mediaSmallCode;
    }

    public void setMediaSmallCode(String mediaSmallCode) {
        this.mediaSmallCode = mediaSmallCode;
    }

    public String getMediaSmallName() {
        return mediaSmallName;
    }

    public void setMediaSmallName(String mediaSmallName) {
        this.mediaSmallName = mediaSmallName;
    }

    public String getMediaName() {
        return mediaName;
    }

    public void setMediaName(String mediaName) {
        this.mediaName = mediaName;
    }

    public String getMediaContent() {
        return mediaContent;
    }

    public void setMediaContent(String mediaContent) {
        this.mediaContent = mediaContent;
    }

    public Date getsDate() {
        return sDate;
    }

    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    public Date geteDate() {
        return eDate;
    }

    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getLargeAreaCode() {
        return largeAreaCode;
    }

    public void setLargeAreaCode(String largeAreaCode) {
        this.largeAreaCode = largeAreaCode;
    }

    public String getLargeArea() {
        return largeArea;
    }

    public void setLargeArea(String largeArea) {
        this.largeArea = largeArea;
    }

    public Double getAssessmentProp() {
        return assessmentProp;
    }

    public void setAssessmentProp(Double assessmentProp) {
        this.assessmentProp = assessmentProp;
    }

    public String getAssessmentAmount() {
        return StringUtil.longPriceParseStr(assessmentAmount);
    }

    public void setAssessmentAmount(Long assessmentAmount) {
        this.assessmentAmount = assessmentAmount;
    }

    public String getActivityAmount() {
        return StringUtil.longPriceParseStr(activityAmount);
    }

    public void setActivityAmount(Long activityAmount) {
        this.activityAmount = activityAmount;
    }

    public String getImplementingParty() {
        return implementingParty;
    }

    public void setImplementingParty(String implementingParty) {
        this.implementingParty = implementingParty;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getContactWay() {
        return contactWay;
    }

    public void setContactWay(String contactWay) {
        this.contactWay = contactWay;
    }

    public String getActivityForms() {
        return activityForms;
    }

    public void setActivityForms(String activityForms) {
        this.activityForms = activityForms;
    }

    public String getCompanyAmount() {
        return StringUtil.longPriceParseStr(companyAmount);
    }

    public void setCompanyAmount(Long companyAmount) {
        this.companyAmount = companyAmount;
    }

    public String getAuditAmount() {
        return StringUtil.longPriceParseStr(auditAmount);
    }

    public void setAuditAmount(Long auditAmount) {
        this.auditAmount = auditAmount;
    }

    public String getPayAmount() {
        return StringUtil.longPriceParseStr(payAmount);
    }

    public void setPayAmount(Long payAmount) {
        this.payAmount = payAmount;
    }

    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getItemBalance() {
        return StringUtil.longPriceParseStr(itemBalance);
    }

    public void setItemBalance(Long itemBalance) {
        this.itemBalance = itemBalance;
    }

    public String getAuditNotes() {
        return auditNotes;
    }

    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}
