package com.chinayanghe.tpm.cost.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 消费者宴会申请
 * CustomerFeastApplyDto
 * 数据库表：customer_feast_apply
 */
public class CustomerFeastApplyVo implements Serializable {

    /**
     * 
     * 表字段 : customer_feast_apply.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : customer_feast_apply.apply_no
     */
    private String applyNo;
    private String itemNo;
    
    /**
     * 行项目余额
     * 表字段 : customer_feast_regist.item_balance_amount
     */
    private BigDecimal itemBalance;
    /**
     * 费用类型编码
     * 表字段 : customer_feast_apply.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : customer_feast_apply.cost_type_name
     */
    private String costTypeName;

    /**
     * 受赠客户
     * 表字段 : customer_feast_apply.donee
     */
    private String donee;

    /**
     * 产品编码
     * 表字段 : customer_feast_apply.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : customer_feast_apply.product_name
     */
    private String productName;

    /**
     * 结算价(元)
     * 表字段 : customer_feast_apply.product_price
     */
    private BigDecimal productPrice;

    /**
     * 活动售价(元)
     * 表字段 : customer_feast_apply.activity_price
     */
    private BigDecimal activityPrice;

    /**
     * 活动桌数
     * 表字段 : customer_feast_apply.activity_table_num
     */
    private Integer activityTableNum;

    /**
     * 购买瓶数
     * 表字段 : customer_feast_apply.buy_num
     */
    private Integer buyNum;

    /**
     * 赠酒情况
     * 表字段 : customer_feast_apply.gift_wine_notes
     */
    private String giftWineNotes;

    /**
     * 
     * 表字段 : customer_feast_apply.gift_notes
     */
    private String giftNotes;

    /**
     * 预计产生费用
     * 表字段 : customer_feast_apply.expect_cost
     */
    private BigDecimal expectCost;

    /**
     * 厂方承担比例
     * 表字段 : customer_feast_apply.compay_scale
     */
    private Double compayScale;

    /**
     * 厂方承担金额
     * 表字段 : customer_feast_apply.compay_amount
     */
    private BigDecimal compayAmount;

    /**
     * 审核金额(元)
     * 表字段 : customer_feast_apply.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     * 状态
     * 表字段 : customer_feast_apply.status
     */
    private String status;

    /**
     * 
     * 表字段 : customer_feast_apply.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : customer_feast_apply.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : customer_feast_apply.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : customer_feast_apply.modify_date
     */
    private Date modifyDate;


    /**
     *
     * 表字段 : customer_feast_apply.id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     *
     * 表字段 : customer_feast_apply.id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 申请单号
     * 表字段 : customer_feast_apply.apply_no
     */
    public String getApplyNo() {
        return this.applyNo;
    }

    /**
     * 申请单号
     * 表字段 : customer_feast_apply.apply_no
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 费用类型编码
     * 表字段 : customer_feast_apply.cost_type_id
     */
    public String getCostTypeId() {
        return this.costTypeId;
    }

    /**
     * 费用类型编码
     * 表字段 : customer_feast_apply.cost_type_id
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 费用类型名称
     * 表字段 : customer_feast_apply.cost_type_name
     */
    public String getCostTypeName() {
        return this.costTypeName;
    }

    /**
     * 费用类型名称
     * 表字段 : customer_feast_apply.cost_type_name
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 受赠客户
     * 表字段 : customer_feast_apply.donee
     */
    public String getDonee() {
        return this.donee;
    }

    /**
     * 受赠客户
     * 表字段 : customer_feast_apply.donee
     */
    public void setDonee(String donee) {
        this.donee = donee;
    }

    /**
     * 产品编码
     * 表字段 : customer_feast_apply.product_id
     */
    public String getProductId() {
        return this.productId;
    }

    /**
     * 产品编码
     * 表字段 : customer_feast_apply.product_id
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 产品名称
     * 表字段 : customer_feast_apply.product_name
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 产品名称
     * 表字段 : customer_feast_apply.product_name
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 结算价(元)
     * 表字段 : customer_feast_apply.product_price
     */
    public BigDecimal getProductPrice() {
        if( this.productPrice != null) {
            return (this.productPrice.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
        }
        return this.productPrice;
    }

    /**
     * 结算价(元)
     * 表字段 : customer_feast_apply.product_price
     */
    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * 活动售价(元)
     * 表字段 : customer_feast_apply.activity_price
     */
    public BigDecimal getActivityPrice() {
        if( this.activityPrice != null) {
            return (this.activityPrice.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
        }
        return this.activityPrice;
    }

    /**
     * 活动售价(元)
     * 表字段 : customer_feast_apply.activity_price
     */
    public void setActivityPrice(BigDecimal activityPrice) {
        this.activityPrice = activityPrice;
    }

    /**
     * 活动桌数
     * 表字段 : customer_feast_apply.activity_table_num
     */
    public Integer getActivityTableNum() {
        return this.activityTableNum;
    }

    /**
     * 活动桌数
     * 表字段 : customer_feast_apply.activity_table_num
     */
    public void setActivityTableNum(Integer activityTableNum) {
        this.activityTableNum = activityTableNum;
    }

    /**
     * 购买瓶数
     * 表字段 : customer_feast_apply.buy_num
     */
    public Integer getBuyNum() {
        return this.buyNum;
    }

    /**
     * 购买瓶数
     * 表字段 : customer_feast_apply.buy_num
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 赠酒情况
     * 表字段 : customer_feast_apply.gift_wine_notes
     */
    public String getGiftWineNotes() {
        return this.giftWineNotes;
    }

    /**
     * 赠酒情况
     * 表字段 : customer_feast_apply.gift_wine_notes
     */
    public void setGiftWineNotes(String giftWineNotes) {
        this.giftWineNotes = giftWineNotes;
    }

    /**
     *
     * 表字段 : customer_feast_apply.gift_notes
     */
    public String getGiftNotes() {
        return this.giftNotes;
    }

    /**
     *
     * 表字段 : customer_feast_apply.gift_notes
     */
    public void setGiftNotes(String giftNotes) {
        this.giftNotes = giftNotes;
    }

    /**
     * 预计产生费用
     * 表字段 : customer_feast_apply.expect_cost
     */
    public BigDecimal getExpectCost() {
        if( this.expectCost != null) {
            return (this.expectCost.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
        }
        return this.expectCost;
    }

    /**
     * 预计产生费用
     * 表字段 : customer_feast_apply.expect_cost
     */
    public void setExpectCost(BigDecimal expectCost) {
        this.expectCost = expectCost;
    }

    /**
     * 厂方承担比例
     * 表字段 : customer_feast_apply.compay_scale
     */
    public Double getCompayScale() {
        return this.compayScale;
    }

    /**
     * 厂方承担比例
     * 表字段 : customer_feast_apply.compay_scale
     */
    public void setCompayScale(Double compayScale) {
        this.compayScale = compayScale;
    }

    /**
     * 厂方承担金额
     * 表字段 : customer_feast_apply.compay_amount
     */
    public BigDecimal getCompayAmount() {
        if( this.compayAmount != null) {
            return (this.compayAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.compayAmount;
    }

    /**
     * 厂方承担金额
     * 表字段 : customer_feast_apply.compay_amount
     */
    public void setCompayAmount(BigDecimal compayAmount) {
        this.compayAmount = compayAmount;
    }

    /**
     * 审核金额(元)
     * 表字段 : customer_feast_apply.audit_amount
     */
    public BigDecimal getAuditAmount() {
        if( this.auditAmount != null) {
            return (this.auditAmount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
        }
        return this.auditAmount;
    }

    /**
     * 审核金额(元)
     * 表字段 : customer_feast_apply.audit_amount
     */
    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 状态
     * 表字段 : customer_feast_apply.status
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 状态
     * 表字段 : customer_feast_apply.status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_id
     */
    public String getCreateId() {
        return this.createId;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_id
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_name
     */
    public String getCreateName() {
        return this.createName;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_name
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_date
     */
    public Date getCreateDate() {
        return this.createDate;
    }

    /**
     *
     * 表字段 : customer_feast_apply.create_date
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_id
     */
    public String getModifyId() {
        return this.modifyId;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_id
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_name
     */
    public String getModifyName() {
        return this.modifyName;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_name
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_date
     */
    public Date getModifyDate() {
        return this.modifyDate;
    }

    /**
     *
     * 表字段 : customer_feast_apply.modify_date
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

	public String getItemNo() {
		return itemNo;
	}

	public void setItemNo(String itemNo) {
		this.itemNo = itemNo;
	}

	public BigDecimal getItemBalance() {
		if( this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
        }
        return this.itemBalance;
	}

	public void setItemBalance(BigDecimal itemBalance) {
		this.itemBalance = itemBalance;
	}
    
    
}