package com.chinayanghe.tpm.cost.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 个性化奖卡延期申请
 * PersonalAwardDelayApplyDto
 * 数据库表：personal_award_delay_apply
 */
public class PersonalAwardDelayApplyVo implements Serializable {

    /**
     * 
     * 表字段 : personal_award_delay_apply.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : personal_award_delay_apply.apply_no
     */
    private String applyNo;

    /**
     * 行项目号
     * 表字段 : personal_award_delay_apply.item_no
     */
    private String itemNo;

    /**
     * 产品编码
     * 表字段 : personal_award_delay_apply.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : personal_award_delay_apply.product_name
     */
    private String productName;

    /**
     * 合计金额（分）
     * 表字段 : personal_award_delay_apply.amount
     */
    private BigDecimal amount;

    /**
     * 奖卡数量
     * 表字段 : personal_award_delay_apply.num
     */
    private Integer num;

    /**
     * 原奖卡活动起始时间
     * 表字段 : personal_award_delay_apply.award_start_date
     */
    private Date awardStartDate;

    /**
     * 原报账截止时间
     * 表字段 : personal_award_delay_apply.account_end_date
     */
    private Date accountEndDate;

    /**
     * 延期报账时间
     * 表字段 : personal_award_delay_apply.delay_account_date
     */
    private Date delayAccountDate;

    /**
     * 
     * 表字段 : personal_award_delay_apply.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : personal_award_delay_apply.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : personal_award_delay_apply.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : personal_award_delay_apply.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : personal_award_delay_apply.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : personal_award_delay_apply.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table personal_award_delay_apply
     *
     * @mbggenerated Sun Jun 18 18:00:39 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:personal_award_delay_apply.id
     *
     * @return personal_award_delay_apply.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:personal_award_delay_apply.id
     *
     * @param id the value for personal_award_delay_apply.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:personal_award_delay_apply.apply_no
     *
     * @return personal_award_delay_apply.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:personal_award_delay_apply.apply_no
     *
     * @param applyNo the value for personal_award_delay_apply.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 行项目号 字段:personal_award_delay_apply.item_no
     *
     * @return personal_award_delay_apply.item_no, 行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:personal_award_delay_apply.item_no
     *
     * @param itemNo the value for personal_award_delay_apply.item_no, 行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 产品编码 字段:personal_award_delay_apply.product_id
     *
     * @return personal_award_delay_apply.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:personal_award_delay_apply.product_id
     *
     * @param productId the value for personal_award_delay_apply.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:personal_award_delay_apply.product_name
     *
     * @return personal_award_delay_apply.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:personal_award_delay_apply.product_name
     *
     * @param productName the value for personal_award_delay_apply.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 合计金额（分） 字段:personal_award_delay_apply.amount
     *
     * @return personal_award_delay_apply.amount, 合计金额（分）
     */
    public BigDecimal getAmount() {
    	if( this.amount != null) {
	          return (this.amount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.amount;
    }

    /**
     * 设置 合计金额（分） 字段:personal_award_delay_apply.amount
     *
     * @param amount the value for personal_award_delay_apply.amount, 合计金额（分）
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * 获取 奖卡数量 字段:personal_award_delay_apply.num
     *
     * @return personal_award_delay_apply.num, 奖卡数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 设置 奖卡数量 字段:personal_award_delay_apply.num
     *
     * @param num the value for personal_award_delay_apply.num, 奖卡数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }

    /**
     * 获取 原奖卡活动起始时间 字段:personal_award_delay_apply.award_start_date
     *
     * @return personal_award_delay_apply.award_start_date, 原奖卡活动起始时间
     */
    public Date getAwardStartDate() {
        return awardStartDate;
    }

    /**
     * 设置 原奖卡活动起始时间 字段:personal_award_delay_apply.award_start_date
     *
     * @param awardStartDate the value for personal_award_delay_apply.award_start_date, 原奖卡活动起始时间
     */
    public void setAwardStartDate(Date awardStartDate) {
        this.awardStartDate = awardStartDate;
    }

    /**
     * 获取 原报账截止时间 字段:personal_award_delay_apply.account_end_date
     *
     * @return personal_award_delay_apply.account_end_date, 原报账截止时间
     */
    public Date getAccountEndDate() {
        return accountEndDate;
    }

    /**
     * 设置 原报账截止时间 字段:personal_award_delay_apply.account_end_date
     *
     * @param accountEndDate the value for personal_award_delay_apply.account_end_date, 原报账截止时间
     */
    public void setAccountEndDate(Date accountEndDate) {
        this.accountEndDate = accountEndDate;
    }

    /**
     * 获取 延期报账时间 字段:personal_award_delay_apply.delay_account_date
     *
     * @return personal_award_delay_apply.delay_account_date, 延期报账时间
     */
    public Date getDelayAccountDate() {
        return delayAccountDate;
    }

    /**
     * 设置 延期报账时间 字段:personal_award_delay_apply.delay_account_date
     *
     * @param delayAccountDate the value for personal_award_delay_apply.delay_account_date, 延期报账时间
     */
    public void setDelayAccountDate(Date delayAccountDate) {
        this.delayAccountDate = delayAccountDate;
    }

    /**
     * 获取  字段:personal_award_delay_apply.create_id
     *
     * @return personal_award_delay_apply.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:personal_award_delay_apply.create_id
     *
     * @param createId the value for personal_award_delay_apply.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:personal_award_delay_apply.create_name
     *
     * @return personal_award_delay_apply.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:personal_award_delay_apply.create_name
     *
     * @param createName the value for personal_award_delay_apply.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:personal_award_delay_apply.create_date
     *
     * @return personal_award_delay_apply.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:personal_award_delay_apply.create_date
     *
     * @param createDate the value for personal_award_delay_apply.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:personal_award_delay_apply.modify_id
     *
     * @return personal_award_delay_apply.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:personal_award_delay_apply.modify_id
     *
     * @param modifyId the value for personal_award_delay_apply.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:personal_award_delay_apply.modify_name
     *
     * @return personal_award_delay_apply.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:personal_award_delay_apply.modify_name
     *
     * @param modifyName the value for personal_award_delay_apply.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:personal_award_delay_apply.modify_date
     *
     * @return personal_award_delay_apply.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:personal_award_delay_apply.modify_date
     *
     * @param modifyDate the value for personal_award_delay_apply.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}