package com.chinayanghe.tpm.cost.vo;

import java.io.Serializable;

import java.text.DecimalFormat;

import java.util.Date;

/**
 * 个性化促销 详细申请VO
 */
public class PersonalizedDetailsVo implements Serializable {
    private static final long serialVersionUID = 3134544935395838258L;
    private int               id;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 促销产品编码
     */
    private String productPromotionId;

    /**
     * 促销产品名称
     */
    private String productPromotionName;

    /**
     * 数量
     */
    private int buyNum;

    /**
     * 产品单价(分)
     */
    private int productPrice;

    /**
     * 申请金额(分)
     */
    private int applyAmount;

    /**
     * 经销商1名称
     */
    private String dealer1Name;

    /**
     * 经销商1电话
     */
    private String dealer1Tel;

    /**
     * 经销商1产品单价
     */
    private int dealer1Price;

    /**
     * 经销商2名称
     */
    private String dealer2Name;

    /**
     * 经销商2电话
     */
    private String dealer2Tel;

    /**
     * 经销商2产品单价(分)
     */
    private int dealer2Price;

    /**
     * 经销商3名称
     */
    private String dealer3Name;

    /**
     * 经销商3电话
     */
    private String dealer3Tel;

    /**
     * 经销商3产品单价(分)
     */
    private int dealer3Price;

    /**
     * 审核单价(分)
     */
    private int auditPrice;

    /**
     * 审核金额(分)
     */
    private int auditAmount;

    private String intParseStr(int price) {
        return new DecimalFormat("#.##").format(price / 100.0);
    }

    public String getApplyAmount() {
        return intParseStr(applyAmount);
    }

    public void setApplyAmount(int applyAmount) {
        this.applyAmount = applyAmount;
    }

    public String getApplyNo() {
        return applyNo;
    }

    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    public int getAuditAmount() {
        return auditAmount;
    }

    public void setAuditAmount(int auditAmount) {
        this.auditAmount = auditAmount;
    }

    public int getAuditPrice() {
        return auditPrice;
    }

    public void setAuditPrice(int auditPrice) {
        this.auditPrice = auditPrice;
    }

    public int getBuyNum() {
        return buyNum;
    }

    public void setBuyNum(int buyNum) {
        this.buyNum = buyNum;
    }

    public String getDealer1Name() {
        return dealer1Name;
    }

    public void setDealer1Name(String dealer1Name) {
        this.dealer1Name = dealer1Name;
    }

    public String getDealer1Price() {
        return intParseStr(this.dealer1Price);
    }

    public void setDealer1Price(int dealer1Price) {
        this.dealer1Price = dealer1Price;
    }

    public String getDealer1Tel() {
        return dealer1Tel;
    }

    public void setDealer1Tel(String dealer1Tel) {
        this.dealer1Tel = dealer1Tel;
    }

    public String getDealer2Name() {
        return dealer2Name;
    }

    public void setDealer2Name(String dealer2Name) {
        this.dealer2Name = dealer2Name;
    }

    public String getDealer2Price() {
        return intParseStr(this.dealer2Price);
    }

    public void setDealer2Price(int dealer2Price) {
        this.dealer2Price = dealer2Price;
    }

    public String getDealer2Tel() {
        return dealer2Tel;
    }

    public void setDealer2Tel(String dealer2Tel) {
        this.dealer2Tel = dealer2Tel;
    }

    public String getDealer3Name() {
        return dealer3Name;
    }

    public void setDealer3Name(String dealer3Name) {
        this.dealer3Name = dealer3Name;
    }

    public String getDealer3Price() {
        return intParseStr(this.dealer3Price);
    }

    public void setDealer3Price(int dealer3Price) {
        this.dealer3Price = dealer3Price;
    }

    public String getDealer3Tel() {
        return dealer3Tel;
    }

    public void setDealer3Tel(String dealer3Tel) {
        this.dealer3Tel = dealer3Tel;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getProductPrice() {
        return intParseStr(this.productPrice);
    }

    public void setProductPrice(int productPrice) {
        this.productPrice = productPrice;
    }

    public String getProductPromotionId() {
        return productPromotionId;
    }

    public void setProductPromotionId(String productPromotionId) {
        this.productPromotionId = productPromotionId;
    }

    public String getProductPromotionName() {
        return productPromotionName;
    }

    public void setProductPromotionName(String productPromotionName) {
        this.productPromotionName = productPromotionName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
