package com.chinayanghe.tpm.cost.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销信息
 * PromotionInfoDto
 * 数据库表：promotion_info
 */
public class    PromotionInfoVo implements Serializable {

    /**
     * 
     * 表字段 : promotion_info.id
     */
    private Integer id;

    /**
     * 
     * 表字段 : promotion_info.form_type
     */
    private String formType;

    /**
     * 
     * 表字段 : promotion_info.form_no
     */
    private String formNo;

    /**
     * 采购网点
     * 表字段 : promotion_info.seller
     */
    private String seller;

    /**
     * 具体位置
     * 表字段 : promotion_info.seller_address
     */
    private String sellerAddress;

    /**
     * 负责人
     * 表字段 : promotion_info.respon_person
     */
    private String responPerson;

    /**
     * 负责人电话
     * 表字段 : promotion_info.respon_tel
     */
    private String responTel;

    /**
     * 采购物品名称
     * 表字段 : promotion_info.buy_product_name
     */
    private String buyProductName;

    /**
     * 数量
     * 表字段 : promotion_info.product_num
     */
    private Integer productNum;

    /**
     * 单位
     * 表字段 : promotion_info.unit
     */
    private String unit;

    /**
     * 价格(分)
     * 表字段 : promotion_info.product_price
     */
    private BigDecimal productPrice;

    /**
     * 型号
     * 表字段 : promotion_info.model
     */
    private String model;

    /**
     * 金额
     * 表字段 : promotion_info.amount
     */
    private BigDecimal amount;

    /**
     * 备注
     * 表字段 : promotion_info.notes
     */
    private String notes;

    /**
     * 
     * 表字段 : promotion_info.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : promotion_info.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : promotion_info.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : promotion_info.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : promotion_info.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : promotion_info.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table promotion_info
     *
     * @mbggenerated Fri May 12 15:46:40 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:promotion_info.id
     *
     * @return promotion_info.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:promotion_info.id
     *
     * @param id the value for promotion_info.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取  字段:promotion_info.form_type
     *
     * @return promotion_info.form_type, 
     */
    public String getFormType() {
        return formType;
    }

    /**
     * 设置  字段:promotion_info.form_type
     *
     * @param formType the value for promotion_info.form_type, 
     */
    public void setFormType(String formType) {
        this.formType = formType;
    }

    /**
     * 获取  字段:promotion_info.form_no
     *
     * @return promotion_info.form_no, 
     */
    public String getFormNo() {
        return formNo;
    }

    /**
     * 设置  字段:promotion_info.form_no
     *
     * @param formNo the value for promotion_info.form_no, 
     */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /**
     * 获取 采购网点 字段:promotion_info.seller
     *
     * @return promotion_info.seller, 采购网点
     */
    public String getSeller() {
        return seller;
    }

    /**
     * 设置 采购网点 字段:promotion_info.seller
     *
     * @param seller the value for promotion_info.seller, 采购网点
     */
    public void setSeller(String seller) {
        this.seller = seller;
    }

    /**
     * 获取 具体位置 字段:promotion_info.seller_address
     *
     * @return promotion_info.seller_address, 具体位置
     */
    public String getSellerAddress() {
        return sellerAddress;
    }

    /**
     * 设置 具体位置 字段:promotion_info.seller_address
     *
     * @param sellerAddress the value for promotion_info.seller_address, 具体位置
     */
    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    /**
     * 获取 负责人 字段:promotion_info.respon_person
     *
     * @return promotion_info.respon_person, 负责人
     */
    public String getResponPerson() {
        return responPerson;
    }

    /**
     * 设置 负责人 字段:promotion_info.respon_person
     *
     * @param responPerson the value for promotion_info.respon_person, 负责人
     */
    public void setResponPerson(String responPerson) {
        this.responPerson = responPerson;
    }

    /**
     * 获取 负责人电话 字段:promotion_info.respon_tel
     *
     * @return promotion_info.respon_tel, 负责人电话
     */
    public String getResponTel() {
        return responTel;
    }

    /**
     * 设置 负责人电话 字段:promotion_info.respon_tel
     *
     * @param responTel the value for promotion_info.respon_tel, 负责人电话
     */
    public void setResponTel(String responTel) {
        this.responTel = responTel;
    }

    /**
     * 获取 采购物品名称 字段:promotion_info.buy_product_name
     *
     * @return promotion_info.buy_product_name, 采购物品名称
     */
    public String getBuyProductName() {
        return buyProductName;
    }

    /**
     * 设置 采购物品名称 字段:promotion_info.buy_product_name
     *
     * @param buyProductName the value for promotion_info.buy_product_name, 采购物品名称
     */
    public void setBuyProductName(String buyProductName) {
        this.buyProductName = buyProductName;
    }

    /**
     * 获取 数量 字段:promotion_info.product_num
     *
     * @return promotion_info.product_num, 数量
     */
    public Integer getProductNum() {
        return productNum;
    }

    /**
     * 设置 数量 字段:promotion_info.product_num
     *
     * @param productNum the value for promotion_info.product_num, 数量
     */
    public void setProductNum(Integer productNum) {
        this.productNum = productNum;
    }

    /**
     * 获取 单位 字段:promotion_info.unit
     *
     * @return promotion_info.unit, 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 设置 单位 字段:promotion_info.unit
     *
     * @param unit the value for promotion_info.unit, 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 获取 价格(分) 字段:promotion_info.product_price
     *
     * @return promotion_info.product_price, 价格(分)
     */
    public BigDecimal getProductPrice() {
    	if( this.productPrice != null) {
            return (this.productPrice.divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_UP));
        }
        return this.productPrice;
    }

    /**
     * 设置 价格(分) 字段:promotion_info.product_price
     *
     * @param productPrice the value for promotion_info.product_price, 价格(分)
     */
    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * 获取 型号 字段:promotion_info.model
     *
     * @return promotion_info.model, 型号
     */
    public String getModel() {
        return model;
    }

    /**
     * 设置 型号 字段:promotion_info.model
     *
     * @param model the value for promotion_info.model, 型号
     */
    public void setModel(String model) {
        this.model = model;
    }

    /**
     * 获取 金额 字段:promotion_info.amount
     *
     * @return promotion_info.amount, 金额
     */
    public BigDecimal getAmount() {
    	if( this.amount != null) {
            return (this.amount.divide(new BigDecimal(100),2,BigDecimal.ROUND_HALF_UP));
        }
        return this.amount;
    }

    /**
     * 设置 金额 字段:promotion_info.amount
     *
     * @param amount the value for promotion_info.amount, 金额
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * 获取 备注 字段:promotion_info.notes
     *
     * @return promotion_info.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:promotion_info.notes
     *
     * @param notes the value for promotion_info.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取  字段:promotion_info.create_id
     *
     * @return promotion_info.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:promotion_info.create_id
     *
     * @param createId the value for promotion_info.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:promotion_info.create_name
     *
     * @return promotion_info.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:promotion_info.create_name
     *
     * @param createName the value for promotion_info.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:promotion_info.create_date
     *
     * @return promotion_info.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:promotion_info.create_date
     *
     * @param createDate the value for promotion_info.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:promotion_info.modify_id
     *
     * @return promotion_info.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:promotion_info.modify_id
     *
     * @param modifyId the value for promotion_info.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:promotion_info.modify_name
     *
     * @return promotion_info.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:promotion_info.modify_name
     *
     * @param modifyName the value for promotion_info.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:promotion_info.modify_date
     *
     * @return promotion_info.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:promotion_info.modify_date
     *
     * @param modifyDate the value for promotion_info.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}