package com.chinayanghe.tpm.cost.vo;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 达标奖励
 * WelldoneRewardApplyDto
 * 数据库表：welldone_reward_apply
 */
public class WelldoneRewardApplyVo implements Serializable {

    /**
     * 
     * 表字段 : welldone_reward_apply.id
     */
    private Integer id;

    /**
     * 
     * 表字段 : welldone_reward_apply.apply_no
     */
    private String applyNo;

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    private String itemNo;

    /**
     * 费用类型编码
     */
    private String costTypeCode;

    /**
     * 费用类型名称
     */
    private String costTypeName;

    /**
     * 终端编码
     * 表字段 : welldone_reward_apply.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : welldone_reward_apply.terminal_name
     */
    private String terminalName;

    /**
     * 省编码
     * 表字段 : welldone_reward_apply.province_id
     */
    private String provinceId;

    /**
     * 省名称
     * 表字段 : welldone_reward_apply.province_name
     */
    private String provinceName;

    /**
     * 市编码
     * 表字段 : welldone_reward_apply.city_id
     */
    private String cityId;

    /**
     * 市名称
     * 表字段 : welldone_reward_apply.city_name
     */
    private String cityName;

    /**
     * 区县编码
     * 表字段 : welldone_reward_apply.county_id
     */
    private String countyId;

    /**
     * 区县名称
     * 表字段 : welldone_reward_apply.county_name
     */
    private String countyName;

    /**
     * 详细地址
     * 表字段 : welldone_reward_apply.detail_address
     */
    private String detailAddress;

    /**
     * 终端联系人
     * 表字段 : welldone_reward_apply.terminal_contact
     */
    private String terminalContact;

    /**
     * 
     * 表字段 : welldone_reward_apply.tel
     */
    private String tel;

    /**
     * 费用期间-开始日期
费用期间-开始日期
费用期间-开始日期
费用期间-开始日期
费用期间开始时间
     * 表字段 : welldone_reward_apply.s_date
     */
    private Date sDate;

    /**
     * 费用期间-结束日期
     * 表字段 : welldone_reward_apply.e_date
     */
    private Date eDate;

    /**
     * 产品编码
     * 表字段 : welldone_reward_apply.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : welldone_reward_apply.product_name
     */
    private String productName;

    /**
     * 供货价(分)
     * 表字段 : welldone_reward_apply.supply_price
     */
    private BigDecimal supplyPrice;

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_apply.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 保量力度
     * 表字段 : welldone_reward_apply.limit_quantity_scale
     */
    private Double limitQuantityScale;

    /**
     * 单瓶保量力度(分)
     * 表字段 : welldone_reward_apply.limit_quantity_amount
     */
    private BigDecimal limitQuantityAmount;

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_apply.limit_company_rebate
     */
    private BigDecimal limitCompanyRebate;

    /**
     * 保量瓶数
     * 表字段 : welldone_reward_apply.buy_num
     */
    private Integer buyNum;

    /**
     * 销售金额(分)
     * 表字段 : welldone_reward_apply.total_amount
     */
    private BigDecimal totalAmount;

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_apply.company_scale
     */
    private Double companyScale;

    /**
     * 申请金额(分)
     * 表字段 : welldone_reward_apply.apply_amount
     */
    private BigDecimal applyAmount;

    /**
     * 审核金额(分)
     * 表字段 : welldone_reward_apply.audit_mount
     */
    private BigDecimal auditMount;

    /**
     * 行项目余额
     * 表字段 : welldone_reward_apply.item_balance
     */
    private Integer itemBalance;

    /**
     * 
     * 表字段 : welldone_reward_apply.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : welldone_reward_apply.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : welldone_reward_apply.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : welldone_reward_apply.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : welldone_reward_apply.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : welldone_reward_apply.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table welldone_reward_apply
     *
     * @mbggenerated Fri May 12 15:46:41 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     * 表字段 : welldone_reward_apply.id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.apply_no
     */
    public String getApplyNo() {
        return this.applyNo;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.apply_no
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    public String getItemNo() {
        return this.itemNo;
    }

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 终端编码
     * 表字段 : welldone_reward_apply.terminal_id
     */
    public String getTerminalId() {
        return this.terminalId;
    }

    /**
     * 终端编码
     * 表字段 : welldone_reward_apply.terminal_id
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 终端名称
     * 表字段 : welldone_reward_apply.terminal_name
     */
    public String getTerminalName() {
        return this.terminalName;
    }

    /**
     * 终端名称
     * 表字段 : welldone_reward_apply.terminal_name
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 省编码
     * 表字段 : welldone_reward_apply.province_id
     */
    public String getProvinceId() {
        return this.provinceId;
    }

    /**
     * 省编码
     * 表字段 : welldone_reward_apply.province_id
     */
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * 省名称
     * 表字段 : welldone_reward_apply.province_name
     */
    public String getProvinceName() {
        return this.provinceName;
    }

    /**
     * 省名称
     * 表字段 : welldone_reward_apply.province_name
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    /**
     * 市编码
     * 表字段 : welldone_reward_apply.city_id
     */
    public String getCityId() {
        return this.cityId;
    }

    /**
     * 市编码
     * 表字段 : welldone_reward_apply.city_id
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 市名称
     * 表字段 : welldone_reward_apply.city_name
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 市名称
     * 表字段 : welldone_reward_apply.city_name
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 区县编码
     * 表字段 : welldone_reward_apply.county_id
     */
    public String getCountyId() {
        return this.countyId;
    }

    /**
     * 区县编码
     * 表字段 : welldone_reward_apply.county_id
     */
    public void setCountyId(String countyId) {
        this.countyId = countyId;
    }

    /**
     * 区县名称
     * 表字段 : welldone_reward_apply.county_name
     */
    public String getCountyName() {
        return this.countyName;
    }

    /**
     * 区县名称
     * 表字段 : welldone_reward_apply.county_name
     */
    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    /**
     * 详细地址
     * 表字段 : welldone_reward_apply.detail_address
     */
    public String getDetailAddress() {
        return this.detailAddress;
    }

    /**
     * 详细地址
     * 表字段 : welldone_reward_apply.detail_address
     */
    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    /**
     * 终端联系人
     * 表字段 : welldone_reward_apply.terminal_contact
     */
    public String getTerminalContact() {
        return this.terminalContact;
    }

    /**
     * 终端联系人
     * 表字段 : welldone_reward_apply.terminal_contact
     */
    public void setTerminalContact(String terminalContact) {
        this.terminalContact = terminalContact;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.tel
     */
    public String getTel() {
        return this.tel;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.tel
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 费用期间-开始日期
     费用期间-开始日期
     费用期间-开始日期
     费用期间-开始日期
     费用期间开始时间
     * 表字段 : welldone_reward_apply.s_date
     */
    public Date getsDate() {
        return this.sDate;
    }

    /**
     * 费用期间-开始日期
     费用期间-开始日期
     费用期间-开始日期
     费用期间-开始日期
     费用期间开始时间
     * 表字段 : welldone_reward_apply.s_date
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 费用期间-结束日期
     * 表字段 : welldone_reward_apply.e_date
     */
    public Date geteDate() {
        return this.eDate;
    }

    /**
     * 费用期间-结束日期
     * 表字段 : welldone_reward_apply.e_date
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 产品编码
     * 表字段 : welldone_reward_apply.product_id
     */
    public String getProductId() {
        return this.productId;
    }

    /**
     * 产品编码
     * 表字段 : welldone_reward_apply.product_id
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 产品名称
     * 表字段 : welldone_reward_apply.product_name
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 产品名称
     * 表字段 : welldone_reward_apply.product_name
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 供货价(分)
     * 表字段 : welldone_reward_apply.supply_price
     */
    public BigDecimal getSupplyPrice() {
        if( this.supplyPrice != null) {
            return (this.supplyPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.supplyPrice;
    }

    /**
     * 供货价(分)
     * 表字段 : welldone_reward_apply.supply_price
     */
    public void setSupplyPrice(BigDecimal supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_apply.settlement_price
     */
    public BigDecimal getSettlementPrice() {
        if( this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.settlementPrice;
    }

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_apply.settlement_price
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 保量力度
     * 表字段 : welldone_reward_apply.limit_quantity_scale
     */
    public Double getLimitQuantityScale() {
        return this.limitQuantityScale;
    }

    /**
     * 保量力度
     * 表字段 : welldone_reward_apply.limit_quantity_scale
     */
    public void setLimitQuantityScale(Double limitQuantityScale) {
        this.limitQuantityScale = limitQuantityScale;
    }

    /**
     * 单瓶保量力度(分)
     * 表字段 : welldone_reward_apply.limit_quantity_amount
     */
    public BigDecimal getLimitQuantityAmount() {
        if( this.limitQuantityAmount != null) {
            return (this.limitQuantityAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.limitQuantityAmount;
    }

    /**
     * 单瓶保量力度(分)
     * 表字段 : welldone_reward_apply.limit_quantity_amount
     */
    public void setLimitQuantityAmount(BigDecimal limitQuantityAmount) {
        this.limitQuantityAmount = limitQuantityAmount;
    }

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_apply.limit_company_rebate
     */
    public BigDecimal getLimitCompanyRebate() {
        if( this.limitCompanyRebate != null) {
            return (this.limitCompanyRebate.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.limitCompanyRebate;
    }

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_apply.limit_company_rebate
     */
    public void setLimitCompanyRebate(BigDecimal limitCompanyRebate) {
        this.limitCompanyRebate = limitCompanyRebate;
    }

    /**
     * 保量瓶数
     * 表字段 : welldone_reward_apply.buy_num
     */
    public Integer getBuyNum() {
        return this.buyNum;
    }

    /**
     * 保量瓶数
     * 表字段 : welldone_reward_apply.buy_num
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 销售金额(分)
     * 表字段 : welldone_reward_apply.total_amount
     */
    public BigDecimal getTotalAmount() {
        if( this.totalAmount != null) {
            return (this.totalAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.totalAmount;
    }

    /**
     * 销售金额(分)
     * 表字段 : welldone_reward_apply.total_amount
     */
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_apply.company_scale
     */
    public Double getCompanyScale() {
        return this.companyScale;
    }

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_apply.company_scale
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 申请金额(分)
     * 表字段 : welldone_reward_apply.apply_amount
     */
    public BigDecimal getApplyAmount() {
        if( this.applyAmount != null) {
            return (this.applyAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.applyAmount;
    }

    /**
     * 申请金额(分)
     * 表字段 : welldone_reward_apply.apply_amount
     */
    public void setApplyAmount(BigDecimal applyAmount) {
        this.applyAmount = applyAmount;
    }

    /**
     * 审核金额(分)
     * 表字段 : welldone_reward_apply.audit_mount
     */
    public BigDecimal getAuditMount() {
        if( this.auditMount != null) {
            return (this.auditMount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.auditMount;
    }

    /**
     * 审核金额(分)
     * 表字段 : welldone_reward_apply.audit_mount
     */
    public void setAuditMount(BigDecimal auditMount) {
        this.auditMount = auditMount;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_id
     */
    public String getCreateId() {
        return this.createId;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_id
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_name
     */
    public String getCreateName() {
        return this.createName;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_name
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_date
     */
    public Date getCreateDate() {
        return this.createDate;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.create_date
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_id
     */
    public String getModifyId() {
        return this.modifyId;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_id
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_name
     */
    public String getModifyName() {
        return this.modifyName;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_name
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_date
     */
    public Date getModifyDate() {
        return this.modifyDate;
    }

    /**
     *
     * 表字段 : welldone_reward_apply.modify_date
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }


    /**
     * 行项目余额
     * 表字段 : welldone_reward_apply.item_balance
     */
    public Integer getItemBalance() {
        if(itemBalance == null){
            itemBalance = 0 ;
        }
        return this.itemBalance;
    }

    /**
     * 行项目余额
     * 表字段 : welldone_reward_apply.item_balance
     */
    public void setItemBalance(Integer itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 费用类型编码
     */
    public String getCostTypeCode() {
        return this.costTypeCode;
    }

    /**
     * 设置 费用类型编码
     */
    public void setCostTypeCode(String costTypeCode) {
        if(StringUtils.isNotBlank(costTypeCode)){
            this.costTypeCode = costTypeCode;
        }
    }

    /**
     * 获取 费用类型名称
     */
    public String getCostTypeName() {
        return this.costTypeName;
    }

    /**
     * 设置 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        if(StringUtils.isNotBlank(costTypeName)){
            this.costTypeName = costTypeName;
        }
    }
}