package com.chinayanghe.tpm.cost.vo.ad;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 区域广告申请
 * AreaAdApplyDto
 * 数据库表：area_ad_apply
 */
public class AreaAdApplyVo implements Serializable {

    /**
     * 
     * 表字段 : area_ad_apply.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : area_ad_apply.apply_no
     */
    private String applyNo;

    /**
     * 行项目
     * 表字段 : area_ad_apply.item_no
     */
    private String itemNo;

    /**
     * 类型 1-区域点  2-区域面
     * 表字段 : area_ad_apply.apply_type
     */
    private Integer applyType;

    /**
     * 费用类型编码
     * 表字段 : area_ad_apply.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : area_ad_apply.cost_type_name
     */
    private String costTypeName;

    /**
     * 媒体大类编码
     * 表字段 : area_ad_apply.big_ media_code
     */
    private String bigMediaCode;

    /**
     * 媒体大类名称
     * 表字段 : area_ad_apply.big_media_name
     */
    private String bigMediaName;

    /**
     * 媒体小类编码
     * 表字段 : area_ad_apply.small_media_code
     */
    private String smallMediaCode;

    /**
     * 媒体小类名称
     * 表字段 : area_ad_apply.small_media_name
     */
    private String smallMediaName;

    /**
     * 媒体内容描述
     * 表字段 : area_ad_apply.media_content_desc
     */
    private String mediaContentDesc;

    /**
     * 推广品牌编码
     * 表字段 : area_ad_apply.brand_id
     */
    private String brandId;

    /**
     * 推广品牌名称
     * 表字段 : area_ad_apply.brand_name
     */
    private String brandName;

    /**
     * 数量
     * 表字段 : area_ad_apply.num
     */
    private Integer num;

    /**
     * 开始时间
     * 表字段 : area_ad_apply.start_time
     */
    private Date startTime;

    /**
     * 结束时间
     * 表字段 : area_ad_apply.end_time
     */
    private Date endTime;

    /**
     * 活动形式
     * 表字段 : area_ad_apply.activity_desc
     */
    private String activityDesc;

    /**
     * 实施方
     * 表字段 : area_ad_apply.implement_comany
     */
    private String implementComany;

    /**
     * 联系人
     * 表字段 : area_ad_apply.implement_user
     */
    private String implementUser;

    /**
     * 联系方式
     * 表字段 : area_ad_apply.implement_phone
     */
    private String implementPhone;

    /**
     * 备注
     * 表字段 : area_ad_apply.remark
     */
    private String remark;

    /**
     * 厂方承担比例/%
     * 表字段 : area_ad_apply.company_scale
     */
    private BigDecimal companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : area_ad_apply.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 审核金额(分)
     * 表字段 : area_ad_apply.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     * 状态
     * 表字段 : area_ad_apply.status
     */
    private Integer status;

    /**
     * 
     * 表字段 : area_ad_apply.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : area_ad_apply.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : area_ad_apply.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : area_ad_apply.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : area_ad_apply.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : area_ad_apply.modify_date
     */
    private Date modifyDate;

    /**
     * 行项目余额
     * 表字段 : area_ad_apply.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table area_ad_apply
     *
     * @mbggenerated Fri Jun 23 14:05:54 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:area_ad_apply.id
     *
     * @return area_ad_apply.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:area_ad_apply.id
     *
     * @param id the value for area_ad_apply.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:area_ad_apply.apply_no
     *
     * @return area_ad_apply.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:area_ad_apply.apply_no
     *
     * @param applyNo the value for area_ad_apply.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 行项目 字段:area_ad_apply.item_no
     *
     * @return area_ad_apply.item_no, 行项目
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目 字段:area_ad_apply.item_no
     *
     * @param itemNo the value for area_ad_apply.item_no, 行项目
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 类型 1-区域点  2-区域面 字段:area_ad_apply.apply_type
     *
     * @return area_ad_apply.apply_type, 类型 1-区域点  2-区域面
     */
    public Integer getApplyType() {
        return applyType;
    }

    /**
     * 设置 类型 1-区域点  2-区域面 字段:area_ad_apply.apply_type
     *
     * @param applyType the value for area_ad_apply.apply_type, 类型 1-区域点  2-区域面
     */
    public void setApplyType(Integer applyType) {
        this.applyType = applyType;
    }

    /**
     * 获取 费用类型编码 字段:area_ad_apply.cost_type_id
     *
     * @return area_ad_apply.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:area_ad_apply.cost_type_id
     *
     * @param costTypeId the value for area_ad_apply.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:area_ad_apply.cost_type_name
     *
     * @return area_ad_apply.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:area_ad_apply.cost_type_name
     *
     * @param costTypeName the value for area_ad_apply.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 媒体大类编码 字段:area_ad_apply.big_ media_code
     *
     * @return area_ad_apply.big_ media_code, 媒体大类编码
     */
    public String getBigMediaCode() {
        return bigMediaCode;
    }

    /**
     * 设置 媒体大类编码 字段:area_ad_apply.big_ media_code
     *
     * @param bigMediaCode the value for area_ad_apply.big_ media_code, 媒体大类编码
     */
    public void setBigMediaCode(String bigMediaCode) {
        this.bigMediaCode = bigMediaCode;
    }

    /**
     * 获取 媒体大类名称 字段:area_ad_apply.big_media_name
     *
     * @return area_ad_apply.big_media_name, 媒体大类名称
     */
    public String getBigMediaName() {
        return bigMediaName;
    }

    /**
     * 设置 媒体大类名称 字段:area_ad_apply.big_media_name
     *
     * @param bigMediaName the value for area_ad_apply.big_media_name, 媒体大类名称
     */
    public void setBigMediaName(String bigMediaName) {
        this.bigMediaName = bigMediaName;
    }

    /**
     * 获取 媒体小类编码 字段:area_ad_apply.small_media_code
     *
     * @return area_ad_apply.small_media_code, 媒体小类编码
     */
    public String getSmallMediaCode() {
        return smallMediaCode;
    }

    /**
     * 设置 媒体小类编码 字段:area_ad_apply.small_media_code
     *
     * @param smallMediaCode the value for area_ad_apply.small_media_code, 媒体小类编码
     */
    public void setSmallMediaCode(String smallMediaCode) {
        this.smallMediaCode = smallMediaCode;
    }

    /**
     * 获取 媒体小类名称 字段:area_ad_apply.small_media_name
     *
     * @return area_ad_apply.small_media_name, 媒体小类名称
     */
    public String getSmallMediaName() {
        return smallMediaName;
    }

    /**
     * 设置 媒体小类名称 字段:area_ad_apply.small_media_name
     *
     * @param smallMediaName the value for area_ad_apply.small_media_name, 媒体小类名称
     */
    public void setSmallMediaName(String smallMediaName) {
        this.smallMediaName = smallMediaName;
    }

    /**
     * 获取 媒体内容描述 字段:area_ad_apply.media_content_desc
     *
     * @return area_ad_apply.media_content_desc, 媒体内容描述
     */
    public String getMediaContentDesc() {
        return mediaContentDesc;
    }

    /**
     * 设置 媒体内容描述 字段:area_ad_apply.media_content_desc
     *
     * @param mediaContentDesc the value for area_ad_apply.media_content_desc, 媒体内容描述
     */
    public void setMediaContentDesc(String mediaContentDesc) {
        this.mediaContentDesc = mediaContentDesc;
    }

    /**
     * 获取 推广品牌编码 字段:area_ad_apply.brand_id
     *
     * @return area_ad_apply.brand_id, 推广品牌编码
     */
    public String getBrandId() {
        return brandId;
    }

    /**
     * 设置 推广品牌编码 字段:area_ad_apply.brand_id
     *
     * @param brandId the value for area_ad_apply.brand_id, 推广品牌编码
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /**
     * 获取 推广品牌名称 字段:area_ad_apply.brand_name
     *
     * @return area_ad_apply.brand_name, 推广品牌名称
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置 推广品牌名称 字段:area_ad_apply.brand_name
     *
     * @param brandName the value for area_ad_apply.brand_name, 推广品牌名称
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * 获取 数量 字段:area_ad_apply.num
     *
     * @return area_ad_apply.num, 数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 设置 数量 字段:area_ad_apply.num
     *
     * @param num the value for area_ad_apply.num, 数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }

    /**
     * 获取 开始时间 字段:area_ad_apply.start_time
     *
     * @return area_ad_apply.start_time, 开始时间
     */
    public Date getStartTime() {
        return startTime;
    }

    /**
     * 设置 开始时间 字段:area_ad_apply.start_time
     *
     * @param startTime the value for area_ad_apply.start_time, 开始时间
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 获取 结束时间 字段:area_ad_apply.end_time
     *
     * @return area_ad_apply.end_time, 结束时间
     */
    public Date getEndTime() {
        return endTime;
    }

    /**
     * 设置 结束时间 字段:area_ad_apply.end_time
     *
     * @param endTime the value for area_ad_apply.end_time, 结束时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取 活动形式 字段:area_ad_apply.activity_desc
     *
     * @return area_ad_apply.activity_desc, 活动形式
     */
    public String getActivityDesc() {
        return activityDesc;
    }

    /**
     * 设置 活动形式 字段:area_ad_apply.activity_desc
     *
     * @param activityDesc the value for area_ad_apply.activity_desc, 活动形式
     */
    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    /**
     * 获取 实施方 字段:area_ad_apply.implement_comany
     *
     * @return area_ad_apply.implement_comany, 实施方
     */
    public String getImplementComany() {
        return implementComany;
    }

    /**
     * 设置 实施方 字段:area_ad_apply.implement_comany
     *
     * @param implementComany the value for area_ad_apply.implement_comany, 实施方
     */
    public void setImplementComany(String implementComany) {
        this.implementComany = implementComany;
    }

    /**
     * 获取 联系人 字段:area_ad_apply.implement_user
     *
     * @return area_ad_apply.implement_user, 联系人
     */
    public String getImplementUser() {
        return implementUser;
    }

    /**
     * 设置 联系人 字段:area_ad_apply.implement_user
     *
     * @param implementUser the value for area_ad_apply.implement_user, 联系人
     */
    public void setImplementUser(String implementUser) {
        this.implementUser = implementUser;
    }

    /**
     * 获取 联系方式 字段:area_ad_apply.implement_phone
     *
     * @return area_ad_apply.implement_phone, 联系方式
     */
    public String getImplementPhone() {
        return implementPhone;
    }

    /**
     * 设置 联系方式 字段:area_ad_apply.implement_phone
     *
     * @param implementPhone the value for area_ad_apply.implement_phone, 联系方式
     */
    public void setImplementPhone(String implementPhone) {
        this.implementPhone = implementPhone;
    }

    /**
     * 获取 备注 字段:area_ad_apply.remark
     *
     * @return area_ad_apply.remark, 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置 备注 字段:area_ad_apply.remark
     *
     * @param remark the value for area_ad_apply.remark, 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取 厂方承担比例/% 字段:area_ad_apply.company_scale
     *
     * @return area_ad_apply.company_scale, 厂方承担比例/%
     */
    public BigDecimal getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置 厂方承担比例/% 字段:area_ad_apply.company_scale
     *
     * @param companyScale the value for area_ad_apply.company_scale, 厂方承担比例/%
     */
    public void setCompanyScale(BigDecimal companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 获取 厂方承担金额(分) 字段:area_ad_apply.company_amount
     *
     * @return area_ad_apply.company_amount, 厂方承担金额(分)
     */
    public BigDecimal getCompanyAmount() {
    	if( this.companyAmount != null) {
            return (this.companyAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return companyAmount;
    }

    /**
     * 设置 厂方承担金额(分) 字段:area_ad_apply.company_amount
     *
     * @param companyAmount the value for area_ad_apply.company_amount, 厂方承担金额(分)
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 审核金额(分) 字段:area_ad_apply.audit_amount
     *
     * @return area_ad_apply.audit_amount, 审核金额(分)
     */
    public BigDecimal getAuditAmount() {
    	if( this.auditAmount != null) {
            return (this.auditAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return auditAmount;
    }

    /**
     * 设置 审核金额(分) 字段:area_ad_apply.audit_amount
     *
     * @param auditAmount the value for area_ad_apply.audit_amount, 审核金额(分)
     */
    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取 状态 字段:area_ad_apply.status
     *
     * @return area_ad_apply.status, 状态
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置 状态 字段:area_ad_apply.status
     *
     * @param status the value for area_ad_apply.status, 状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取  字段:area_ad_apply.create_id
     *
     * @return area_ad_apply.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:area_ad_apply.create_id
     *
     * @param createId the value for area_ad_apply.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:area_ad_apply.create_name
     *
     * @return area_ad_apply.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:area_ad_apply.create_name
     *
     * @param createName the value for area_ad_apply.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:area_ad_apply.create_date
     *
     * @return area_ad_apply.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:area_ad_apply.create_date
     *
     * @param createDate the value for area_ad_apply.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:area_ad_apply.modify_id
     *
     * @return area_ad_apply.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:area_ad_apply.modify_id
     *
     * @param modifyId the value for area_ad_apply.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:area_ad_apply.modify_name
     *
     * @return area_ad_apply.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:area_ad_apply.modify_name
     *
     * @param modifyName the value for area_ad_apply.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:area_ad_apply.modify_date
     *
     * @return area_ad_apply.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:area_ad_apply.modify_date
     *
     * @param modifyDate the value for area_ad_apply.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 行项目余额 字段:area_ad_apply.item_balance
     *
     * @return area_ad_apply.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
    	if( this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return itemBalance;
    }

    /**
     * 设置 行项目余额 字段:area_ad_apply.item_balance
     *
     * @param itemBalance the value for area_ad_apply.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }
}