package com.chinayanghe.tpm.cost.vo.ad;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 区域广告核表
 * AreaAdPayDto
 * 数据库表：area_ad_pay
 */
public class AreaAdPayVo implements Serializable {

    /**
     * 
     * 表字段 : area_ad_pay.id
     */
    private Integer id;

    /**
     * 核报单号
     * 表字段 : area_ad_pay.pay_no
     */
    private String payNo;
    
   private Integer registId;//对应登记单的ID
    
    private BigDecimal itemBalance;//行项目余额
 

    /**
     * 行项目号
     * 表字段 : area_ad_pay.item_no
     */
    private String itemNo;

    /**
     * 核报类型(10租金,20装修,30人员)
     * 表字段 : area_ad_pay.pay_type
     */
    private Integer payType;

    /**
     * 登记单号
     * 表字段 : area_ad_pay.regist_no
     */
    private String registNo;

    /**
     * 登记单行项目号
     * 表字段 : area_ad_pay.regist_item_no
     */
    private String registItemNo;

    /**
     * 申请单号
     * 表字段 : area_ad_pay.apply_no
     */
    private String applyNo;

    /**
     * 费用类型编码
     * 表字段 : area_ad_pay.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型编码
     * 表字段 : area_ad_pay.cost_type_name
     */
    private String costTypeName;

    /**
     * 媒体大类编码
     * 表字段 : area_ad_pay.big_ media_code
     */
    private String bigMediaCode;

    /**
     * 媒体大类名称
     * 表字段 : area_ad_pay.big_media_name
     */
    private String bigMediaName;

    /**
     * 媒体小类编码
     * 表字段 : area_ad_pay.small_media_code
     */
    private String smallMediaCode;

    /**
     * 媒体小类名称
     * 表字段 : area_ad_pay.small_media_name
     */
    private String smallMediaName;

    /**
     * 活动形式
     * 表字段 : area_ad_pay.activity_desc
     */
    private String activityDesc;

    /**
     * 数量
     * 表字段 : area_ad_pay.num
     */
    private Integer num;

    /**
     * 核报金额(分)
     * 表字段 : area_ad_pay.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     * 督查意见
     * 表字段 : area_ad_pay.audit_notes
     */
    private String auditNotes;

    /**
     * 
     * 表字段 : area_ad_pay.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : area_ad_pay.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : area_ad_pay.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : area_ad_pay.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : area_ad_pay.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : area_ad_pay.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table area_ad_pay
     *
     * @mbggenerated Fri Jun 23 14:05:54 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:area_ad_pay.id
     *
     * @return area_ad_pay.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:area_ad_pay.id
     *
     * @param id the value for area_ad_pay.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 核报单号 字段:area_ad_pay.pay_no
     *
     * @return area_ad_pay.pay_no, 核报单号
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置 核报单号 字段:area_ad_pay.pay_no
     *
     * @param payNo the value for area_ad_pay.pay_no, 核报单号
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    /**
     * 获取 行项目号 字段:area_ad_pay.item_no
     *
     * @return area_ad_pay.item_no, 行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:area_ad_pay.item_no
     *
     * @param itemNo the value for area_ad_pay.item_no, 行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 核报类型(10租金,20装修,30人员) 字段:area_ad_pay.pay_type
     *
     * @return area_ad_pay.pay_type, 核报类型(10租金,20装修,30人员)
     */
    public Integer getPayType() {
        return payType;
    }

    /**
     * 设置 核报类型(10租金,20装修,30人员) 字段:area_ad_pay.pay_type
     *
     * @param payType the value for area_ad_pay.pay_type, 核报类型(10租金,20装修,30人员)
     */
    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    /**
     * 获取 登记单号 字段:area_ad_pay.regist_no
     *
     * @return area_ad_pay.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:area_ad_pay.regist_no
     *
     * @param registNo the value for area_ad_pay.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 登记单行项目号 字段:area_ad_pay.regist_item_no
     *
     * @return area_ad_pay.regist_item_no, 登记单行项目号
     */
    public String getRegistItemNo() {
        return registItemNo;
    }

    /**
     * 设置 登记单行项目号 字段:area_ad_pay.regist_item_no
     *
     * @param registItemNo the value for area_ad_pay.regist_item_no, 登记单行项目号
     */
    public void setRegistItemNo(String registItemNo) {
        this.registItemNo = registItemNo;
    }

    /**
     * 获取 申请单号 字段:area_ad_pay.apply_no
     *
     * @return area_ad_pay.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:area_ad_pay.apply_no
     *
     * @param applyNo the value for area_ad_pay.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 费用类型编码 字段:area_ad_pay.cost_type_id
     *
     * @return area_ad_pay.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:area_ad_pay.cost_type_id
     *
     * @param costTypeId the value for area_ad_pay.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型编码 字段:area_ad_pay.cost_type_name
     *
     * @return area_ad_pay.cost_type_name, 费用类型编码
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型编码 字段:area_ad_pay.cost_type_name
     *
     * @param costTypeName the value for area_ad_pay.cost_type_name, 费用类型编码
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 媒体大类编码 字段:area_ad_pay.big_ media_code
     *
     * @return area_ad_pay.big_ media_code, 媒体大类编码
     */
    public String getBigMediaCode() {
        return bigMediaCode;
    }

    /**
     * 设置 媒体大类编码 字段:area_ad_pay.big_ media_code
     *
     * @param bigMediaCode the value for area_ad_pay.big_ media_code, 媒体大类编码
     */
    public void setBigMediaCode(String bigMediaCode) {
        this.bigMediaCode = bigMediaCode;
    }

    /**
     * 获取 媒体大类名称 字段:area_ad_pay.big_media_name
     *
     * @return area_ad_pay.big_media_name, 媒体大类名称
     */
    public String getBigMediaName() {
        return bigMediaName;
    }

    /**
     * 设置 媒体大类名称 字段:area_ad_pay.big_media_name
     *
     * @param bigMediaName the value for area_ad_pay.big_media_name, 媒体大类名称
     */
    public void setBigMediaName(String bigMediaName) {
        this.bigMediaName = bigMediaName;
    }

    /**
     * 获取 媒体小类编码 字段:area_ad_pay.small_media_code
     *
     * @return area_ad_pay.small_media_code, 媒体小类编码
     */
    public String getSmallMediaCode() {
        return smallMediaCode;
    }

    /**
     * 设置 媒体小类编码 字段:area_ad_pay.small_media_code
     *
     * @param smallMediaCode the value for area_ad_pay.small_media_code, 媒体小类编码
     */
    public void setSmallMediaCode(String smallMediaCode) {
        this.smallMediaCode = smallMediaCode;
    }

    /**
     * 获取 媒体小类名称 字段:area_ad_pay.small_media_name
     *
     * @return area_ad_pay.small_media_name, 媒体小类名称
     */
    public String getSmallMediaName() {
        return smallMediaName;
    }

    /**
     * 设置 媒体小类名称 字段:area_ad_pay.small_media_name
     *
     * @param smallMediaName the value for area_ad_pay.small_media_name, 媒体小类名称
     */
    public void setSmallMediaName(String smallMediaName) {
        this.smallMediaName = smallMediaName;
    }

    /**
     * 获取 活动形式 字段:area_ad_pay.activity_desc
     *
     * @return area_ad_pay.activity_desc, 活动形式
     */
    public String getActivityDesc() {
        return activityDesc;
    }

    /**
     * 设置 活动形式 字段:area_ad_pay.activity_desc
     *
     * @param activityDesc the value for area_ad_pay.activity_desc, 活动形式
     */
    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    /**
     * 获取 数量 字段:area_ad_pay.num
     *
     * @return area_ad_pay.num, 数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 设置 数量 字段:area_ad_pay.num
     *
     * @param num the value for area_ad_pay.num, 数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }

    /**
     * 获取 核报金额(分) 字段:area_ad_pay.audit_amount
     *
     * @return area_ad_pay.audit_amount, 核报金额(分)
     */
    public BigDecimal getAuditAmount() {
    	if( this.auditAmount != null) {
            return (this.auditAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return auditAmount;
    }

    /**
     * 设置 核报金额(分) 字段:area_ad_pay.audit_amount
     *
     * @param auditAmount the value for area_ad_pay.audit_amount, 核报金额(分)
     */
    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取 督查意见 字段:area_ad_pay.audit_notes
     *
     * @return area_ad_pay.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    public Integer getRegistId() {
		return registId;
	}

	public void setRegistId(Integer registId) {
		this.registId = registId;
	}

	public BigDecimal getItemBalance() {
		return itemBalance;
	}

	public void setItemBalance(BigDecimal itemBalance) {
		this.itemBalance = itemBalance;
	}

	/**
     * 设置 督查意见 字段:area_ad_pay.audit_notes
     *
     * @param auditNotes the value for area_ad_pay.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取  字段:area_ad_pay.create_id
     *
     * @return area_ad_pay.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:area_ad_pay.create_id
     *
     * @param createId the value for area_ad_pay.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:area_ad_pay.create_name
     *
     * @return area_ad_pay.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:area_ad_pay.create_name
     *
     * @param createName the value for area_ad_pay.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:area_ad_pay.create_date
     *
     * @return area_ad_pay.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:area_ad_pay.create_date
     *
     * @param createDate the value for area_ad_pay.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:area_ad_pay.modify_id
     *
     * @return area_ad_pay.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:area_ad_pay.modify_id
     *
     * @param modifyId the value for area_ad_pay.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:area_ad_pay.modify_name
     *
     * @return area_ad_pay.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:area_ad_pay.modify_name
     *
     * @param modifyName the value for area_ad_pay.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:area_ad_pay.modify_date
     *
     * @return area_ad_pay.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:area_ad_pay.modify_date
     *
     * @param modifyDate the value for area_ad_pay.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}