package com.chinayanghe.tpm.cost.vo.exclusiveStore;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.function.Function;

import com.chinayanghe.tpm.cost.constants.PersonChangeStatusEnum;
import com.chinayanghe.tpm.cost.dto.ExclusiveStoreApplyDto;
import com.chinayanghe.tpm.cost.dto.ExclusiveStorePayDto;

/**
 * 专卖店支持登记
 * ExclusiveStoreRegistDto
 * 数据库表：exclusive_store_regist
 */
public class ExclusiveStoreRegistVo implements Serializable{

    /**
     * 
     * 表字段 : exclusive_store_regist.id
     */
    private Integer id;
    
    private Integer applyId;//对应申请单的ID

    /**
     * 登记单号
     * 表字段 : exclusive_store_regist.regist_no
     */
    private String registNo;

    /**
     * 行项目号
     * 表字段 : exclusive_store_regist.item_no
     */
    private String itemNo;

    /**
     * 登记类型(10租金,20装修,30人员)
     * 表字段 : exclusive_store_regist.regist_type
     */
    private Integer registType;

    /**
     * 申请单号
     * 表字段 : exclusive_store_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单行项目号
     * 表字段 : exclusive_store_regist.apply_item_no
     */
    private String applyItemNo;

    /**
     * 开始时间
     * 表字段 : exclusive_store_regist.s_date
     */
    private Date sDate;

    /**
     * 结束时间
     * 表字段 : exclusive_store_regist.e_date
     */
    private Date eDate;

    /**
     * 费用类型编码
     * 表字段 : exclusive_store_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : exclusive_store_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 终端编码
     * 表字段 : exclusive_store_regist.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : exclusive_store_regist.terminal_name
     */
    private String terminalName;

    /**
     * 省编码
     * 表字段 : exclusive_store_regist.province_id
     */
    private String provinceId;

    /**
     * 省名称
     * 表字段 : exclusive_store_regist.province_name
     */
    private String provinceName;

    /**
     * 市编码
     * 表字段 : exclusive_store_regist.city_id
     */
    private String cityId;

    /**
     * 市名称
     * 表字段 : exclusive_store_regist.city_name
     */
    private String cityName;

    /**
     * 区县编码
     * 表字段 : exclusive_store_regist.county_id
     */
    private String countyId;

    /**
     * 区县名称
     * 表字段 : exclusive_store_regist.county_name
     */
    private String countyName;

    /**
     * 乡镇街道
     * 表字段 : exclusive_store_regist.town_id
     */
    private String townId=PersonChangeStatusEnum.NORMAL.getCode();

    /**
     * 乡镇街道名称
     * 表字段 : exclusive_store_regist.town_name
     */
    private String townName=PersonChangeStatusEnum.NORMAL.getDesc();

    /**
     * 详细地址
     * 表字段 : exclusive_store_regist.address_detail
     */
    private String addressDetail;

    /**
     * 厂方承担金额(分)
     * 表字段 : exclusive_store_regist.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 联系人
     * 表字段 : exclusive_store_regist.contact
     */
    private String contact;

    /**
     * 联系人职位
     * 表字段 : exclusive_store_regist.contact_position
     */
    private String contactPosition;

    /**
     * 固定电话
     * 表字段 : exclusive_store_regist.tel
     */
    private String tel;

    /**
     * 移动电话
     * 表字段 : exclusive_store_regist.mobile_phone
     */
    private String mobilePhone;

    /**
     * 负责人
     * 表字段 : exclusive_store_regist.functionary
     */
    private String functionary;

    /**
     * 负责人固定电话
     * 表字段 : exclusive_store_regist.functionary_tel
     */
    private String functionaryTel;

    /**
     * 负责人移动电话
     * 表字段 : exclusive_store_regist.functionary_phone
     */
    private String functionaryPhone;

    /**
     * 实际产生金额(分)
     * 表字段 : exclusive_store_regist.real_amount
     */
    private BigDecimal realAmount;

    /**
     * 备注
     * 表字段 : exclusive_store_regist.notes
     */
    private String notes;

    /**
     * 行项目余额(分)
     * 表字段 : exclusive_store_regist.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 督查意见
     * 表字段 : exclusive_store_regist.audit_notes
     */
    private String auditNotes;

    /**
     * 推广品牌id
     * 表字段 : exclusive_store_regist.extension_product_id
     */
    private String extensionProductId;

    /**
     * 推广品牌名称
     * 表字段 : exclusive_store_regist.extension_product_name
     */
    private String extensionProductName;

    /**
     * 工资(分)
     * 表字段 : exclusive_store_regist.salary
     */
    private BigDecimal salary;

    /**
     * 同期销量
     * 表字段 : exclusive_store_regist.same_time_sale
     */
    private BigDecimal sameTimeSale;

    /**
     * 
     * 表字段 : exclusive_store_regist.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : exclusive_store_regist.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : exclusive_store_regist.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : exclusive_store_regist.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : exclusive_store_regist.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : exclusive_store_regist.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table exclusive_store_regist
     *
     * @mbggenerated Wed Jun 14 13:21:41 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:exclusive_store_regist.id
     *
     * @return exclusive_store_regist.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:exclusive_store_regist.id
     *
     * @param id the value for exclusive_store_regist.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 登记单号 字段:exclusive_store_regist.regist_no
     *
     * @return exclusive_store_regist.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:exclusive_store_regist.regist_no
     *
     * @param registNo the value for exclusive_store_regist.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 行项目号 字段:exclusive_store_regist.item_no
     *
     * @return exclusive_store_regist.item_no, 行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:exclusive_store_regist.item_no
     *
     * @param itemNo the value for exclusive_store_regist.item_no, 行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 登记类型(10租金,20装修,30人员) 字段:exclusive_store_regist.regist_type
     *
     * @return exclusive_store_regist.regist_type, 登记类型(10租金,20装修,30人员)
     */
    public Integer getRegistType() {
        return registType;
    }

    /**
     * 设置 登记类型(10租金,20装修,30人员) 字段:exclusive_store_regist.regist_type
     *
     * @param registType the value for exclusive_store_regist.regist_type, 登记类型(10租金,20装修,30人员)
     */
    public void setRegistType(Integer registType) {
        this.registType = registType;
    }

    /**
     * 获取 申请单号 字段:exclusive_store_regist.apply_no
     *
     * @return exclusive_store_regist.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:exclusive_store_regist.apply_no
     *
     * @param applyNo the value for exclusive_store_regist.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 申请单行项目号 字段:exclusive_store_regist.apply_item_no
     *
     * @return exclusive_store_regist.apply_item_no, 申请单行项目号
     */
    public String getApplyItemNo() {
        return applyItemNo;
    }

    /**
     * 设置 申请单行项目号 字段:exclusive_store_regist.apply_item_no
     *
     * @param applyItemNo the value for exclusive_store_regist.apply_item_no, 申请单行项目号
     */
    public void setApplyItemNo(String applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    /**
     * 获取 开始时间 字段:exclusive_store_regist.s_date
     *
     * @return exclusive_store_regist.s_date, 开始时间
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始时间 字段:exclusive_store_regist.s_date
     *
     * @param sDate the value for exclusive_store_regist.s_date, 开始时间
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束时间 字段:exclusive_store_regist.e_date
     *
     * @return exclusive_store_regist.e_date, 结束时间
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束时间 字段:exclusive_store_regist.e_date
     *
     * @param eDate the value for exclusive_store_regist.e_date, 结束时间
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 费用类型编码 字段:exclusive_store_regist.cost_type_id
     *
     * @return exclusive_store_regist.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:exclusive_store_regist.cost_type_id
     *
     * @param costTypeId the value for exclusive_store_regist.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:exclusive_store_regist.cost_type_name
     *
     * @return exclusive_store_regist.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:exclusive_store_regist.cost_type_name
     *
     * @param costTypeName the value for exclusive_store_regist.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 终端编码 字段:exclusive_store_regist.terminal_id
     *
     * @return exclusive_store_regist.terminal_id, 终端编码
     */
    public String getTerminalId() {
        return terminalId;
    }

    /**
     * 设置 终端编码 字段:exclusive_store_regist.terminal_id
     *
     * @param terminalId the value for exclusive_store_regist.terminal_id, 终端编码
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 获取 终端名称 字段:exclusive_store_regist.terminal_name
     *
     * @return exclusive_store_regist.terminal_name, 终端名称
     */
    public String getTerminalName() {
        return terminalName;
    }

    /**
     * 设置 终端名称 字段:exclusive_store_regist.terminal_name
     *
     * @param terminalName the value for exclusive_store_regist.terminal_name, 终端名称
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 获取 省编码 字段:exclusive_store_regist.province_id
     *
     * @return exclusive_store_regist.province_id, 省编码
     */
    public String getProvinceId() {
        return provinceId;
    }

    /**
     * 设置 省编码 字段:exclusive_store_regist.province_id
     *
     * @param provinceId the value for exclusive_store_regist.province_id, 省编码
     */
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * 获取 省名称 字段:exclusive_store_regist.province_name
     *
     * @return exclusive_store_regist.province_name, 省名称
     */
    public String getProvinceName() {
        return provinceName;
    }

    /**
     * 设置 省名称 字段:exclusive_store_regist.province_name
     *
     * @param provinceName the value for exclusive_store_regist.province_name, 省名称
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    /**
     * 获取 市编码 字段:exclusive_store_regist.city_id
     *
     * @return exclusive_store_regist.city_id, 市编码
     */
    public String getCityId() {
        return cityId;
    }

    /**
     * 设置 市编码 字段:exclusive_store_regist.city_id
     *
     * @param cityId the value for exclusive_store_regist.city_id, 市编码
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取 市名称 字段:exclusive_store_regist.city_name
     *
     * @return exclusive_store_regist.city_name, 市名称
     */
    public String getCityName() {
        return cityName;
    }

    /**
     * 设置 市名称 字段:exclusive_store_regist.city_name
     *
     * @param cityName the value for exclusive_store_regist.city_name, 市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取 区县编码 字段:exclusive_store_regist.county_id
     *
     * @return exclusive_store_regist.county_id, 区县编码
     */
    public String getCountyId() {
        return countyId;
    }

    /**
     * 设置 区县编码 字段:exclusive_store_regist.county_id
     *
     * @param countyId the value for exclusive_store_regist.county_id, 区县编码
     */
    public void setCountyId(String countyId) {
        this.countyId = countyId;
    }

    /**
     * 获取 区县名称 字段:exclusive_store_regist.county_name
     *
     * @return exclusive_store_regist.county_name, 区县名称
     */
    public String getCountyName() {
        return countyName;
    }

    /**
     * 设置 区县名称 字段:exclusive_store_regist.county_name
     *
     * @param countyName the value for exclusive_store_regist.county_name, 区县名称
     */
    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    /**
     * 获取 乡镇街道 字段:exclusive_store_regist.town_id
     *
     * @return exclusive_store_regist.town_id, 乡镇街道
     */
    public String getTownId() {
        return townId;
    }

    /**
     * 设置 乡镇街道 字段:exclusive_store_regist.town_id
     *
     * @param townId the value for exclusive_store_regist.town_id, 乡镇街道
     */
    public void setTownId(String townId) {
        this.townId = townId;
    }

    /**
     * 获取 乡镇街道名称 字段:exclusive_store_regist.town_name
     *
     * @return exclusive_store_regist.town_name, 乡镇街道名称
     */
    public String getTownName() {
        return townName;
    }

    /**
     * 设置 乡镇街道名称 字段:exclusive_store_regist.town_name
     *
     * @param townName the value for exclusive_store_regist.town_name, 乡镇街道名称
     */
    public void setTownName(String townName) {
        this.townName = townName;
    }

    /**
     * 获取 详细地址 字段:exclusive_store_regist.address_detail
     *
     * @return exclusive_store_regist.address_detail, 详细地址
     */
    public String getAddressDetail() {
        return addressDetail;
    }

    /**
     * 设置 详细地址 字段:exclusive_store_regist.address_detail
     *
     * @param addressDetail the value for exclusive_store_regist.address_detail, 详细地址
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 获取 厂方承担金额(分) 字段:exclusive_store_regist.company_amount
     *
     * @return exclusive_store_regist.company_amount, 厂方承担金额(分)
     */
    public BigDecimal getCompanyAmount() {
    	if( this.companyAmount != null) {
             return (this.companyAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return companyAmount;
    }

    /**
     * 设置 厂方承担金额(分) 字段:exclusive_store_regist.company_amount
     *
     * @param companyAmount the value for exclusive_store_regist.company_amount, 厂方承担金额(分)
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 联系人 字段:exclusive_store_regist.contact
     *
     * @return exclusive_store_regist.contact, 联系人
     */
    public String getContact() {
        return contact;
    }

    /**
     * 设置 联系人 字段:exclusive_store_regist.contact
     *
     * @param contact the value for exclusive_store_regist.contact, 联系人
     */
    public void setContact(String contact) {
        this.contact = contact;
    }

    /**
     * 获取 联系人职位 字段:exclusive_store_regist.contact_position
     *
     * @return exclusive_store_regist.contact_position, 联系人职位
     */
    public String getContactPosition() {
        return contactPosition;
    }

    /**
     * 设置 联系人职位 字段:exclusive_store_regist.contact_position
     *
     * @param contactPosition the value for exclusive_store_regist.contact_position, 联系人职位
     */
    public void setContactPosition(String contactPosition) {
        this.contactPosition = contactPosition;
    }

    /**
     * 获取 固定电话 字段:exclusive_store_regist.tel
     *
     * @return exclusive_store_regist.tel, 固定电话
     */
    public String getTel() {
        return tel;
    }

    /**
     * 设置 固定电话 字段:exclusive_store_regist.tel
     *
     * @param tel the value for exclusive_store_regist.tel, 固定电话
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 获取 移动电话 字段:exclusive_store_regist.mobile_phone
     *
     * @return exclusive_store_regist.mobile_phone, 移动电话
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * 设置 移动电话 字段:exclusive_store_regist.mobile_phone
     *
     * @param mobilePhone the value for exclusive_store_regist.mobile_phone, 移动电话
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    /**
     * 获取 负责人 字段:exclusive_store_regist.functionary
     *
     * @return exclusive_store_regist.functionary, 负责人
     */
    public String getFunctionary() {
        return functionary;
    }

    /**
     * 设置 负责人 字段:exclusive_store_regist.functionary
     *
     * @param functionary the value for exclusive_store_regist.functionary, 负责人
     */
    public void setFunctionary(String functionary) {
        this.functionary = functionary;
    }

    /**
     * 获取 负责人固定电话 字段:exclusive_store_regist.functionary_tel
     *
     * @return exclusive_store_regist.functionary_tel, 负责人固定电话
     */
    public String getFunctionaryTel() {
        return functionaryTel;
    }

    /**
     * 设置 负责人固定电话 字段:exclusive_store_regist.functionary_tel
     *
     * @param functionaryTel the value for exclusive_store_regist.functionary_tel, 负责人固定电话
     */
    public void setFunctionaryTel(String functionaryTel) {
        this.functionaryTel = functionaryTel;
    }

    /**
     * 获取 负责人移动电话 字段:exclusive_store_regist.functionary_phone
     *
     * @return exclusive_store_regist.functionary_phone, 负责人移动电话
     */
    public String getFunctionaryPhone() {
        return functionaryPhone;
    }

    /**
     * 设置 负责人移动电话 字段:exclusive_store_regist.functionary_phone
     *
     * @param functionaryPhone the value for exclusive_store_regist.functionary_phone, 负责人移动电话
     */
    public void setFunctionaryPhone(String functionaryPhone) {
        this.functionaryPhone = functionaryPhone;
    }

    /**
     * 获取 实际产生金额(分) 字段:exclusive_store_regist.real_amount
     *
     * @return exclusive_store_regist.real_amount, 实际产生金额(分)
     */
    public BigDecimal getRealAmount() {
    	 if( this.realAmount != null) {
             return (this.realAmount.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
         }
        return realAmount;
    }

    /**
     * 设置 实际产生金额(分) 字段:exclusive_store_regist.real_amount
     *
     * @param realAmount the value for exclusive_store_regist.real_amount, 实际产生金额(分)
     */
    public void setRealAmount(BigDecimal realAmount) {
        this.realAmount = realAmount;
    }

    /**
     * 获取 备注 字段:exclusive_store_regist.notes
     *
     * @return exclusive_store_regist.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:exclusive_store_regist.notes
     *
     * @param notes the value for exclusive_store_regist.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取 行项目余额(分) 字段:exclusive_store_regist.item_balance
     *
     * @return exclusive_store_regist.item_balance, 行项目余额(分)
     */
    public BigDecimal getItemBalance() {
    	if( this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return itemBalance;
    }

    /**
     * 设置 行项目余额(分) 字段:exclusive_store_regist.item_balance
     *
     * @param itemBalance the value for exclusive_store_regist.item_balance, 行项目余额(分)
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 督查意见 字段:exclusive_store_regist.audit_notes
     *
     * @return exclusive_store_regist.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:exclusive_store_regist.audit_notes
     *
     * @param auditNotes the value for exclusive_store_regist.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取 推广品牌id 字段:exclusive_store_regist.extension_product_id
     *
     * @return exclusive_store_regist.extension_product_id, 推广品牌id
     */
    public String getExtensionProductId() {
        return extensionProductId;
    }

    /**
     * 设置 推广品牌id 字段:exclusive_store_regist.extension_product_id
     *
     * @param extensionProductId the value for exclusive_store_regist.extension_product_id, 推广品牌id
     */
    public void setExtensionProductId(String extensionProductId) {
        this.extensionProductId = extensionProductId;
    }

    /**
     * 获取 推广品牌名称 字段:exclusive_store_regist.extension_product_name
     *
     * @return exclusive_store_regist.extension_product_name, 推广品牌名称
     */
    public String getExtensionProductName() {
        return extensionProductName;
    }

    /**
     * 设置 推广品牌名称 字段:exclusive_store_regist.extension_product_name
     *
     * @param extensionProductName the value for exclusive_store_regist.extension_product_name, 推广品牌名称
     */
    public void setExtensionProductName(String extensionProductName) {
        this.extensionProductName = extensionProductName;
    }

    /**
     * 获取 工资(分) 字段:exclusive_store_regist.salary
     *
     * @return exclusive_store_regist.salary, 工资(分)
     */
    public BigDecimal getSalary() {
    	if( this.salary != null) {
            return (this.salary.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return salary;
    }

    /**
     * 设置 工资(分) 字段:exclusive_store_regist.salary
     *
     * @param salary the value for exclusive_store_regist.salary, 工资(分)
     */
    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }

    /**
     * 获取 同期销量 字段:exclusive_store_regist.same_time_sale
     *
     * @return exclusive_store_regist.same_time_sale, 同期销量
     */
    public BigDecimal getSameTimeSale() {
    	 if( this.sameTimeSale != null) {
             return (this.sameTimeSale.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
         }
        return sameTimeSale;
    }

    /**
     * 设置 同期销量 字段:exclusive_store_regist.same_time_sale
     *
     * @param sameTimeSale the value for exclusive_store_regist.same_time_sale, 同期销量
     */
    public void setSameTimeSale(BigDecimal sameTimeSale) {
        this.sameTimeSale = sameTimeSale;
    }

    /**
     * 获取  字段:exclusive_store_regist.create_id
     *
     * @return exclusive_store_regist.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:exclusive_store_regist.create_id
     *
     * @param createId the value for exclusive_store_regist.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:exclusive_store_regist.create_name
     *
     * @return exclusive_store_regist.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:exclusive_store_regist.create_name
     *
     * @param createName the value for exclusive_store_regist.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Integer getApplyId() {
		return applyId;
	}

	public void setApplyId(Integer applyId) {
		this.applyId = applyId;
	}

	/**
     * 获取  字段:exclusive_store_regist.create_date
     *
     * @return exclusive_store_regist.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:exclusive_store_regist.create_date
     *
     * @param createDate the value for exclusive_store_regist.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:exclusive_store_regist.modify_id
     *
     * @return exclusive_store_regist.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:exclusive_store_regist.modify_id
     *
     * @param modifyId the value for exclusive_store_regist.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:exclusive_store_regist.modify_name
     *
     * @return exclusive_store_regist.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:exclusive_store_regist.modify_name
     *
     * @param modifyName the value for exclusive_store_regist.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:exclusive_store_regist.modify_date
     *
     * @return exclusive_store_regist.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:exclusive_store_regist.modify_date
     *
     * @param modifyDate the value for exclusive_store_regist.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }
}