package com.chinayanghe.tpm.cost.vo.guestReceive;

import com.chinayanghe.tpm.cost.utils.StringUtil;

import java.io.Serializable;
import java.util.Date;

/**
 * 来宾住宿用酒明细
 * GuestResideAlcoholInfo
 * 数据库表：guest_reside_alcohol_info
 */
public class GuestResideAlcoholInfoVo implements Serializable {

    private static final long serialVersionUID = 2937618085524213570L;
    /**
     * 
     * 表字段 : guest_reside_alcohol_info.id
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : guest_reside_alcohol_info.apply_no
     */
    private String applyNo;

    /**
     * 参观区域名称
     * 表字段 : guest_reside_alcohol_info.visit_area
     */
    private String visitArea;

    /**
     * 抵达日期
     * 表字段 : guest_reside_alcohol_info.s_date
     */
    private Date sDate;

    /**
     * 酒店名称
     * hotel_name
     */
    private String hotelName;

    /**
     * 入店日期
     * 表字段 : guest_reside_alcohol_info.hotel_date
     */
    private Date hotelDate;

    /**
     * 具体地址
     * exact_addr
     */
    private String exactAddr;
    /**
     * 负责人
     * wheelMan
     */
    private String wheelMan;

    /**
     * 职务
     * post
     */
    private String post;
    /**
     * 固定电话
     * telephone
     */
    private String telephone;

    /**
     * 移动电话
     * phone
     */
    private String phone;

    /**
     * 住宿标准（分/间*每天）
     * 表字段 : guest_reside_alcohol_info.reside_cost
     */
    private Long resideCost;

    /**
     * 住宿人数/人
     * 表字段 : guest_reside_alcohol_info.peoples_num
     */
    private Integer peoplesNum;

    /**
     * 住宿天数/天
     * 表字段 : guest_reside_alcohol_info.live_day
     */
    private Integer liveDay;

    /**
     * 住宿金额
     * live_amount
     */
    private Long liveAmount;

    /**
     * 用酒名称
     * 表字段 : guest_reside_alcohol_info.alcohol_name
     */
    private String alcoholName;

    /**
     * 用酒数量
     * 表字段 : guest_reside_alcohol_info.alcohol_num
     */
    private String alcoholNum;

    /**
     * 
     * 表字段 : guest_reside_alcohol_info.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : guest_reside_alcohol_info.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : guest_reside_alcohol_info.create_date
     */
    private Date createDate;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getApplyNo() {
        return applyNo;
    }

    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    public String getVisitArea() {
        return visitArea;
    }

    public void setVisitArea(String visitArea) {
        this.visitArea = visitArea;
    }

    public Date getsDate() {
        return sDate;
    }

    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    public String getHotelName() {
        return hotelName;
    }

    public void setHotelName(String hotelName) {
        this.hotelName = hotelName;
    }

    public Date getHotelDate() {
        return hotelDate;
    }

    public void setHotelDate(Date hotelDate) {
        this.hotelDate = hotelDate;
    }

    public String getExactAddr() {
        return exactAddr;
    }

    public void setExactAddr(String exactAddr) {
        this.exactAddr = exactAddr;
    }

    public String getWheelMan() {
        return wheelMan;
    }

    public void setWheelMan(String wheelMan) {
        this.wheelMan = wheelMan;
    }

    public String getPost() {
        return post;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getResideCost() {
        return StringUtil.longPriceParseStr(resideCost);
    }

    public void setResideCost(Long resideCost) {
        this.resideCost = resideCost;
    }

    public Integer getPeoplesNum() {
        return peoplesNum;
    }

    public void setPeoplesNum(Integer peoplesNum) {
        this.peoplesNum = peoplesNum;
    }

    public Integer getLiveDay() {
        return liveDay;
    }

    public void setLiveDay(Integer liveDay) {
        this.liveDay = liveDay;
    }

    public String getLiveAmount() {
        return StringUtil.longPriceParseStr(liveAmount);
    }

    public void setLiveAmount(Long liveAmount) {
        this.liveAmount = liveAmount;
    }

    public String getAlcoholName() {
        return alcoholName;
    }

    public void setAlcoholName(String alcoholName) {
        this.alcoholName = alcoholName;
    }

    public String getAlcoholNum() {
        return alcoholNum;
    }

    public void setAlcoholNum(String alcoholNum) {
        this.alcoholNum = alcoholNum;
    }

    public String getCreateId() {
        return createId;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}