/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.tpm.cost.common.handler;

import cn.com.bizunited.cp.common.es.ElasticSearchManager;
import com.chinayanghe.tpm.cost.constants.GlobalErrorMsgs;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="elasticSearchHandler")
public class ElasticSearchHandler {
    @Autowired
    private ElasticSearchManager elasticSearchManager;

    public int insertDate2Es(String index, String type, String id, String json) throws Exception {
        Client client = this.elasticSearchManager.getClient();
        BulkRequestBuilder requestBuilder = client.prepareBulk();
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        indexRequest = indexRequest.source(json);
        requestBuilder.add(indexRequest);
        BulkResponse responses = (BulkResponse)requestBuilder.execute().get();
        BulkItemResponse[] itemResponses = responses.getItems();
        if (itemResponses == null || itemResponses.length == 0 || StringUtils.isEmpty((String)itemResponses[0].getId())) {
            throw new RuntimeException(GlobalErrorMsgs.SYSTEM_ERROR.getMsg());
        }
        return itemResponses.length;
    }

    public int updateDate2Es(String index, String type, String id, String json) throws Exception {
        Client client = this.elasticSearchManager.getClient();
        UpdateRequestBuilder builder = client.prepareUpdate(index, type, id);
        builder.setDoc(json);
        UpdateResponse response = (UpdateResponse)builder.execute().get();
        if (response == null) {
            throw new RuntimeException(GlobalErrorMsgs.SYSTEM_ERROR.getMsg());
        }
        return 1;
    }
}

