/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.tpm.cost.utils;

import cn.com.bizunited.cp.common.web.utils.WebApplicationContextUtils;
import com.chinayanghe.tpm.cost.constants.Constants;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;

public final class CostGeneratorCodeUtils {
    private static final byte[] HASH_KEY = "generatorCode".getBytes();
    private static JedisConnectionFactory connectionFactory = (JedisConnectionFactory)WebApplicationContextUtils.getInstance().get("jedisConnectionFactory", JedisConnectionFactory.class);
    private static ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private CostGeneratorCodeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String code(Constants.CodeType codeType) {
        RedisConnection redisConnection = null;
        try {
            redisConnection = RedisConnectionUtils.getConnection((RedisConnectionFactory)connectionFactory);
            Long startInterVal = codeType.getIntervalType().getCodeInterval().getStartInterval();
            if (!redisConnection.hExists(HASH_KEY, codeType.formatMarkByte()).booleanValue()) {
                redisConnection.hSet(HASH_KEY, codeType.formatMarkByte(), new String(String.valueOf(startInterVal)).getBytes());
                String string = codeType.getCode().concat(String.valueOf(startInterVal));
                return string;
            }
            Long increLong = redisConnection.hIncrBy(HASH_KEY, codeType.formatMarkByte(), 1L);
            String string = codeType.getCode().concat(String.valueOf(increLong));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)connectionFactory);
        }
        throw new RuntimeException("\u751f\u6210code\u51fa\u9519!");
    }
}

