/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.tpm.cost.utils;

import cn.com.bizunited.cp.common.pagination.CommonSort;
import cn.com.bizunited.cp.common.pagination.Pageable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public final class JqGridParseUtils {
    public static String parseToUTF8(String toParseStr) {
        if (StringUtils.isNotBlank((String)toParseStr)) {
            return JqGridParseUtils.toChinese(toParseStr);
        }
        return toParseStr;
    }

    private static String toChinese(String msg) {
        if (JqGridParseUtils.isMessyCode(msg)) {
            try {
                return new String(msg.getBytes("ISO8859-1"), "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return msg;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    private static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = 0.0f;
        float count = 0.0f;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isLetterOrDigit(c)) continue;
            if (!JqGridParseUtils.isChinese(c)) {
                count += 1.0f;
            }
            chLength += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }

    public static Pageable getPageableByRequest(HttpServletRequest request) {
        String columnName = request.getParameter("sidx");
        String sort = request.getParameter("sord");
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        String sortName = columnName.replaceAll("[A-Z]+", "_$0");
        String isCount = request.getParameter("isCount");
        isCount = StringUtils.isEmpty((String)isCount) ? "true" : isCount;
        Pageable pageable = new Pageable(Integer.valueOf(StringUtils.isEmpty((String)page) ? 1 : Integer.valueOf(page)), Integer.valueOf(StringUtils.isEmpty((String)rows) ? 10 : Integer.valueOf(rows)), Boolean.valueOf(BooleanUtils.toBoolean((String)isCount)), null, new CommonSort(sortName, sort));
        pageable.getIsCount();
        return pageable;
    }

    public static Pageable getPageableByRequest(HttpServletRequest request, Integer start, Integer length) {
        String columnName = request.getParameter("sidx");
        String sort = request.getParameter("sord");
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        if (start != null && length != null) {
            page = String.valueOf(start / length + 1);
            rows = String.valueOf(length);
        }
        String sortName = columnName.replaceAll("[A-Z]+", "_$0");
        String isCount = request.getParameter("isCount");
        isCount = StringUtils.isEmpty((String)isCount) ? "true" : isCount;
        Pageable pageable = new Pageable(Integer.valueOf(StringUtils.isEmpty((String)page) ? 1 : Integer.valueOf(page)), Integer.valueOf(StringUtils.isEmpty((String)rows) ? 10 : Integer.valueOf(rows)), Boolean.valueOf(BooleanUtils.toBoolean((String)isCount)), null, new CommonSort(sortName, sort));
        pageable.getIsCount();
        return pageable;
    }

    public static CommonSort getSortByRequest(HttpServletRequest request) {
        String columnName = request.getParameter("sidx");
        String sort = request.getParameter("sord");
        String sortName = columnName.replaceAll("[A-Z]+", "_$0");
        return new CommonSort(sortName, sort);
    }

    public static enum SearchType {
        DATE,
        LIST;

    }
}

