/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.tpm.cost.utils;

public class SnowflakeIdWorker {
    private final long twepoch = 1420041600000L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 2L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 3L;
    private final long sequenceBits = 8L;
    private final long workerIdShift = 8L;
    private final long datacenterIdShift = 13L;
    private final long timestampLeftShift = 15L;
    private final long sequenceMask = 255L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long workerId;
    private long datacenterId;

    public SnowflakeIdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 3L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 3L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public static void main(String[] args) {
        SnowflakeIdWorker idWorker = new SnowflakeIdWorker(0L, 0L);
        for (int i = 0; i < 1000; ++i) {
            long id = idWorker.nextId();
            System.out.println(id);
        }
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 15 | this.datacenterId << 13 | this.workerId << 8 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }
}

