package com.chinayanghe.tpm.rpc.constants;

/**
 * 二级活动类型
 * @author gaopan
 *
 */
public enum ActivityTypeEnum {
    activity210101("210101", "全国面上广告", "country_plane_ad_regist", "country_plane_ad_apply"),
    activity210102("210102", "区域面上广告", "area_ad_regist", "area_ad_apply"),
    activity210103("210103", "区域点上广告", "area_ad_regist", "area_ad_apply"), 
    activity210201("210201", "区域点上赞助捐赠", "area_point_sponsor_regist", "area_point_sponsor_apply"),
    activity210301("210301", "区域点上事件营销", "area_point_event_regist", "area_point_event_apply"), 
    activity210302("210302", "区域面上事件营销", "area_plane_event_regist", "area_plane_event_apply"),
    activity210401("210401", "渠道劳务支出", "", ""), 
    activity210701("210701", "渠道客情维系", "channel_customer_rel_regist", "channel_customer_rel_apply"),
    activity210703("210703", "葡萄酒客情维系投入", "grapewine_ad_regist", "grapewine_ad_apply"),
    activity220301("220301", "专项费用", "", ""), 
    activity210901("210901", "门头牌制作", "doorplate_make_regist", "doorplate_make_apply"),
    activity210902("210902", "渠道宣传费", "market_channel_regist", "market_channel_apply"),
    activity210903("210903", "门头牌制作表(框架版)", "", ""),

    activity211001("211001",  "旅游服务订单","",""),
    activity220101("220101",  "常规客情","normal_promotion_regist","normal_promotion_apply"),
    activity211002("211002", "单位赠酒", "", ""), 
    activity211003("211003", "部队慰问", "troop_care_regist", "troop_care_apply"),
    activity211101("211101", "终端达标奖励", "welldone_reward_regist", "welldone_reward_apply"),
    activity211102("211102", "终端达标奖励（团购版）", "", ""),
    activity211201("211201", "酒店进场", "", ""), 
    activity211202("211202", "商超终端进场", "", ""),
    activity211301("211301", "酒店个性化产品奖励", "hotel_award_regist", "hotel_award_apply"),
    activity211401("211401", "商超条码注册", "ka_barcode_regist", "ka_barcode_apply"),
    activity211501("211501", "专卖店支持", "exclusive_store_regist", "exclusive_store_apply"), 
    activity211601("211601", "常规促销品", "normal_promotion_regist", "normal_promotion_apply"),
    activity211701("211701", "消费者促销", "", ""),
    activity211801("211801", "消费者宴席推广", "customer_feast_regist", "customer_feast_apply"),
    activity211802("211802", "家宴专用产品消费者宴席推广", "", ""),
    activity211901("211901", "个人品鉴", "", "personal_review_apply");

    private String code;
    private String desc;
    private String registTableName;
    private String applyTableName;

    ActivityTypeEnum(String code, String desc, String registTableName, String applyTableName) {
        this.code            = code;
        this.desc            = desc;
        this.registTableName = registTableName;
        this.applyTableName  = applyTableName;
    }

    public static ActivityTypeEnum codeTransforms(String code) {
        return ActivityTypeEnum.valueOf("activity" + code);
    }

    public String getApplyTableName() {
        return applyTableName;
    }

    public void setApplyTableName(String applyTableName) {
        this.applyTableName = applyTableName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getRegistTableName() {
        return registTableName;
    }

    public void setRegistTableName(String registTableName) {
        this.registTableName = registTableName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
