package com.chinayanghe.tpm.rpc.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.List;

/**
 * @ClassName: com.chinayanghe.tpm.rpc.swagger
 * Created by OmarZhang on 2017/7/9 15:54.
 */
 class ActivitFormHttpUtils extends ErroMsg{

     final static Integer SOCKET_TIME_OUT = 50000;

     final static Integer CONNECT_TIMEOUT = 50000;

     final static String COOKE_HEADER = "Cookie";

     final static String SC_MOVED_TEMPORARILY = "Location";

     final static String FIRTST_REQUEST_METHOD = "api/httpClientRedirect.jhtml";

    static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SOCKET_TIME_OUT).setConnectTimeout(CONNECT_TIMEOUT).build();


    static String getFirtstRequestMethod() {
        return FIRTST_REQUEST_METHOD;
    }


    static String getPostResponse(String url,String method,String reqBody,String sessionId) {
        HttpPost httpPost = new HttpPost(url.concat(method));
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String result = null;
        try {
            client =  HttpClients.custom().disableAutomaticRetries().setDefaultRequestConfig(requestConfig).build();
            httpPost.addHeader(new BasicHeader(COOKE_HEADER,sessionId));
            httpPost.setEntity(new StringEntity(reqBody, ContentType.APPLICATION_JSON));
            response = client.execute(httpPost);
            HttpEntity entity = response.getEntity();
            if(response.getStatusLine().getStatusCode() == HttpStatus.SC_MOVED_TEMPORARILY) {
                Header locationHeader = response.getFirstHeader(SC_MOVED_TEMPORARILY);
                if(locationHeader != null) {
                    String locationVal = locationHeader.getValue();
                    if(locationVal.startsWith("http://") || locationVal.startsWith("https://")) {
                        return SESSION_TIME_OUT;
                    }
                    return getPostResponse(url,locationHeader.getValue(),reqBody,sessionId);
                }
            }else if(response.getStatusLine().getStatusCode() ==  HttpStatus.SC_OK) {
                if(entity.getContentType().getValue().indexOf(ContentType.APPLICATION_JSON.getMimeType()) != -1) {
                    return EntityUtils.toString(entity);
                }
                return SESSION_TIME_OUT;
            }else {
                return SOURCE_OUT_FOUND;
            }
        } catch (IOException e) {
//            e.printStackTrace();
            return CONNECT_TIME_ERRO;
        }finally {
            HttpClientUtils.closeQuietly(response);
            HttpClientUtils.closeQuietly(client);
        }
        return result;
    }

    /**
     * json转对象
     *
     * @param json  JSON 字符串
     * @param clazz 转换对象
     * @return
     * @Title: toObject
     * @author: Omar(OmarZhang)
     * @date: 2016年3月10日 下午4:41:53
     */
     static <T> T toObject(String json, Class<T> clazz) {
        return JSON.parseObject(json, clazz);
    }

    /**
     * json转对象集合
     *
     * @param jsons JSON 字符串
     * @param clazz 转换对象
     * @return
     * @Title: toObjectList
     * @author Omar(OmarZhang)
     * @date 2016年3月10日 下午4:43:27
     */
     static <T> List<T> toObjectList(String jsons, Class<T> clazz) {
        return JSON.parseArray(jsons, clazz);
    }

    /**
     * 对象转换转换为JSON字符串
     *
     * @param obj 对象
     * @return String json
     * @author Omar
     */
     static String toJson(Object obj) {
        return JSON.toJSONString(obj, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
    }

}
