package com.chinayanghe.tpm.rpc.sdk;

import javax.servlet.http.HttpServletRequest;

/**
 * @ClassName: com.chinayanghe.tpm.rpc.swagger
 * Created by OmarZhang on 2017/7/9 15:33.
 */
public class RequestCookie{

    /** http*/
    private HttpServletRequest request;
    /** 表单状态*/
    private String formStatus;
    /** 表单请求路径*/
    private String formBaseUrl;
    /** 请求方法*/
    private String requestMethod;

    /**
     * constructor
     * @param request
     */
    public RequestCookie(HttpServletRequest request) {
        this.request = request;
    }

    /**
     * constructor
     * @param request httpRequest
     * @param formStatus 表单状态
     * @param formBaseUrl 表单基本请求路径 http://ip:port/basePath
     * @param requestMethod  表单的请求路径 requestMapping
     */
    public RequestCookie(HttpServletRequest request, String formStatus, String formBaseUrl, String requestMethod) {
        this.request = request;
        this.formStatus = formStatus;
        this.formBaseUrl = formBaseUrl;
        this.requestMethod = requestMethod;
    }

    /** 获取 http*/
    public HttpServletRequest getRequest() {
        return this.request;
    }

    /** 获取 表单状态*/
    public String getFormStatus() {
        return this.formStatus;
    }

    /** 获取 表单请求路径*/
    public String getFormBaseUrl() {
        return this.formBaseUrl;
    }

    /** 获取 请求方法*/
    public String getRequestMethod() {
        return this.requestMethod;
    }
}
