package com.chinayanghe.tpm.rpc.sdk;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * 表单数据调整
 * 只限工作流
 * @ClassName: com.chinayanghe.tpm.rpc.swagger
 * Created by OmarZhang on 2017/7/9 15:02.
 */
public abstract class FormDataByActivitiUtils extends ErroMsg{

    private final static String DEFAULT_COOKIE_NAME = "CURRENT_COOKIE";

    static String fomartStr = "JSESSIONID=%s";

    /**
     * 发送调用
     * @param requestBaseUrl 请求基本路径 http://ip:port/basePath
     * @param requestMethod 请求方法
     * @param formStatus 表单状态
     * @param formSessionId 表单SessionId
     * @return
     */
    public HttpFormResponseVo send(String requestBaseUrl,String requestMethod,String formStatus,String formSessionId) {
        if(isBankAnyOne(requestBaseUrl,requestBaseUrl,formSessionId,formStatus)) {
            return new HttpFormResponseVo(Boolean.FALSE,BASE_PARAMER_ERRO);
        }
        RequestParam requestParam = setRequestParam();
        if(requestMethod == null || requestParam.isEmpty()) {
            return new HttpFormResponseVo(Boolean.FALSE,PARAMER_ERRO);
        }
        HttpFormRequestVo httpFormRequestVo = new HttpFormRequestVo(requestMethod,formStatus,requestParam);
        String appendBaseURL= requestBaseUrl.endsWith("/") ? requestBaseUrl : requestBaseUrl.concat("/");
        String firstRequestMethod = ActivitFormHttpUtils.getFirtstRequestMethod();
        String reqBody = ActivitFormHttpUtils.toJson(httpFormRequestVo);
        String sessionId = String.format(fomartStr,formSessionId);
        String respBody = ActivitFormHttpUtils.getPostResponse(appendBaseURL,firstRequestMethod,reqBody,sessionId);
        return ActivitFormHttpUtils.toObject(respBody,HttpFormResponseVo.class);
    }

     /**
     * 发送调用
     * @param requestCookie
     * @return
     */
    public HttpFormResponseVo send(RequestCookie requestCookie) {
        if(requestCookie == null) {
            requestCookie = new RequestCookie(null);
        }
        HttpServletRequest httpServletRequest = requestCookie.getRequest();
        String formSessionId = null;
        if(httpServletRequest != null) {
            Cookie[] cookies = httpServletRequest.getCookies();
            if(cookies != null && cookies.length > 0) {
                for(Cookie cookie : cookies) {
                    if(DEFAULT_COOKIE_NAME.equals(cookie.getName())) {
                        formSessionId = cookie.getValue();
                        break;
                    }
                }
            }
        }
        return send(requestCookie.getFormBaseUrl(),requestCookie.getRequestMethod(),requestCookie.getFormStatus(),formSessionId);
    }

    public abstract RequestParam setRequestParam();


    Boolean isBankAnyOne(String ...args) {
        if(args == null || args.length == 0) {
            return true;
        }
        for(int i = 0 ; i<args.length ; i++) {
            String arg = args[i];
            if(arg == null || arg.trim().length() == 0) {
                return true;
            }
        }
        return false;
    }

}
