package com.chinayanghe.tpm.rpc.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.*;

/**
 * @ClassName: com.chinayanghe.tpm.rpc.swagger
 * Created by OmarZhang on 2017/7/9 15:54.
 */
class ActivitFormHttpUtils extends ErroMsg {

    final static Integer SOCKET_TIME_OUT = 50000;

    final static Integer CONNECT_TIMEOUT = 50000;

    final static String COOKE_HEADER = "Cookie";

    final static String SC_MOVED_TEMPORARILY = "Location";

    final static String FIRTST_REQUEST_METHOD = "api/httpClientRedirect.jhtml";

    final static String DEFAULT_PARAMER_MARK = "?";

    static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SOCKET_TIME_OUT).setConnectTimeout(CONNECT_TIMEOUT).build();


    static String getFirtstRequestMethod() {
        return FIRTST_REQUEST_METHOD;
    }


    static String getPostResponse(String url, String method, HttpFormRequestVo reqBody, String sessionId,Header ...headers) {
        String newUrl = url.concat(method);
        if (method.startsWith("http://") || method.startsWith("https://")) {
            newUrl = method;
        }
        HttpPost httpPost = new HttpPost(newUrl);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String result = null;
        try {
            client = HttpClients.custom().disableAutomaticRetries().setDefaultRequestConfig(requestConfig).build();
            httpPost.addHeader(new BasicHeader(COOKE_HEADER, sessionId));
            boolean isFormType = false;
            if(headers != null && headers.length > 0) {
                for(Header header : headers) {
                    httpPost.addHeader(header);
                    if(header.getValue().indexOf("application/x-www-form-urlencoded") != -1) {
                        List<NameValuePair> valuePairs = new LinkedList<NameValuePair>();
                        String returnData = null;
                            for(Map.Entry<String, Object> entry : reqBody.getArgs().entrySet()) {
                                Object val = entry.getValue();
                                if(val instanceof String) {
                                    valuePairs.add(new BasicNameValuePair(entry.getKey(), (String) val));
                                }else{
                                    valuePairs.add(new BasicNameValuePair(entry.getKey(), toJson(val)));
                                }
                            }
                        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(valuePairs, HTTP.UTF_8);
                        httpPost.setEntity(urlEncodedFormEntity);
                        isFormType = true;
                    }
                }
            //default
            }
            if(!isFormType) {
                httpPost.setEntity(new StringEntity(toJson(reqBody), ContentType.APPLICATION_JSON));
            }
            response = client.execute(httpPost);
            HttpEntity entity = response.getEntity();
            switch (response.getStatusLine().getStatusCode()) {
                case HttpStatus.SC_MOVED_TEMPORARILY:
                    Header locationHeader = response.getFirstHeader(SC_MOVED_TEMPORARILY);
                    if (locationHeader != null) {
                        String locationVal = locationHeader.getValue();
                        if (locationVal.indexOf("service=http://") != -1) {
                            return SESSION_TIME_OUT;
                        }
                        String replaceLocation = StringUtils.substringBefore(locationVal, DEFAULT_PARAMER_MARK);
                        reqBody.getArgs().clear();
                        reqBody.getArgs().putAll(locationQueryParse(locationVal));
                        return getPostResponse(url, replaceLocation, reqBody,sessionId,new BasicHeader[]{new BasicHeader("Content-Type","application/x-www-form-urlencoded;charset=UTF-8")});
                    }
                    break;
                case HttpStatus.SC_OK:
                    if (entity.getContentType().getValue().indexOf(ContentType.APPLICATION_JSON.getMimeType()) != -1) {
                        return EntityUtils.toString(entity);
                    }
                    return SESSION_TIME_OUT;
                case HttpStatus.SC_NOT_FOUND:
                    return SOURCE_OUT_FOUND;
                case HttpStatus.SC_INTERNAL_SERVER_ERROR:
                    return String.format(SERVER_ERRO_FORMART, EntityUtils.toString(entity));
                default:
                    return SERVER_ERRO;
            }
        } catch (IOException e) {
            e.printStackTrace();
            return CONNECT_TIME_ERRO;
        } finally {
            HttpClientUtils.closeQuietly(response);
            HttpClientUtils.closeQuietly(client);
        }
        return result;
    }

    /**
     * json转对象
     *
     * @param json  JSON 字符串
     * @param clazz 转换对象
     * @return
     * @Title: toObject
     * @author: Omar(OmarZhang)
     * @date: 2016年3月10日 下午4:41:53
     */
    static <T> T toObject(String json, Class<T> clazz) {
        if (json != null && !json.trim().equals("[]")) {
            return JSON.parseObject(json, clazz);
        }
        return null;
    }

    /**
     * json转对象集合
     *
     * @param jsons JSON 字符串
     * @param clazz 转换对象
     * @return
     * @Title: toObjectList
     * @author Omar(OmarZhang)
     * @date 2016年3月10日 下午4:43:27
     */
    static <T> List<T> toObjectList(String jsons, Class<T> clazz) {
        return JSON.parseArray(jsons, clazz);
    }

    /**
     * 对象转换转换为JSON字符串
     *
     * @param obj 对象
     * @return String json
     * @author Omar
     */
    static String toJson(Object obj) {
        return JSON.toJSONString(obj, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
    }

    static Map<String,Object> locationQueryParse(String locationUrl) {
        Map<String,Object> params = new HashMap<String,Object>();
        if (StringUtils.indexOf(locationUrl, DEFAULT_PARAMER_MARK) != -1) {
            String queryParms = StringUtils.substringAfter(locationUrl,DEFAULT_PARAMER_MARK);
            List<NameValuePair> decodeParamsQuery = URLEncodedUtils.parse(queryParms,Charsets.UTF_8);
            if(decodeParamsQuery != null && !decodeParamsQuery.isEmpty()) {
                for(Iterator<NameValuePair> iterator = decodeParamsQuery.iterator();iterator.hasNext();) {
                    NameValuePair nameValuePair = iterator.next();
                    params.put(nameValuePair.getName(),nameValuePair.getValue());
                }
            }
        }
        return params;
    }

}
