package com.chinayanghe.tpm.rpc.constants;

import java.util.HashMap;

/**
 * Created by wanggq on 2017/7/10.
 */
public class FormMethodUri {

    private FormMethodUri (){}
    /**区分酒店个性化为实物还是奖卡核报     0实物  1奖卡*/
    public static final String ZERO = "0";
    public static final String ONE = "1";
    public static final String PACT_AUDIT = "pact_audit";
    /**区分渠道客情维系一桌式品鉴宴会通   1 是宴会通  0 不是*/
    public static final String  FEAST_ONE = "1";
    public static final String FEAST_ZERO = "0";
    /** 用于区分门头牌普通申请与框架版申请 */
    public static final String DOOR_APPLY = "door_apply";

    private static final HashMap<String,String> uriMap = new HashMap<String, String>();

    static{
        uriMap.put(ActivityTypeEnum.activity211801.getCode()+FormTypeEnum.apply,"admin.consumerApply.updateApplyFormData");
        uriMap.put(ActivityTypeEnum.activity211801.getCode()+FormTypeEnum.regist,"admin.consumerRegistration.tempSave");
        uriMap.put(ActivityTypeEnum.activity211801.getCode()+FormTypeEnum.pay,"admin.consumerPay.tempSave");
        uriMap.put(ActivityTypeEnum.activity211801.getCode()+FormTypeEnum.reported,"admin.consumerReported.tempSave");
        /** 达标奖励 */
        uriMap.put(ActivityTypeEnum.activity211101.getCode()+FormTypeEnum.apply,"admin.welldoneApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity211101.getCode()+FormTypeEnum.regist,"admin.welldoneRegistEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity211101.getCode()+FormTypeEnum.pay,"admin.welldonePayEdit.saveDataInfo");
        /**专卖店支持*/
        uriMap.put(ActivityTypeEnum.activity211501.getCode()+FormTypeEnum.apply,"admin.cost.exclusiveStore.updateApplyFormData");
        uriMap.put(ActivityTypeEnum.activity211501.getCode()+FormTypeEnum.regist,"admin.cost.exclusiveStore.updateRegistFormData");
        uriMap.put(ActivityTypeEnum.activity211501.getCode()+FormTypeEnum.pay,"admin.cost.exclusiveStore.updatePayFormData");
        /** 常规促销品*/
        uriMap.put(ActivityTypeEnum.activity211601.getCode()+FormTypeEnum.apply,"admin.normalPromotionApply.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity211601.getCode()+FormTypeEnum.regist,"admin.normalPromotionRegist.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity211601.getCode()+FormTypeEnum.pay,"admin.normalPromotionPay.updateTempSave");
        /**个人品鉴*/
        uriMap.put(ActivityTypeEnum.activity211001.getCode()+FormTypeEnum.apply,"admin.personalTasking.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity211001.getCode()+FormTypeEnum.pay,"admin.PersonalReviewPay.savePersonalReviewApplyFormData");
        /*渠道劳务*/
        uriMap.put(ActivityTypeEnum.activity210401.getCode()+FormTypeEnum.apply,"admin.channelLabor.saveApplyFormData");
        uriMap.put(ActivityTypeEnum.activity210401.getCode()+FormTypeEnum.regist,"admin.channelLabor.saveRegisterFormData");
        uriMap.put(ActivityTypeEnum.activity210401.getCode()+FormTypeEnum.pay,"admin.channelLabor.savePayFormData");
        /*区域点上事件营销*/
        uriMap.put(ActivityTypeEnum.activity210301.getCode()+FormTypeEnum.apply,"admin.areaPointEvent.saveApplyFormData");
        uriMap.put(ActivityTypeEnum.activity210301.getCode()+FormTypeEnum.regist,"admin.areaPointEvent.saveRegisterFormData");
        uriMap.put(ActivityTypeEnum.activity210301.getCode()+FormTypeEnum.pay,"admin.areaPointEvent.savePayFormData");
        /** 单位赠酒 */
        uriMap.put(ActivityTypeEnum.activity211002.getCode()+FormTypeEnum.apply,"admin.companyGiftWineApply.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity211002.getCode()+FormTypeEnum.pay,"admin.companyGiftWinePay.saveDataInfo");
        /** 点上赞助捐赠 */
        uriMap.put(ActivityTypeEnum.activity210201.getCode()+FormTypeEnum.apply,"admin.areaPointApply.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210201.getCode()+FormTypeEnum.regist,"admin.areaPointRegist.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210201.getCode()+FormTypeEnum.reported,"admin.areaPointReported.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210201.getCode()+FormTypeEnum.pay,"admin.areaPointPay.saveDataInfo");
        /** 区域面上事件营销 */
        uriMap.put(ActivityTypeEnum.activity210302.getCode()+FormTypeEnum.apply,"admin.areaPlaneEventApply.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210302.getCode()+FormTypeEnum.regist,"admin.areaPlaneEventRegist.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210302.getCode()+FormTypeEnum.pay,"admin.areaPlaneEventPay.saveDataInfo");
        /** 门头牌 */
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.apply,"admin.doorplateApply.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.apply+DOOR_APPLY,"admin.doorplateApply.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.regist,"admin.doorplateRegist.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.pay,"admin.doorplatePay.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.pactAudit,"admin.pactAudit.saveDataInfo");
        /** 渠道宣传费*/
        uriMap.put(ActivityTypeEnum.activity210902.getCode()+FormTypeEnum.apply,"admin.marketChannelApply.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity210902.getCode()+FormTypeEnum.regist,"admin.marketChannelRegist.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity210902.getCode()+FormTypeEnum.reported,"admin.marketChannelReported.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity210902.getCode()+FormTypeEnum.pay,"admin.marketChannelPay.updateTempSave");
        /** 酒店个性化*/
        uriMap.put(ActivityTypeEnum.activity211301.getCode()+FormTypeEnum.apply,"admin.hotelAwardApply.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity211301.getCode()+FormTypeEnum.regist,"admin.hotelAwardRegist.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity211301.getCode()+FormTypeEnum.pay+ONE,"admin.hotelAwardPay.updateTempSave");
        uriMap.put(ActivityTypeEnum.activity211301.getCode()+FormTypeEnum.pay+ZERO,"admin.hotelAwardPayReal.updateTempSave");

        /**部队慰问*/
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.apply,"admin.troopCareApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.regist,"admin.troopCareRegsit.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.pay,"admin.troopCarePay.saveOrUpdateTableInfo");

        /**葡萄酒广告*/
        uriMap.put(ActivityTypeEnum.activity210104.getCode()+FormTypeEnum.apply,"admin.grapeWineAdvertApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210104.getCode()+FormTypeEnum.regist,"admin.grapeWineAdvertRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210104.getCode()+FormTypeEnum.pay,"admin.grapeWineAdvertPay.saveOrUpdateTableInfo");

        /**葡萄酒事件营销*/
        uriMap.put(ActivityTypeEnum.activity210303.getCode()+FormTypeEnum.apply,"admin.grapeWineAdvertApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210303.getCode()+FormTypeEnum.regist,"admin.grapeWineAdvertRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210303.getCode()+FormTypeEnum.pay,"admin.grapeWineAdvertPay.saveOrUpdateTableInfo");


        /**葡萄酒客情维系投入*/
        uriMap.put(ActivityTypeEnum.activity210703.getCode()+FormTypeEnum.apply,"admin.grapeWineMarketingApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210703.getCode()+FormTypeEnum.regist,"admin.grapeWineMarketingRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210703.getCode()+FormTypeEnum.pay,"admin.grapeWineMarketingPay.saveOrUpdateTableInfo");

        /**葡萄酒事件营销*/
        uriMap.put(ActivityTypeEnum.activity210202.getCode()+FormTypeEnum.apply,"admin.grapeWineMarketingApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210202.getCode()+FormTypeEnum.regist,"admin.grapeWineMarketingRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210202.getCode()+FormTypeEnum.pay,"admin.grapeWineMarketingPay.saveOrUpdateTableInfo");

        /**渠道客情一桌式品鉴*/
        uriMap.put(ActivityTypeEnum.activity210701.getCode()+FormTypeEnum.apply,"admin.channelCustomerRelApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210701.getCode()+FormTypeEnum.regist+FEAST_ONE,"admin.channelCustomerRelRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210701.getCode()+FormTypeEnum.regist+FEAST_ZERO,"admin.channelCustomerRelRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210701.getCode()+FormTypeEnum.pay,"admin.ChannelCustomerRelPay.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210701.getCode()+FormTypeEnum.reported,"admin.ChannelCustomerRelReport.saveOrUpdateTableReportInfo");

        /**渠道客情维系会议*/
        uriMap.put(ActivityTypeEnum.activity210702.getCode()+FormTypeEnum.apply,"admin.channelCustomerRelApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210702.getCode()+FormTypeEnum.regist,"admin.channelCustomerRelRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210702.getCode()+FormTypeEnum.pay,"admin.ChannelCustomerRelPay.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210702.getCode()+FormTypeEnum.reported,"admin.ChannelCustomerRelReport.saveOrUpdateTableReportInfo");
        /**渠道客情维系其他*/
        uriMap.put(ActivityTypeEnum.activity210704.getCode()+FormTypeEnum.apply,"admin.channelCustomerRelApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210704.getCode()+FormTypeEnum.regist,"admin.channelCustomerRelRegist.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity210704.getCode()+FormTypeEnum.pay,"admin.ChannelCustomerRelPay.saveOrUpdateTableInfo");

        /**区域点上广告*/
        uriMap.put(ActivityTypeEnum.activity210102.getCode()+FormTypeEnum.apply,"admin.cost.areaAd.updateApplyFormData");
        uriMap.put(ActivityTypeEnum.activity210102.getCode()+FormTypeEnum.regist,"admin.cost.areaAd.updateRegistFormData");
        uriMap.put(ActivityTypeEnum.activity210102.getCode()+FormTypeEnum.pay,"admin.cost.areaAd.updatePayFormData");
        /**区域面上广告*/
        uriMap.put(ActivityTypeEnum.activity210103.getCode()+FormTypeEnum.apply,"admin.cost.areaAd.updateApplyFormData");
        uriMap.put(ActivityTypeEnum.activity210103.getCode()+FormTypeEnum.regist,"admin.cost.areaAd.updateRegistFormData");
        uriMap.put(ActivityTypeEnum.activity210103.getCode()+FormTypeEnum.pay,"admin.cost.areaAd.updatePayFormData");
       
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.apply,"admin.troopCareApply.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.regist,"admin.troopCareRegsit.saveOrUpdateTableInfo");
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.pay,"admin.troopCarePay.saveOrUpdateTableInfo");
        /*个性化促销*/
        uriMap.put(ActivityTypeEnum.activity212701.getCode()+FormTypeEnum.apply,"admin.personalizedPromotion.saveApplyFormData");
        /**个性化奖卡延期*/
        uriMap.put(ActivityTypeEnum.activity212901.getCode()+FormTypeEnum.apply,"admin.personalAwardDelayApply.updateTempSave");
    	/*渠道劳务*/
        uriMap.put(ActivityTypeEnum.activity211003.getCode()+FormTypeEnum.pay,"admin.troopCarePay.saveOrUpdateTableInfo");
        /**常规客情*/
        uriMap.put(ActivityTypeEnum.activity220101.getCode()+FormTypeEnum.pay,"admin.cost.normalGuestfrees.saveApplyFormData");
        /**专项费用*/
        uriMap.put(ActivityTypeEnum.activity220301.getCode()+FormTypeEnum.pay,"admin.cost.specialExpenses.updateApplyFormData");
        /*全国面上广告*/
        uriMap.put(ActivityTypeEnum.activity210101.getCode()+FormTypeEnum.apply,"admin.countryPlaneAd.saveApplyFormData");
        uriMap.put(ActivityTypeEnum.activity210101.getCode()+FormTypeEnum.regist,"admin.countryPlaneAd.saveRegisterFormData");
        uriMap.put(ActivityTypeEnum.activity210101.getCode()+FormTypeEnum.pay,"admin.countryPlaneAd.savePayFormData");
        /*来宾接待*/
        uriMap.put(ActivityTypeEnum.activity212501.getCode()+FormTypeEnum.apply,"admin.guestReceive.saveApplyFormData");
        uriMap.put(ActivityTypeEnum.activity212501.getCode()+FormTypeEnum.pay,"admin.guestReceive.savePayFormData");
        
        /**旅游服务*/
        uriMap.put(ActivityTypeEnum.activity213101.getCode()+FormTypeEnum.apply,"admin.cost.travelService.updateApplyFormData");
        /** 合同鉴审 */
        uriMap.put(ActivityTypeEnum.activity210101.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210102.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210103.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210104.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210301.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210302.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity210801.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");
        uriMap.put(ActivityTypeEnum.activity211501.getCode()+FormTypeEnum.apply+PACT_AUDIT,"admin.pactAuditApplyEdit.saveDataInfo");

    }

    public static String get(String key){
        return uriMap.get(key);
    }

}
