package com.chinayanghe.tpm.rpc.rpc;

import com.chinayanghe.tpm.rpc.constants.FormTypeEnum;
import com.chinayanghe.tpm.rpc.vo.ActivityBaseInfoVo;
import com.chinayanghe.tpm.rpc.vo.ManageInfoVo;

/**
 * 流程发起表单存储接口
 * @ClassName: com.chinayanghe.tpm.cost.rpc.swagger
 * Created by OmarZhang on 2017/7/7 14:47.
 */
public interface ActivitiByFormRpcService {

    /***
     * 根据活动单号获取活动基础信息
     * @param formNo
     * @return
     */
    ActivityBaseInfoVo findActivityBaseInfoByCode(String formNo);
    
    /**
     * 判断专卖店支持是否为装修支持
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isExclusiveOrnament(String formNo);

    /**
     * 根据表单编号获取表单管理信息
     * @param formNo 表单编号
     */
    public ManageInfoVo findManageInfoVoByFormNo(String formNo);

    /**
     * 判断是否制式合同
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isPactJudge(String formNo);
    
    /**
     * 判断是否为电商部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isNetMarketing(String positionCode);
    
    /**
     * 判断是否为市场部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isMarketing(String positionCode);

    /***
     * 流程驳回
     * @param formNo  表单号
     * @param formType 表单类型 com.chinayanghe.tpm.rpc.constants.FormTypeEnum
     * @param activitiId 流程ID
     * @param userId 驳回人
     * @param activitiCode com.chinayanghe.tpm.rpc.constants.ActivityTypeEnum
     */
    BizResponseJson reject(String activitiCode,String formNo,String formType,String activitiId,String userId);
    
    /**
     * 申请金额和审批金额的处理
     * 当审批最后一个节点审批前，把申请金额更新到审批金额中，当在最后一个节点被驳回的时候，要把审批金额清0
     * @param formNo 单号
     * @param type 类型 1-申请单操作  2-核报审批   3-核报复核
     * @param flag  true -把申请金额更新到审批金额中，false-把审批金额清0
     */
    Boolean  updateApplyInfoAmt(String formNo,int type,boolean flag);
    
    /**
     * 判断洋河或双沟
     * @param formNo 单号
     * @return  1-洋河  2-双沟  3-洋河双沟
     */
    int getWineBigType(String formNo);
    
    /**
     * 判断是否为葡萄酒事业部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isWineDivision(String positionCode);


    
}
