package com.chinayanghe.tpm.rpc.constants;

/**
 * 二级活动类型
 * @author gaopan
 *
 */
public enum ActivityTypeEnum {
    activity212501("212501", "来宾接待", "", ""),
    activity210101("210101", "全国面上广告", "country_plane_ad_regist", "country_plane_ad_apply"),
    activity210102("210102", "区域面上广告", "area_ad_regist", "area_ad_apply"),
    activity210103("210103", "区域点上广告", "area_ad_regist", "area_ad_apply"), 
    activity210201("210201", "区域点上赞助捐赠", "area_point_sponsor_regist", "area_point_sponsor_apply"),
    activity210301("210301", "区域点上事件营销", "area_point_event_regist", "area_point_event_apply"), 
    activity210302("210302", "区域面上事件营销", "area_plane_event_regist", "area_plane_event_apply"),
    activity210401("210401", "渠道劳务支出", "", ""),
    activity210701("210701", "渠道客情维系一桌式品鉴", "channel_customer_rel_regist", "channel_customer_rel_apply"),
    activity210702("210702", "渠道客情维系会议", "channel_customer_rel_regist", "channel_customer_rel_apply"),
    activity210704("210704", "渠道客情维系其他", "channel_customer_rel_regist", "channel_customer_rel_apply"),
    activity210703("210703", "葡萄酒客情维系投入", "grapewine_markting_regist", "grapewine_markting_apply"),
    activity210104("210104", "葡萄酒广告申请","grapewine_ad_regist","grapewine_ad_apply"),
    activity210303("210303", "葡萄酒事件营销申请","grapewine_ad_regist","grapewine_ad_apply"),
    activity210202("210202", "葡萄酒赞助投入申请","grapewine_markting_regist", "grapewine_markting_apply"),
    activity220301("220301", "专项费用", "", ""),
    activity210801("210801", "门头牌制作", "doorplate_make_regist", "doorplate_make_apply"),
    activity210902("210901", "渠道宣传费", "market_channel_regist", "market_channel_apply"),
    activity210802("210802", "门头牌制作表(框架版)", "", ""),
    activity212121("212121", "样品酒领用申请","","sample_gain_apply"),
    activity213101("213101",  "旅游服务订单","",""),//旅游服务订单最新
    activity211901("211901",  "旅游服务订单","",""),
    activity220101("220101",  "常规客情","normal_promotion_regist","normal_promotion_apply"),
    activity211002("211002", "单位赠酒", "", ""), 
    activity211003("211003", "部队慰问", "troop_care_regist", "troop_care_apply"),
    activity211101("211101", "终端达标奖励", "welldone_reward_regist", "welldone_reward_apply"),
    activity211201("211201", "终端进场", "terminal_join_regist", "terminal_join_apply"),
    activity211301("211301", "酒店个性化产品奖励", "hotel_award_regist", "hotel_award_apply"),
    activity211401("211401", "商超条码注册", "ka_barcode_regist", "ka_barcode_apply"),
    activity211501("211501", "专卖店支持", "exclusive_store_regist", "exclusive_store_apply"), 
    activity211601("211601", "常规促销品", "normal_promotion_regist", "normal_promotion_apply"),
    activity211701("211701", "消费者促销", "", ""),
    activity211801("211801", "消费者宴席推广", "customer_feast_regist", "customer_feast_apply"),
    activity211802("211802", "家宴专用产品消费者宴席推广", "", ""),
	activity211001("211001", "个人品鉴", "", "personal_review_apply"),
    activity212701("212701", "个性化促销品", "", "personalized_promotion_apply"),
	activity212901("212901", "个性化奖卡延期", "", ""),
    activity213301("213301", "高端品牌用酒", "", ""),    
    BudgetTransfer("BudgetTransfer", "预算转移", "", ""),
    DealerBudgetTransfer("DealerBudgetTransfer", "经销商预算转移", "", "");

    private String code;
    private String desc;
    private String registTableName;
    private String applyTableName;

    ActivityTypeEnum(String code, String desc, String registTableName, String applyTableName) {
        this.code            = code;
        this.desc            = desc;
        this.registTableName = registTableName;
        this.applyTableName  = applyTableName;
    }

    public static ActivityTypeEnum codeTransforms(String code) {
        return ActivityTypeEnum.valueOf("activity" + code);
    }

    public String getApplyTableName() {
        return applyTableName;
    }

    public void setApplyTableName(String applyTableName) {
        this.applyTableName = applyTableName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getRegistTableName() {
        return registTableName;
    }

    public void setRegistTableName(String registTableName) {
        this.registTableName = registTableName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
