package com.chinayanghe.tpm.rpc.constants;

public enum ApplyFormStatusEnum {
    applyStatus10("10", "审批中"), 
    applyStatus15("15", "已审核"),
    applyStatus20("20", "部分已使用"), 
    applyStatus25("25", "完全使用"),

    // 驳回修改、已审核、部分已使用、完全使用
    applyStatus30("30", "关闭"),    // 关闭已发生核报的单据
    applyStatus31("31","终止"),
    applyStatus35("35", "未提交"),
    applyStatus40("40", "提交失败"),
    applyStatus45("45", "撤回修改"),
    applyStatus46("46", "撤回修改,再发起流程"),
    applyStatus50("50", "废弃"),    // 关闭未发生费用的单据,
    applyStatus60("60", "流程提交失败"),
    applyStatus80("80", "已核报"),
    applyStatus81("81", "未核报"),
    applyStatus82("82", "部分核报"),
   // applyStatus100("100","删除"),
    applyStatus99("99", "其它");

    
    private String value;
    private String desc;

    ApplyFormStatusEnum(String value, String desc) {
        this.value = value;
        this.desc  = desc;
    }

    /**
     * 类型转换
     *
     * @param code
     * @return
     */
    public static ApplyFormStatusEnum convertStatus(int code) {
        ApplyFormStatusEnum ret = null;

        try {
            ret = ApplyFormStatusEnum.valueOf("applyStatus" + code);
        } catch (Exception e) {
            ret = applyStatus99;
        }

        return ret;
    }

    public static void main(String[] args) {
        System.out.println(ApplyFormStatusEnum.valueOf("applyStatus35").getDesc());
        System.out.println(Integer.parseInt(ApplyFormStatusEnum.applyStatus35.getValue()));
        System.out.println(ApplyFormStatusEnum.transferStatus("35"));
    }

    /**
     * 类型转换
     *
     * @param code
     * @return
     */
    public static String transferStatus(String code) {
        String ret = null;

        try {
            ret = ApplyFormStatusEnum.valueOf("applyStatus" + code).getDesc();
        } catch (Exception e) {
            ret = applyStatus99.getDesc();
        }

        return ret;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
