package com.chinayanghe.tpm.rpc.rpc;

import java.util.List;

import com.chinayanghe.tpm.rpc.vo.*;
import com.chinayanghe.tpm.rpc.vo.budget.BudgetVo;
import com.chinayanghe.tpm.rpc.vo.financeInfo.FinanceInfoApplyVo;

/**
 * 流程发起表单存储接口
 * @ClassName: com.chinayanghe.tpm.cost.rpc.swagger
 * Created by OmarZhang on 2017/7/7 14:47.
 */
public interface ActivitiByFormRpcService {
	
	
	/**
	 * 审批日志的记录
	 * @param logVo 日志对象
	 * @return  true-记录成功  false-记录失败
	 */
	boolean saveFormAuditLog(ActivityBaseInfoLogVo logVo); 
	

    /***
     * 根据活动单号获取活动基础信息
     * @param formNo
     * @return
     */
    ActivityBaseInfoVo findActivityBaseInfoByCode(String formNo);
    
    /**
     * 判断专卖店支持是否为装修支持
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isExclusiveOrnament(String formNo);

    /**
     * 根据表单编号获取表单管理信息
     * @param formNo 表单编号
     */
    ManageInfoVo findManageInfoVoByFormNo(String formNo);

    /**
     * 判断是否制式合同
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isPactJudge(String formNo);
    
    /**
     * 判断是否为电商部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isNetMarketing(String positionCode);
    
    /**
     * 判断是否为市场部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isMarketing(String positionCode);

    /***
     * 流程驳回
     * @param formNo  表单号
     * @param formType 表单类型 com.chinayanghe.tpm.rpc.constants.FormTypeEnum
     * @param activitiId 流程ID
     * @param userId 驳回人
     * @param activitiCode com.chinayanghe.tpm.rpc.constants.ActivityTypeEnum
     */
    BizResponseJson reject(String activitiCode,String formNo,String formType,String activitiId,String userId);
    
    /**
     * 申请金额和审批金额的处理
     * 当审批最后一个节点审批前，把申请金额更新到审批金额中，当在最后一个节点被驳回的时候，要把审批金额清0
     * @param formNo 单号
     * @param type 类型 1-申请单操作  2-核报审批   3-核报复核
     * @param flag  true -把申请金额更新到审批金额中，false-把审批金额清0
     */
    Boolean  updateApplyInfoAmt(String formNo,int type,boolean flag);
    
    /**
     * 判断洋河或双沟
     * @param formNo 单号
     * @return  1-洋河、都没有  2-双沟  3-洋河双沟  
     */
    int getWineBigType(String formNo);
    
    /**
     * 判断是否为葡萄酒事业部
     * @param positionCode 岗位编号
     * @return  true-是  false-不是
     */
    Boolean isWineDivision(String positionCode);

    /***
     * 表单中断
     * 流程在稽查部节点击终止后，发起人将部可以再发次改表单。申请单，预算释放回去。
     * 登记不返回申请单余额、核报单不返回给登记单余额，核报单不释放预算，永久冻结
     * @param activitiCode 活动单号
     * @param formNo  表单号
     * @param formType 表单类型
     * @param activitiId 流程节点ID
     * @param userId  操作人
     * @return
     */
    BizResponseJson  formInterrupt(String activitiCode,String formNo,String formType,String activitiId,String userId);

    /***
     * 根据活动单号获取申请单财务信息
     * @param formNo
     * @return
     */
    FinanceInfoApplyVo findFinanceInfoApplyByFormNo(String formNo);
    
    /**
     * 判断个性化奖卡延期时间 是否超过180天
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isDelay180(String formNo);
    
    /**
     * 买赠促销判断是否有个性化奖卡金额
     * @param formNo 单号
     * @return  true-是  false-不是
     */
    Boolean isPersonalAmount(String formNo);
    
    /**
     * 根据促销类型判断流程走向：
     * 如果促销类型为奖卡买赠（常规）true
     * 如果促销类型为奖卡买赠（面上）false
     * @param formNo 单号
     */
    Boolean isPromotionType(String formNo);
    
    /**
     * 根据终端渠道类型判断流程走向：
     * 如果渠道类型为团购  true
     * 如果为其他 false
     * @param formNo 单号
     */
    Boolean isGroupChannel(String formNo);

    Boolean channelLaborAuditByVipDept(String formNo);


    /**
     * 预算转移流程条件选择
     * @param formNo
     * @return
     */
    BudgetVo budgetTransfer(String formNo);
    /***
     * 预算转移流程驳回
     * @param formNo  表单号
     * @param formType 表单类型 com.chinayanghe.tpm.rpc.constants.FormTypeEnum
     * @param activitiId 流程ID
     * @param userId 驳回人
     * @param activitiCode com.chinayanghe.tpm.rpc.constants.ActivityTypeEnum
     */
    BizResponseJson rejectBudget(String activitiCode,String formNo,String formType,String activitiId,String userId);
    
    
    
    /**
     * 判断列支渠道是否是这三个之一，根据判断结果判定流程走向 1003  1011 1014
     * @param formNo 单号
     * @return  1- 在三个列支渠道中  0-不在
     */
    int getChanelTypeValue(String formNo);
    
    
    /**
     * 手机端审批操作
     * @param transforVo
     * @return code=1000 成功   
     */
    BizResponseJson auditMobile(MobileTransforVo transforVo);

    /**
     * 获取合同关联申请单所选择的大区或分公司
     * @param formNo
     * @return
     */
    String getOrgByUserSelected(String formNo) ;

    /**
     * 判断岗位是否在梨花村配置表里存在
     * @param position
     * @return
     */
    Boolean positionIsLHVillage(String position) ;
    
    /**
     * 根据岗位查询
     * 岗位对应的申请单表单金额仍未用完的
     * @param postionCodes 
     * @return  返回申请单下仍有金额的岗位信息
     */
    List<PostionApplyInfoVo> checkoutHasApplyAmtInfosByPostion(String... postionCodes);
    

}
