package com.chinayanghe.tpm.rpc.vo;

import java.io.Serializable;
import java.util.Date;

import com.chinayanghe.tpm.rpc.constants.FormAuditTypeEnum;
import com.chinayanghe.tpm.rpc.constants.FormTypeEnum;

/**
 * 
 * ActivityBaseInfoLog
 * 数据库表：activity_base_info_log
 */
public class ActivityBaseInfoLogVo implements Serializable{
    /**
     * 表单单号（必传）
     */
    private String formNo;

    /**
     * 表单类型  FormTypeEnum枚举里取值  apply   regist   pay （必传）
     */
    private FormTypeEnum formType;

    /**
     * 操作人编码 （必传）
     */
    private String optId;

    /**
     * 操作人姓名（必传）
     */
    private String optName;
    /**
     * 操作人岗位编码（必传）
     */
    private String optPosId;
    /**
     * 操作人岗位名称(必传)
     */
    private String optPosName;
    /**
     * 流程ID
     */
    private String processId;
    /**
     * 流程名称
     */
    private String processName;
    /**
     * 节点名称
     */
    private String nodeName;
    /**
     * 节点ID
     */
    private String nodeId;


    /**
     * 操作时间
     */
    private Date optDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 核报单时用于区分审核、复核
     * 预留字段-审核时传FormAuditTypeEnum.view 复核传FormAuditTypeEnum.review 
     * 当formType=pay时，此字段（必传）
     */
    private FormAuditTypeEnum reservedField=FormAuditTypeEnum.view;

    /**
     * 获取 表单单号 字段:activity_base_info_log.form_no
     *
     * @return activity_base_info_log.form_no, 表单单号
     */
    public String getFormNo() {
        return formNo;
    }

    /**
     * 设置 表单单号 字段:activity_base_info_log.form_no
     *
     * @param formNo the value for activity_base_info_log.form_no, 表单单号
     */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /**
     * 获取 表单类型 字段:activity_base_info_log.form_type
     *
     * @return activity_base_info_log.form_type, 表单类型
     */
    public FormTypeEnum getFormType() {
        return formType;
    }

    /**
     * 设置 表单类型 字段:activity_base_info_log.form_type
     *
     * @param formType the value for activity_base_info_log.form_type, 表单类型
     */
    public void setFormType(FormTypeEnum formType) {
        this.formType = formType;
    }

    /**
     * 获取 操作人ID 字段:activity_base_info_log.opt_id
     *
     * @return activity_base_info_log.opt_id, 操作人ID
     */
    public String getOptId() {
        return optId;
    }

    /**
     * 设置 操作人ID 字段:activity_base_info_log.opt_id
     *
     * @param optId the value for activity_base_info_log.opt_id, 操作人ID
     */
    public void setOptId(String optId) {
        this.optId = optId;
    }

    /**
     * 获取 操作人姓名 字段:activity_base_info_log.opt_name
     *
     * @return activity_base_info_log.opt_name, 操作人姓名
     */
    public String getOptName() {
        return optName;
    }

    /**
     * 设置 操作人姓名 字段:activity_base_info_log.opt_name
     *
     * @param optName the value for activity_base_info_log.opt_name, 操作人姓名
     */
    public void setOptName(String optName) {
        this.optName = optName;
    }

    /**
     * 获取 操作时间 字段:activity_base_info_log.opt_date
     *
     * @return activity_base_info_log.opt_date, 操作时间
     */
    public Date getOptDate() {
        return optDate;
    }

    /**
     * 设置 操作时间 字段:activity_base_info_log.opt_date
     *
     * @param optDate the value for activity_base_info_log.opt_date, 操作时间
     */
    public void setOptDate(Date optDate) {
        this.optDate = optDate;
    }

    /**
     * 获取 备注 字段:activity_base_info_log.remark
     *
     * @return activity_base_info_log.remark, 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置 备注 字段:activity_base_info_log.remark
     *
     * @param remark the value for activity_base_info_log.remark, 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取 预留字段 字段:activity_base_info_log.reserved_field
     *
     * @return activity_base_info_log.reserved_field, 预留字段
     */
    public FormAuditTypeEnum getReservedField() {
        return reservedField;
    }

    /**
     * 设置 预留字段 字段:activity_base_info_log.reserved_field
     *
     * @param reservedField the value for activity_base_info_log.reserved_field, 预留字段
     */
    public void setReservedField(FormAuditTypeEnum reservedField) {
        this.reservedField = reservedField;
    }

	public String getOptPosId() {
		return optPosId;
	}

	public void setOptPosId(String optPosId) {
		this.optPosId = optPosId;
	}

	public String getOptPosName() {
		return optPosName;
	}

	public void setOptPosName(String optPosName) {
		this.optPosName = optPosName;
	}

	public String getProcessId() {
		return processId;
	}

	public void setProcessId(String processId) {
		this.processId = processId;
	}

	public String getProcessName() {
		return processName;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	public String getNodeName() {
		return nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	public String getNodeId() {
		return nodeId;
	}

	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}
    
    
}