/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.common.form.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.chinayanghe.common.form.sdk.ErroMsg;
import com.chinayanghe.common.form.sdk.HttpFormRequestVo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

class ActivitFormHttpUtils
extends ErroMsg {
    static final Integer SOCKET_TIME_OUT = 50000;
    static final Integer CONNECT_TIMEOUT = 50000;
    static final String COOKE_HEADER = "Cookie";
    static final String SC_MOVED_TEMPORARILY = "Location";
    static final String FIRTST_REQUEST_METHOD = "api/httpClientRedirect.jhtml";
    static final String DEFAULT_PARAMER_MARK = "?";
    static final String APPLICATION_FORM_SCHEMA = "application/x-www-form-urlencoded";
    static final String CAS_MARK_DEFAULT = "service=http://";
    static final String[] METHOD_END_PREFIX = new String[]{"do", "action"};
    static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(SOCKET_TIME_OUT.intValue()).setConnectTimeout(CONNECT_TIMEOUT.intValue()).build();

    ActivitFormHttpUtils() {
    }

    static String getFirtstRequestMethod() {
        return FIRTST_REQUEST_METHOD;
    }

    static String getFirtstRequestMethod(String requestMethod, Boolean isRedirectDefaultUrl) {
        if (BooleanUtils.toBoolean((Boolean)isRedirectDefaultUrl)) {
            return FIRTST_REQUEST_METHOD;
        }
        int index = -1;
        index = StringUtils.lastIndexOfAny((String)requestMethod, (String[])METHOD_END_PREFIX);
        if (index != -1) {
            String prefix = StringUtils.substring((String)requestMethod, (int)0, (int)(index - 1));
            String endFix = StringUtils.substring((String)requestMethod, (int)index);
            return StringUtils.replace((String)prefix, (String)".", (String)"/").concat(".").concat(endFix);
        }
        return StringUtils.replace((String)requestMethod, (String)".", (String)"/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getPostResponse(String url, String method, HttpFormRequestVo reqBody, String sessionId, Header ... headers) {
        boolean isFormType;
        String newUrl = url.concat(method);
        if (method.startsWith("http://") || method.startsWith("https://")) {
            newUrl = method;
        }
        HttpPost httpPost = new HttpPost(newUrl);
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String result = null;
        try {
            client = HttpClients.custom().disableAutomaticRetries().setDefaultRequestConfig(requestConfig).build();
            httpPost.addHeader((Header)new BasicHeader(COOKE_HEADER, sessionId));
            isFormType = false;
            if (headers != null && headers.length > 0) {
                for (Object header : headers) {
                    httpPost.addHeader(header);
                    if (header.getValue().indexOf(APPLICATION_FORM_SCHEMA) == -1) continue;
                    LinkedList<BasicNameValuePair> valuePairs = new LinkedList<BasicNameValuePair>();
                    for (Map.Entry<String, Object> entry : reqBody.getArgs().entrySet()) {
                        Object val = entry.getValue();
                        if (val instanceof String) {
                            valuePairs.add(new BasicNameValuePair(entry.getKey(), (String)val));
                            continue;
                        }
                        valuePairs.add(new BasicNameValuePair(entry.getKey(), ActivitFormHttpUtils.toJson(val)));
                    }
                    UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(valuePairs, "UTF-8");
                    httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
                    isFormType = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Header[] headerArray = "\u8fde\u63a5\u8d85\u65f6!";
            return headerArray;
        }
        if (!isFormType) {
            httpPost.setEntity((HttpEntity)new StringEntity(ActivitFormHttpUtils.toJson(reqBody), ContentType.APPLICATION_JSON));
        }
        response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        switch (response.getStatusLine().getStatusCode()) {
            case 302: {
                Header locationHeader = response.getFirstHeader(SC_MOVED_TEMPORARILY);
                if (locationHeader == null) break;
                String locationVal = locationHeader.getValue();
                if (locationVal.indexOf(CAS_MARK_DEFAULT) != -1) {
                    Object header;
                    header = "{\"isSuccess\":false,\"message\":\"\u8868\u5355sessionId\u8fc7\u671f\"}";
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                    HttpClientUtils.closeQuietly((HttpClient)client);
                    return header;
                }
                String replaceLocation = StringUtils.substringBefore((String)locationVal, (String)DEFAULT_PARAMER_MARK);
                reqBody.getArgs().putAll(ActivitFormHttpUtils.locationQueryParse(locationVal));
                String string = ActivitFormHttpUtils.getPostResponse(url, replaceLocation, reqBody, sessionId, (Header[])new BasicHeader[]{new BasicHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8")});
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                return string;
            }
            case 200: {
                if (entity.getContentType().getValue().indexOf(ContentType.APPLICATION_JSON.getMimeType()) != -1) {
                    String string = EntityUtils.toString((HttpEntity)entity);
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                    HttpClientUtils.closeQuietly((HttpClient)client);
                    return string;
                }
                String string = "{\"isSuccess\":false,\"message\":\"\u8868\u5355sessionId\u8fc7\u671f\"}";
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                return string;
            }
            case 404: {
                String string = "{\"isSuccess\":false,\"message\":\"\u8d44\u6e90\u672a\u627e\u5230\"}";
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                return string;
            }
            case 500: {
                String string = String.format("{\"isSuccess\":false,\"message\":\"\u8c03\u7528\u670d\u52a1\u5185\u90e8\u9519\u8bef:%s\"}", EntityUtils.toString((HttpEntity)entity));
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                return string;
            }
            default: {
                String string = "{\"isSuccess\":false,\"message\":\"\u8c03\u7528\u5f02\u5e38,\u8bf7\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\"}";
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                return string;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        return result;
        finally {
            HttpClientUtils.closeQuietly(response);
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
    }

    static <T> T toObject(String json, Class<T> clazz) {
        if (json != null && !json.trim().equals("[]")) {
            return (T)JSON.parseObject((String)json, clazz);
        }
        return null;
    }

    static <T> List<T> toObjectList(String jsons, Class<T> clazz) {
        return JSON.parseArray((String)jsons, clazz);
    }

    static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }

    static Map<String, Object> locationQueryParse(String locationUrl) {
        String queryParms;
        List decodeParamsQuery;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.indexOf((String)locationUrl, (String)DEFAULT_PARAMER_MARK) != -1 && (decodeParamsQuery = URLEncodedUtils.parse((String)(queryParms = StringUtils.substringAfter((String)locationUrl, (String)DEFAULT_PARAMER_MARK)), (Charset)Charsets.UTF_8)) != null && !decodeParamsQuery.isEmpty()) {
            for (NameValuePair nameValuePair : decodeParamsQuery) {
                params.put(nameValuePair.getName(), nameValuePair.getValue());
            }
        }
        return params;
    }
}

