/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class RenameFileCommand
extends XMLCommand
implements IPostCommand {
    private String fileName;
    private String newFileName;
    private boolean renamed;
    private boolean addRenameNode;

    @Override
    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (this.addRenameNode) {
            this.createRenamedFileNode(rootElement);
        }
    }

    private void createRenamedFileNode(Element rootElement) {
        Element element = this.creator.getDocument().createElement("RenamedFile");
        element.setAttribute("name", this.fileName);
        if (this.renamed) {
            element.setAttribute("newName", this.newFileName);
        }
        rootElement.appendChild(element);
    }

    @Override
    protected int getDataForXml() {
        File newFile;
        File file;
        block17: {
            File dir;
            block16: {
                block15: {
                    int checkFileExt;
                    if (!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 64)) {
                        return 103;
                    }
                    if (this.configuration.forceASCII()) {
                        this.newFileName = FileUtils.convertToASCII(this.newFileName);
                    }
                    if (this.fileName != null && !this.fileName.equals("") && this.newFileName != null && !this.newFileName.equals("")) {
                        this.addRenameNode = true;
                    }
                    if ((checkFileExt = FileUtils.checkFileExtension(this.newFileName, this.configuration.getTypes().get(this.type))) == 1) {
                        return 105;
                    }
                    if (this.configuration.ckeckDoubleFileExtensions()) {
                        this.newFileName = FileUtils.renameFileWithBadExt(this.configuration.getTypes().get(this.type), this.newFileName);
                    }
                    if (!FileUtils.checkFileName(this.fileName) || FileUtils.checkIfFileIsHidden(this.fileName, this.configuration)) {
                        return 109;
                    }
                    if (!FileUtils.checkFileName(this.newFileName, this.configuration) || FileUtils.checkIfFileIsHidden(this.newFileName, this.configuration)) {
                        return 102;
                    }
                    if (FileUtils.checkFileExtension(this.fileName, this.configuration.getTypes().get(this.type)) == 1) {
                        return 109;
                    }
                    String dirPath = String.valueOf(this.configuration.getTypes().get(this.type).getPath()) + this.currentFolder;
                    file = new File(dirPath, this.fileName);
                    newFile = new File(dirPath, this.newFileName);
                    dir = new File(dirPath);
                    try {
                        if (file.exists()) break block15;
                        return 117;
                    }
                    catch (SecurityException e) {
                        if (this.configuration.isDebugMode()) {
                            throw e;
                        }
                        return 104;
                    }
                }
                if (!newFile.exists()) break block16;
                return 115;
            }
            if (dir.canWrite() && file.canWrite()) break block17;
            return 104;
        }
        this.renamed = file.renameTo(newFile);
        if (this.renamed) {
            this.renameThumb();
            return 0;
        }
        return 104;
    }

    private void renameThumb() {
        File thumbFile = new File(String.valueOf(this.configuration.getThumbsPath()) + File.separator + this.type + this.currentFolder, this.fileName);
        File newThumbFile = new File(String.valueOf(this.configuration.getThumbsPath()) + File.separator + this.type + this.currentFolder, this.newFileName);
        thumbFile.renameTo(newThumbFile);
    }

    @Override
    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, new Object[0]);
        this.fileName = this.getParameter(request, "fileName");
        this.newFileName = this.getParameter(request, "newFileName");
    }
}

