/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.plugins;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.BeforeExecuteCommandEventArgs;
import com.ckfinder.connector.data.EventArgs;
import com.ckfinder.connector.data.IEventHandler;
import com.ckfinder.connector.data.ResourceType;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class ImageResizeInfoCommand
extends XMLCommand
implements IEventHandler {
    private int imageWidth;
    private int imageHeight;
    private String fileName;

    public boolean runEventHandler(EventArgs args, IConfiguration configuration1) throws ConnectorException {
        BeforeExecuteCommandEventArgs args1 = (BeforeExecuteCommandEventArgs)args;
        if ("ImageResizeInfo".equals(args1.getCommand())) {
            this.runCommand(args1.getRequest(), args1.getResponse(), configuration1, new Object[0]);
            return false;
        }
        return true;
    }

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (errorNum == 0) {
            this.createImageInfoNode(rootElement);
        }
    }

    private void createImageInfoNode(Element rootElement) {
        Element element = this.creator.getDocument().createElement("ImageInfo");
        element.setAttribute("width", String.valueOf(this.imageWidth));
        element.setAttribute("height", String.valueOf(this.imageHeight));
        rootElement.appendChild(element);
    }

    protected int getDataForXml() {
        if (!AccessControlUtil.getInstance((IConfiguration)this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 16)) {
            return 103;
        }
        if (this.fileName == null || this.fileName.equals("")) {
            return 109;
        }
        if (FileUtils.checkFileExtension((String)this.fileName, (ResourceType)((ResourceType)this.configuration.getTypes().get(this.type))) == 1) {
            return 109;
        }
        File imageFile = new File(((ResourceType)this.configuration.getTypes().get(this.type)).getPath() + this.currentFolder, this.fileName);
        try {
            if (!imageFile.exists() || !imageFile.isFile()) {
                return 117;
            }
            BufferedImage image = ImageIO.read(imageFile);
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
        }
        catch (SecurityException e) {
            if (this.configuration.isDebugMode()) {
                this.exception = e;
            }
            return 104;
        }
        catch (IOException e) {
            if (this.configuration.isDebugMode()) {
                this.exception = e;
            }
            return 104;
        }
        return 0;
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, params);
        this.imageHeight = 0;
        this.imageWidth = 0;
        this.currentFolder = request.getParameter("currentFolder");
        this.type = request.getParameter("type");
        this.fileName = request.getParameter("fileName");
    }
}

